<?php

/**
 * XrpTx Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * XrpTx Model
 */
class XrpTx extends AbstractModel {

    public const _D = null;
    protected static $_name = "XrpTx";
    protected static $_definition = [
        "hash" => ["hash", "string", null, "getHash", "setHash", null, ["r" => 0]], 
        "ledger_index" => ["ledger_index", "float", null, "getLedgerIndex", "setLedgerIndex", null, ["r" => 0]], 
        "account" => ["Account", "string", null, "getAccount", "setAccount", null, ["r" => 0]], 
        "amount" => ["Amount", "string", null, "getAmount", "setAmount", null, ["r" => 0]], 
        "destination" => ["Destination", "string", null, "getDestination", "setDestination", null, ["r" => 0]], 
        "fee" => ["Fee", "string", null, "getFee", "setFee", null, ["r" => 0]], 
        "transaction_type" => ["TransactionType", "string", null, "getTransactionType", "setTransactionType", null, ["r" => 0]], 
        "flags" => ["Flags", "float", null, "getFlags", "setFlags", null, ["r" => 0]], 
        "last_ledger_sequence" => ["LastLedgerSequence", "float", null, "getLastLedgerSequence", "setLastLedgerSequence", null, ["r" => 0]], 
        "sequence" => ["Sequence", "float", null, "getSequence", "setSequence", null, ["r" => 0]], 
        "date" => ["date", "float", null, "getDate", "setDate", null, ["r" => 0]], 
        "in_ledger" => ["inLedger", "float", null, "getInLedger", "setInLedger", null, ["r" => 0]], 
        "signing_pub_key" => ["SigningPubKey", "string", null, "getSigningPubKey", "setSigningPubKey", null, ["r" => 0]], 
        "txn_signature" => ["TxnSignature", "string", null, "getTxnSignature", "setTxnSignature", null, ["r" => 0]], 
        "meta" => ["meta", "\Tatum\Model\XrpTxMeta", null, "getMeta", "setMeta", null, ["r" => 0]], 
        "validated" => ["validated", "bool", null, "getValidated", "setValidated", null, ["r" => 0]]
    ];

    /**
     * XrpTx
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get hash
     *
     * @return string|null
     */
    public function getHash(): ?string {
        return $this->_data["hash"];
    }

    /**
     * Set hash
     * 
     * @param string|null $hash The SHA-512 hash of the transaction
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setHash(?string $hash) {
        return $this->_set("hash", $hash);
    }

    /**
     * Get ledger_index
     *
     * @return float|null
     */
    public function getLedgerIndex(): ?float {
        return $this->_data["ledger_index"];
    }

    /**
     * Set ledger_index
     * 
     * @param float|null $ledger_index The ledger index of the ledger that includes this transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setLedgerIndex(?float $ledger_index) {
        return $this->_set("ledger_index", $ledger_index);
    }

    /**
     * Get account
     *
     * @return string|null
     */
    public function getAccount(): ?string {
        return $this->_data["account"];
    }

    /**
     * Set account
     * 
     * @param string|null $account The unique address of the account that initiated the transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAccount(?string $account) {
        return $this->_set("account", $account);
    }

    /**
     * Get amount
     *
     * @return string|null
     */
    public function getAmount(): ?string {
        return $this->_data["amount"];
    }

    /**
     * Set amount
     * 
     * @param string|null $amount Amount of transaction, in drops. 1 drop = 0.000001 XRP.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAmount(?string $amount) {
        return $this->_set("amount", $amount);
    }

    /**
     * Get destination
     *
     * @return string|null
     */
    public function getDestination(): ?string {
        return $this->_data["destination"];
    }

    /**
     * Set destination
     * 
     * @param string|null $destination Recipient account address.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setDestination(?string $destination) {
        return $this->_set("destination", $destination);
    }

    /**
     * Get fee
     *
     * @return string|null
     */
    public function getFee(): ?string {
        return $this->_data["fee"];
    }

    /**
     * Set fee
     * 
     * @param string|null $fee Integer amount of XRP, in drops, to be destroyed as a cost for distributing this transaction to the network. Some transaction types have different minimum requirements.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setFee(?string $fee) {
        return $this->_set("fee", $fee);
    }

    /**
     * Get transaction_type
     *
     * @return string|null
     */
    public function getTransactionType(): ?string {
        return $this->_data["transaction_type"];
    }

    /**
     * Set transaction_type
     * 
     * @param string|null $transaction_type Type of the transaction. XRp supports more than 18 transaction types. For the payment, Payment type is used.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTransactionType(?string $transaction_type) {
        return $this->_set("transaction_type", $transaction_type);
    }

    /**
     * Get flags
     *
     * @return float|null
     */
    public function getFlags(): ?float {
        return $this->_data["flags"];
    }

    /**
     * Set flags
     * 
     * @param float|null $flags Set of bit-flags for this transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setFlags(?float $flags) {
        return $this->_set("flags", $flags);
    }

    /**
     * Get last_ledger_sequence
     *
     * @return float|null
     */
    public function getLastLedgerSequence(): ?float {
        return $this->_data["last_ledger_sequence"];
    }

    /**
     * Set last_ledger_sequence
     * 
     * @param float|null $last_ledger_sequence Last ledger, in which this transaction could have occured.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setLastLedgerSequence(?float $last_ledger_sequence) {
        return $this->_set("last_ledger_sequence", $last_ledger_sequence);
    }

    /**
     * Get sequence
     *
     * @return float|null
     */
    public function getSequence(): ?float {
        return $this->_data["sequence"];
    }

    /**
     * Set sequence
     * 
     * @param float|null $sequence The sequence number of the account sending the transaction. A transaction is only valid if the Sequence number is exactly 1 greater than the previous transaction from the same account.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSequence(?float $sequence) {
        return $this->_set("sequence", $sequence);
    }

    /**
     * Get date
     *
     * @return float|null
     */
    public function getDate(): ?float {
        return $this->_data["date"];
    }

    /**
     * Set date
     * 
     * @param float|null $date Timestamp of the transaction, in Ripple epoch (946684800 seconds after Unix Epoch)
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setDate(?float $date) {
        return $this->_set("date", $date);
    }

    /**
     * Get in_ledger
     *
     * @return float|null
     */
    public function getInLedger(): ?float {
        return $this->_data["in_ledger"];
    }

    /**
     * Set in_ledger
     * 
     * @param float|null $in_ledger Ledger, in which transaction took place.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setInLedger(?float $in_ledger) {
        return $this->_set("in_ledger", $in_ledger);
    }

    /**
     * Get signing_pub_key
     *
     * @return string|null
     */
    public function getSigningPubKey(): ?string {
        return $this->_data["signing_pub_key"];
    }

    /**
     * Set signing_pub_key
     * 
     * @param string|null $signing_pub_key signing_pub_key
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSigningPubKey(?string $signing_pub_key) {
        return $this->_set("signing_pub_key", $signing_pub_key);
    }

    /**
     * Get txn_signature
     *
     * @return string|null
     */
    public function getTxnSignature(): ?string {
        return $this->_data["txn_signature"];
    }

    /**
     * Set txn_signature
     * 
     * @param string|null $txn_signature txn_signature
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTxnSignature(?string $txn_signature) {
        return $this->_set("txn_signature", $txn_signature);
    }

    /**
     * Get meta
     *
     * @return \Tatum\Model\XrpTxMeta|null
     */
    public function getMeta(): ?\Tatum\Model\XrpTxMeta {
        return $this->_data["meta"];
    }

    /**
     * Set meta
     * 
     * @param \Tatum\Model\XrpTxMeta|null $meta meta
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setMeta(?\Tatum\Model\XrpTxMeta $meta) {
        return $this->_set("meta", $meta);
    }

    /**
     * Get validated
     *
     * @return bool|null
     */
    public function getValidated(): ?bool {
        return $this->_data["validated"];
    }

    /**
     * Set validated
     * 
     * @param bool|null $validated Whether or not the transaction is included in a validated ledger. Any transaction not yet in a validated ledger is subject to change.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setValidated(?bool $validated) {
        return $this->_set("validated", $validated);
    }
}
