<?php

/**
 * XrpLedger_ledger Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * XrpLedger_ledger Model
 * 
 * @description The complete header data of this ledger.
 */
class XrpLedgerLedger extends AbstractModel {

    public const _D = null;
    protected static $_name = "XrpLedger_ledger";
    protected static $_definition = [
        "accepted" => ["accepted", "bool", null, "getAccepted", "setAccepted", null, ["r" => 0]], 
        "account_hash" => ["account_hash", "string", null, "getAccountHash", "setAccountHash", null, ["r" => 0]], 
        "close_flags" => ["close_flags", "int", null, "getCloseFlags", "setCloseFlags", null, ["r" => 0]], 
        "close_time" => ["close_time", "int", null, "getCloseTime", "setCloseTime", null, ["r" => 0]], 
        "close_time_human" => ["close_time_human", "string", null, "getCloseTimeHuman", "setCloseTimeHuman", null, ["r" => 0]], 
        "close_time_resolution" => ["close_time_resolution", "int", null, "getCloseTimeResolution", "setCloseTimeResolution", null, ["r" => 0]], 
        "closed" => ["closed", "bool", null, "getClosed", "setClosed", null, ["r" => 0]], 
        "hash" => ["hash", "string", null, "getHash", "setHash", null, ["r" => 0]], 
        "ledger_hash" => ["ledger_hash", "string", null, "getLedgerHash", "setLedgerHash", null, ["r" => 0]], 
        "ledger_index" => ["ledger_index", "string", null, "getLedgerIndex", "setLedgerIndex", null, ["r" => 0]], 
        "parent_close_time" => ["parent_close_time", "int", null, "getParentCloseTime", "setParentCloseTime", null, ["r" => 0]], 
        "parent_hash" => ["parent_hash", "string", null, "getParentHash", "setParentHash", null, ["r" => 0]], 
        "seq_num" => ["seqNum", "string", null, "getSeqNum", "setSeqNum", null, ["r" => 0]], 
        "total_coins" => ["totalCoins", "string", null, "getTotalCoins", "setTotalCoins", null, ["r" => 0]], 
        "total_coins" => ["total_coins", "string", null, "getTotalCoins", "setTotalCoins", null, ["r" => 0]], 
        "transaction_hash" => ["transaction_hash", "string", null, "getTransactionHash", "setTransactionHash", null, ["r" => 0]], 
        "transactions" => ["transactions", "\Tatum\Model\XrpTx[]", null, "getTransactions", "setTransactions", null, ["r" => 0, "c" => 1]]
    ];

    /**
     * XrpLedgerLedger
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get accepted
     *
     * @return bool|null
     */
    public function getAccepted(): ?bool {
        return $this->_data["accepted"];
    }

    /**
     * Set accepted
     * 
     * @param bool|null $accepted accepted
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAccepted(?bool $accepted) {
        return $this->_set("accepted", $accepted);
    }

    /**
     * Get account_hash
     *
     * @return string|null
     */
    public function getAccountHash(): ?string {
        return $this->_data["account_hash"];
    }

    /**
     * Set account_hash
     * 
     * @param string|null $account_hash Hash of all account state information in this ledger, as hex.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAccountHash(?string $account_hash) {
        return $this->_set("account_hash", $account_hash);
    }

    /**
     * Get close_flags
     *
     * @return int|null
     */
    public function getCloseFlags(): ?int {
        return $this->_data["close_flags"];
    }

    /**
     * Set close_flags
     * 
     * @param int|null $close_flags A bit-map of flags relating to the closing of this ledger. Currently, the ledger has only one flag defined for close_flags: sLCF_NoConsensusTime (value 1). If this flag is enabled, it means that validators were in conflict regarding the correct close time for the ledger, but build otherwise the same ledger, so they declared consensus while \"agreeing to disagree\" on the close time. In this case, the consensus ledger contains a close_time that is 1 second after that of the previous ledger. (In this case, there is no official close time, but the actual real-world close time is probably 3-6 seconds later than the specified close_time.)
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setCloseFlags(?int $close_flags) {
        return $this->_set("close_flags", $close_flags);
    }

    /**
     * Get close_time
     *
     * @return int|null
     */
    public function getCloseTime(): ?int {
        return $this->_data["close_time"];
    }

    /**
     * Set close_time
     * 
     * @param int|null $close_time The time this ledger was closed, in seconds since the Ripple Epoch
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setCloseTime(?int $close_time) {
        return $this->_set("close_time", $close_time);
    }

    /**
     * Get close_time_human
     *
     * @return string|null
     */
    public function getCloseTimeHuman(): ?string {
        return $this->_data["close_time_human"];
    }

    /**
     * Set close_time_human
     * 
     * @param string|null $close_time_human The time this ledger was closed, in human-readable format. Always uses the UTC time zone.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setCloseTimeHuman(?string $close_time_human) {
        return $this->_set("close_time_human", $close_time_human);
    }

    /**
     * Get close_time_resolution
     *
     * @return int|null
     */
    public function getCloseTimeResolution(): ?int {
        return $this->_data["close_time_resolution"];
    }

    /**
     * Set close_time_resolution
     * 
     * @param int|null $close_time_resolution Ledger close times are rounded to within this many seconds.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setCloseTimeResolution(?int $close_time_resolution) {
        return $this->_set("close_time_resolution", $close_time_resolution);
    }

    /**
     * Get closed
     *
     * @return bool|null
     */
    public function getClosed(): ?bool {
        return $this->_data["closed"];
    }

    /**
     * Set closed
     * 
     * @param bool|null $closed Whether or not this ledger has been closed.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setClosed(?bool $closed) {
        return $this->_set("closed", $closed);
    }

    /**
     * Get hash
     *
     * @return string|null
     */
    public function getHash(): ?string {
        return $this->_data["hash"];
    }

    /**
     * Set hash
     * 
     * @param string|null $hash hash
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setHash(?string $hash) {
        return $this->_set("hash", $hash);
    }

    /**
     * Get ledger_hash
     *
     * @return string|null
     */
    public function getLedgerHash(): ?string {
        return $this->_data["ledger_hash"];
    }

    /**
     * Set ledger_hash
     * 
     * @param string|null $ledger_hash Unique identifying hash of the entire ledger.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setLedgerHash(?string $ledger_hash) {
        return $this->_set("ledger_hash", $ledger_hash);
    }

    /**
     * Get ledger_index
     *
     * @return string|null
     */
    public function getLedgerIndex(): ?string {
        return $this->_data["ledger_index"];
    }

    /**
     * Set ledger_index
     * 
     * @param string|null $ledger_index The Ledger Index of this ledger, as a quoted integer.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setLedgerIndex(?string $ledger_index) {
        return $this->_set("ledger_index", $ledger_index);
    }

    /**
     * Get parent_close_time
     *
     * @return int|null
     */
    public function getParentCloseTime(): ?int {
        return $this->_data["parent_close_time"];
    }

    /**
     * Set parent_close_time
     * 
     * @param int|null $parent_close_time The time at which the previous ledger was closed.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setParentCloseTime(?int $parent_close_time) {
        return $this->_set("parent_close_time", $parent_close_time);
    }

    /**
     * Get parent_hash
     *
     * @return string|null
     */
    public function getParentHash(): ?string {
        return $this->_data["parent_hash"];
    }

    /**
     * Set parent_hash
     * 
     * @param string|null $parent_hash Unique identifying hash of the ledger that came immediately before this one.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setParentHash(?string $parent_hash) {
        return $this->_set("parent_hash", $parent_hash);
    }

    /**
     * Get seq_num
     *
     * @return string|null
     */
    public function getSeqNum(): ?string {
        return $this->_data["seq_num"];
    }

    /**
     * Set seq_num
     * 
     * @param string|null $seq_num seq_num
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSeqNum(?string $seq_num) {
        return $this->_set("seq_num", $seq_num);
    }

    /**
     * Get total_coins
     *
     * @return string|null
     */
    public function getTotalCoins(): ?string {
        return $this->_data["total_coins"];
    }

    /**
     * Set total_coins
     * 
     * @param string|null $total_coins total_coins
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTotalCoins(?string $total_coins) {
        return $this->_set("total_coins", $total_coins);
    }

    /**
     * Get total_coins
     *
     * @return string|null
     */
    public function getTotalCoins(): ?string {
        return $this->_data["total_coins"];
    }

    /**
     * Set total_coins
     * 
     * @param string|null $total_coins Total number of XRP drops in the network, as a quoted integer. (This decreases as transaction costs destroy XRP.)
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTotalCoins(?string $total_coins) {
        return $this->_set("total_coins", $total_coins);
    }

    /**
     * Get transaction_hash
     *
     * @return string|null
     */
    public function getTransactionHash(): ?string {
        return $this->_data["transaction_hash"];
    }

    /**
     * Set transaction_hash
     * 
     * @param string|null $transaction_hash Hash of the transaction information included in this ledger, as hex.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTransactionHash(?string $transaction_hash) {
        return $this->_set("transaction_hash", $transaction_hash);
    }

    /**
     * Get transactions
     *
     * @return \Tatum\Model\XrpTx[]|null
     */
    public function getTransactions(): ?array {
        return $this->_data["transactions"];
    }

    /**
     * Set transactions
     * 
     * @param \Tatum\Model\XrpTx[]|null $transactions transactions
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTransactions(?array $transactions) {
        return $this->_set("transactions", $transactions);
    }
}
