<?php

/**
 * TransactionFeeEgldBlockchain Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * TransactionFeeEgldBlockchain Model
 */
class TransactionFeeEgldBlockchain extends AbstractModel {

    public const _D = null;
    protected static $_name = "TransactionFeeEgldBlockchain";
    protected static $_definition = [
        "sender" => ["sender", "string", null, "getSender", "setSender", null, ["r" => 1, "nl" => 62, "xl" => 62]], 
        "receiver" => ["receiver", "string", null, "getReceiver", "setReceiver", null, ["r" => 1, "nl" => 62, "xl" => 62]], 
        "value" => ["value", "string", null, "getValue", "setValue", null, ["r" => 1]], 
        "data" => ["data", "string", null, "getData", "setData", null, ["r" => 0]]
    ];

    /**
     * TransactionFeeEgldBlockchain
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get sender
     *
     * @return string
     */
    public function getSender(): string {
        return $this->_data["sender"];
    }

    /**
     * Set sender
     * 
     * @param string $sender Account address of the sender
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSender(string $sender) {
        return $this->_set("sender", $sender);
    }

    /**
     * Get receiver
     *
     * @return string
     */
    public function getReceiver(): string {
        return $this->_data["receiver"];
    }

    /**
     * Set receiver
     * 
     * @param string $receiver Account address of the receiver or smart contract
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setReceiver(string $receiver) {
        return $this->_set("receiver", $receiver);
    }

    /**
     * Get value
     *
     * @return string
     */
    public function getValue(): string {
        return $this->_data["value"];
    }

    /**
     * Set value
     * 
     * @param string $value Value to be sent.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setValue(string $value) {
        return $this->_set("value", $value);
    }

    /**
     * Get data
     *
     * @return string|null
     */
    public function getData(): ?string {
        return $this->_data["data"];
    }

    /**
     * Set data
     * 
     * @param string|null $data Additional data that can be passed to a blockchain transaction as a data property; must be in the hexadecimal format
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setData(?string $data) {
        return $this->_set("data", $data);
    }
}
