<?php

/**
 * FeeBtc Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * FeeBtc Model
 */
class FeeBtc extends AbstractModel {

    public const _D = null;
    protected static $_name = "FeeBtc";
    protected static $_definition = [
        "fast" => ["fast", "string", null, "getFast", "setFast", null, ["r" => 1]], 
        "medium" => ["medium", "string", null, "getMedium", "setMedium", null, ["r" => 1]], 
        "slow" => ["slow", "string", null, "getSlow", "setSlow", null, ["r" => 1]]
    ];

    /**
     * FeeBtc
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get fast
     *
     * @return string
     */
    public function getFast(): string {
        return $this->_data["fast"];
    }

    /**
     * Set fast
     * 
     * @param string $fast Transaction fee in BTC/LTC to be paid, if transaction should be included in next 1-2 blocks.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setFast(string $fast) {
        return $this->_set("fast", $fast);
    }

    /**
     * Get medium
     *
     * @return string
     */
    public function getMedium(): string {
        return $this->_data["medium"];
    }

    /**
     * Set medium
     * 
     * @param string $medium Transaction fee in BTC/LTC to be paid, if transaction should be included in next 5-6 blocks.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setMedium(string $medium) {
        return $this->_set("medium", $medium);
    }

    /**
     * Get slow
     *
     * @return string
     */
    public function getSlow(): string {
        return $this->_data["slow"];
    }

    /**
     * Set slow
     * 
     * @param string $slow Transaction fee in BTC/LTC to be paid, if transaction should be included in next 7+ blocks.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSlow(string $slow) {
        return $this->_set("slow", $slow);
    }
}
