<?php

/**
 * AlgoTransactionHashKMS Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * AlgoTransactionHashKMS Model
 */
class AlgoTransactionHashKMS extends AbstractModel {

    public const _D = null;
    protected static $_name = "AlgoTransactionHashKMS";
    protected static $_definition = [
        "tx_id" => ["txId", "string", null, "getTxId", "setTxId", null, ["r" => 1]], 
        "asset_index" => ["assetIndex", "float", null, "getAssetIndex", "setAssetIndex", null, ["r" => 0]], 
        "confirmed" => ["confirmed", "bool", null, "getConfirmed", "setConfirmed", false, ["r" => 0]], 
        "failed" => ["failed", "bool", null, "getFailed", "setFailed", null, ["r" => 0]]
    ];

    /**
     * AlgoTransactionHashKMS
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get tx_id
     *
     * @return string
     */
    public function getTxId(): string {
        return $this->_data["tx_id"];
    }

    /**
     * Set tx_id
     * 
     * @param string $tx_id TX hash of transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTxId(string $tx_id) {
        return $this->_set("tx_id", $tx_id);
    }

    /**
     * Get asset_index
     *
     * @return float|null
     */
    public function getAssetIndex(): ?float {
        return $this->_data["asset_index"];
    }

    /**
     * Set asset_index
     * 
     * @param float|null $asset_index If transaction created new ASA asset, this value is the index of the asset on the network.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAssetIndex(?float $asset_index) {
        return $this->_set("asset_index", $asset_index);
    }

    /**
     * Get confirmed
     *
     * @return bool|null
     */
    public function getConfirmed(): ?bool {
        return $this->_data["confirmed"];
    }

    /**
     * Set confirmed
     * 
     * @param bool|null $confirmed If transaction was not confirmed within 5 rounds, result is false.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setConfirmed(?bool $confirmed) {
        return $this->_set("confirmed", $confirmed);
    }

    /**
     * Get failed
     *
     * @return bool|null
     */
    public function getFailed(): ?bool {
        return $this->_data["failed"];
    }

    /**
     * Set failed
     * 
     * @param bool|null $failed In case of the transaction was broadcast to the blockchain, but it was not possible to complete Tatum KMS signature, reponse is marked as failed and must be marked manually.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setFailed(?bool $failed) {
        return $this->_set("failed", $failed);
    }
}
