<?php

/**
 * AdaInfo Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * AdaInfo Model
 */
class AdaInfo extends AbstractModel {

    public const _D = null;
    protected static $_name = "AdaInfo";
    protected static $_definition = [
        "testnet" => ["testnet", "string", null, "getTestnet", "setTestnet", null, ["r" => 0]], 
        "tip" => ["tip", "\Tatum\Model\AdaInfoTip", null, "getTip", "setTip", null, ["r" => 0]]
    ];

    /**
     * AdaInfo
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get testnet
     *
     * @return string|null
     */
    public function getTestnet(): ?string {
        return $this->_data["testnet"];
    }

    /**
     * Set testnet
     * 
     * @param string|null $testnet Chain of the blockchain, main or test.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTestnet(?string $testnet) {
        return $this->_set("testnet", $testnet);
    }

    /**
     * Get tip
     *
     * @return \Tatum\Model\AdaInfoTip|null
     */
    public function getTip(): ?\Tatum\Model\AdaInfoTip {
        return $this->_data["tip"];
    }

    /**
     * Set tip
     * 
     * @param \Tatum\Model\AdaInfoTip|null $tip tip
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTip(?\Tatum\Model\AdaInfoTip $tip) {
        return $this->_set("tip", $tip);
    }
}
