<?php

/**
 * AccountBalance Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * AccountBalance Model
 */
class AccountBalance extends AbstractModel {

    public const _D = null;
    protected static $_name = "AccountBalance";
    protected static $_definition = [
        "account_balance" => ["accountBalance", "string", null, "getAccountBalance", "setAccountBalance", null, ["r" => 1]], 
        "available_balance" => ["availableBalance", "string", null, "getAvailableBalance", "setAvailableBalance", null, ["r" => 1]]
    ];

    /**
     * AccountBalance
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get account_balance
     *
     * @return string
     */
    public function getAccountBalance(): string {
        return $this->_data["account_balance"];
    }

    /**
     * Set account_balance
     * 
     * @param string $account_balance All assets on the account, both available and blocked
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAccountBalance(string $account_balance) {
        return $this->_set("account_balance", $account_balance);
    }

    /**
     * Get available_balance
     *
     * @return string
     */
    public function getAvailableBalance(): string {
        return $this->_data["available_balance"];
    }

    /**
     * Set available_balance
     * 
     * @param string $available_balance The account balance minus the blocked assets; use the available balance to determine how much a customer can send or withdraw from their virtual account
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAvailableBalance(string $available_balance) {
        return $this->_set("available_balance", $available_balance);
    }
}
