<?php

/**
 * Implementation of VirtualAccountBlockchainFees API
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Api;
!defined("TATUM-SDK") && exit();

use InvalidArgumentException as IAE;
use Tatum\Sdk\Serializer as S;

/**
 * API for VirtualAccountBlockchainFees
 */
class VirtualAccountBlockchainFeesApi extends AbstractApi {
    
    /**
     * API package
     */
    const PKG = "Virtual account blockchain fees";

    /**
     * Estimate ledger to blockchain transaction fee
     *
     * @param \Tatum\Model\OffchainEstimateFee $offchain_estimate_fee 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\FeeBtc
     */
    public function offchainEstimateFee($offchain_estimate_fee) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/blockchain/estimate";
        /** @var \Tatum\Model\FeeBtc $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $offchain_estimate_fee
            ), 
            "\Tatum\Model\FeeBtc"
        );
            
        return $result;
    }
    
}
