<?php

/**
 * Implementation of MultiTokensERC1155OrCompatible API
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Api;
!defined("TATUM-SDK") && exit();

use InvalidArgumentException as IAE;
use Tatum\Sdk\Serializer as S;

/**
 * API for MultiTokensERC1155OrCompatible
 */
class MultiTokensERC1155OrCompatibleApi extends AbstractApi {
    
    /**
     * API package
     */
    const PKG = "Multi Tokens (ERC-1155 or compatible)";

    /**
     * Add a Multi Token minter
     *
     * @param \Tatum\Model\AddMultiTokenMinter $add_multi_token_minter 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function addMultiTokenMinter($add_multi_token_minter, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/mint/add";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $add_multi_token_minter
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Add a Multi Token minter
     *
     * @param \Tatum\Model\AddMultiTokenMinterKMS $add_multi_token_minter_kms 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function addMultiTokenMinterKMS($add_multi_token_minter_kms, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/mint/add";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $add_multi_token_minter_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Burn a Multi Token
     *
     * @param \Tatum\Model\BurnMultiToken $burn_multi_token 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function burnMultiToken($burn_multi_token, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/burn";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $burn_multi_token
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Burn multiple Multi Tokens
     *
     * @param \Tatum\Model\BurnMultiTokenBatch $burn_multi_token_batch 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function burnMultiTokenBatch($burn_multi_token_batch, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/burn/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $burn_multi_token_batch
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Burn multiple Multi Tokens
     *
     * @param \Tatum\Model\BurnMultiTokenBatchCelo $burn_multi_token_batch_celo 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function burnMultiTokenBatchCelo($burn_multi_token_batch_celo, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/burn/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $burn_multi_token_batch_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Burn multiple Multi Tokens
     *
     * @param \Tatum\Model\BurnMultiTokenBatchKMS $burn_multi_token_batch_kms 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function burnMultiTokenBatchKMS($burn_multi_token_batch_kms, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/burn/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $burn_multi_token_batch_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Burn multiple Multi Tokens
     *
     * @param \Tatum\Model\BurnMultiTokenBatchKMSCelo $burn_multi_token_batch_kms_celo 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function burnMultiTokenBatchKMSCelo($burn_multi_token_batch_kms_celo, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/burn/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $burn_multi_token_batch_kms_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Burn a Multi Token
     *
     * @param \Tatum\Model\BurnMultiTokenCelo $burn_multi_token_celo 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function burnMultiTokenCelo($burn_multi_token_celo, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/burn";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $burn_multi_token_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Burn a Multi Token
     *
     * @param \Tatum\Model\BurnMultiTokenKMS $burn_multi_token_kms 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function burnMultiTokenKMS($burn_multi_token_kms, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/burn";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $burn_multi_token_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Burn a Multi Token
     *
     * @param \Tatum\Model\BurnMultiTokenKMSCelo $burn_multi_token_kms_celo 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function burnMultiTokenKMSCelo($burn_multi_token_kms_celo, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/burn";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $burn_multi_token_kms_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Multi Token smart contract
     *
     * @param \Tatum\Model\DeployMultiToken $deploy_multi_token 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function deployMultiToken($deploy_multi_token, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/deploy";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_multi_token
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Multi Token smart contract
     *
     * @param \Tatum\Model\DeployMultiTokenCelo $deploy_multi_token_celo 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function deployMultiTokenCelo($deploy_multi_token_celo, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/deploy";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_multi_token_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Multi Token smart contract
     *
     * @param \Tatum\Model\DeployMultiTokenCeloKMS $deploy_multi_token_celo_kms 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function deployMultiTokenCeloKMS($deploy_multi_token_celo_kms, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/deploy";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_multi_token_celo_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Multi Token smart contract
     *
     * @param \Tatum\Model\DeployMultiTokenKMS $deploy_multi_token_kms 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function deployMultiTokenKMS($deploy_multi_token_kms, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/deploy";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_multi_token_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Mint a Multi Token
     *
     * @param \Tatum\Model\MintMultiToken $mint_multi_token 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function mintMultiToken($mint_multi_token, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/mint";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $mint_multi_token
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Mint multiple Multi Tokens
     *
     * @param \Tatum\Model\MintMultiTokenBatch $mint_multi_token_batch 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function mintMultiTokenBatch($mint_multi_token_batch, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/mint/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $mint_multi_token_batch
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Mint multiple Multi Tokens
     *
     * @param \Tatum\Model\MintMultiTokenBatchCelo $mint_multi_token_batch_celo 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function mintMultiTokenBatchCelo($mint_multi_token_batch_celo, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/mint/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $mint_multi_token_batch_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Mint multiple Multi Tokens
     *
     * @param \Tatum\Model\MintMultiTokenBatchKMS $mint_multi_token_batch_kms 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function mintMultiTokenBatchKMS($mint_multi_token_batch_kms, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/mint/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $mint_multi_token_batch_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Mint multiple Multi Tokens
     *
     * @param \Tatum\Model\MintMultiTokenBatchKMSCelo $mint_multi_token_batch_kms_celo 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function mintMultiTokenBatchKMSCelo($mint_multi_token_batch_kms_celo, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/mint/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $mint_multi_token_batch_kms_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Mint a Multi Token
     *
     * @param \Tatum\Model\MintMultiTokenCelo $mint_multi_token_celo 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function mintMultiTokenCelo($mint_multi_token_celo, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/mint";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $mint_multi_token_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Mint a Multi Token
     *
     * @param \Tatum\Model\MintMultiTokenKMS $mint_multi_token_kms 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function mintMultiTokenKMS($mint_multi_token_kms, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/mint";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $mint_multi_token_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Mint a Multi Token
     *
     * @param \Tatum\Model\MintMultiTokenKMSCelo $mint_multi_token_kms_celo 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function mintMultiTokenKMSCelo($mint_multi_token_kms_celo, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/mint";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $mint_multi_token_kms_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Get all Multi Tokens that a blockchain address holds
     *
     * @param string $chain Blockchain to work with
     * @param string $address Blockchain address
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\MultiTokenGetAddressBalance200ResponseInner[]
     */
    public function multiTokenGetAddressBalance($chain, $address, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/address/balance/{chain}/{address}";
        /** @var \Tatum\Model\MultiTokenGetAddressBalance200ResponseInner[] $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["chain" => $chain, "address" => $address]), $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\MultiTokenGetAddressBalance200ResponseInner[]"
        );
            
        return $result;
    }
    
    /**
     * Get the amount of a specific MultiToken that a blockchain address holds
     *
     * @param string $chain Blockchain to work with
     * @param string $address The blockchain address that you want to get the token balance of
     * @param string $contract_address The address of the Multi Token smart contract
     * @param string $token_id The ID of the Multi Token
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\MultiTokenGetBalance200Response
     */
    public function multiTokenGetBalance($chain, $address, $contract_address, $token_id, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/balance/{chain}/{contractAddress}/{address}/{tokenId}";
        /** @var \Tatum\Model\MultiTokenGetBalance200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["chain" => $chain, "address" => $address, "contractAddress" => $contract_address, "tokenId" => $token_id]), $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\MultiTokenGetBalance200Response"
        );
            
        return $result;
    }
    
    /**
     * Get the amount of one or multiple Multi Tokens for multiple blockchain addresses
     *
     * @param string $chain Blockchain to work with
     * @param string $contract_address The address of the Multi Token smart contract
     * @param string $token_id Comma-separated IDs of the Multi Tokens to get the amounts for
     * @param string $address Comma-separated blockchain addresses to get the token balance for
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return string[]
     */
    public function multiTokenGetBalanceBatch($chain, $contract_address, $token_id, $address, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/balance/batch/{chain}/{contractAddress}";
        /** @var string[] $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["chain" => $chain, "contractAddress" => $contract_address]), $rPath, [
                    "tokenId" => S::toQueryValue($token_id),
                    "address" => S::toQueryValue($address),
                ], $rHeaders, []
            ), 
            "string[]"
        );
            
        return $result;
    }
    
    /**
     * Get Multi Token metadata
     *
     * @param string $chain Blockchain to work with
     * @param string $token Token ID
     * @param string $contract_address Multi Token contract address
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\MultiTokenGetMetadata200Response
     */
    public function multiTokenGetMetadata($chain, $token, $contract_address, $x_testnet_type = 'ethereum-sepolia') {
        if (strlen($token) > 32) {
            throw new IAE('Invalid length for "$token" when calling MultiTokensERC1155OrCompatibleApi.multiTokenGetMetadata, must be smaller than or equal to 32');
        }

        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/metadata/{chain}/{contractAddress}/{token}";
        /** @var \Tatum\Model\MultiTokenGetMetadata200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["chain" => $chain, "token" => $token, "contractAddress" => $contract_address]), $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\MultiTokenGetMetadata200Response"
        );
            
        return $result;
    }
    
    /**
     * Get a Multi Token transaction by its hash
     *
     * @param string $chain Blockchain to work with
     * @param string $hash Transaction hash
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\MultiTokenGetTransaction200Response
     */
    public function multiTokenGetTransaction($chain, $hash, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/transaction/{chain}/{hash}";
        /** @var \Tatum\Model\MultiTokenGetTransaction200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["chain" => $chain, "hash" => $hash]), $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\MultiTokenGetTransaction200Response"
        );
            
        return $result;
    }
    
    /**
     * Get Multi Token transactions on a blockchain address
     *
     * @param string $chain Blockchain to work with
     * @param string $address Account address you want to get balance of
     * @param string $token_address Address of the token smart contract
     * @param float $page_size Max number of items per page is 50.
     * @param float|null $offset Offset to obtain next page of the data.
     * @param float|null $from Transactions from this block onwards will be included.
     * @param float|null $to Transactions up to this block will be included.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\MultiTokenGetTransactionByAddress200ResponseInner[]
     */
    public function multiTokenGetTransactionByAddress($chain, $address, $token_address, $page_size, $offset = null, $from = null, $to = null) {
        if ($page_size > 50) {
            throw new IAE('Invalid value for "$page_size" when calling MultiTokensERC1155OrCompatibleApi.multiTokenGetTransactionByAddress, must be smaller than or equal to 50');
        }

        if ($page_size < 1) {
            throw new IAE('Invalid value for "$page_size" when calling MultiTokensERC1155OrCompatibleApi.multiTokenGetTransactionByAddress, must be bigger than or equal to 1.');
        }

        if (isset($from) && $from < 0) {
            throw new IAE('Invalid value for "$from" when calling MultiTokensERC1155OrCompatibleApi.multiTokenGetTransactionByAddress, must be bigger than or equal to 0.');
        }

        if (isset($to) && $to < 0) {
            throw new IAE('Invalid value for "$to" when calling MultiTokensERC1155OrCompatibleApi.multiTokenGetTransactionByAddress, must be bigger than or equal to 0.');
        }

        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/multitoken/transaction/{chain}/{address}/{tokenAddress}";
        /** @var \Tatum\Model\MultiTokenGetTransactionByAddress200ResponseInner[] $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["chain" => $chain, "address" => $address, "tokenAddress" => $token_address]), $rPath, [
                    "pageSize" => S::toQueryValue($page_size),
                    "offset" => isset($offset) ? S::toQueryValue($offset) : null,
                    "from" => isset($from) ? S::toQueryValue($from) : null,
                    "to" => isset($to) ? S::toQueryValue($to) : null,
                ], $rHeaders, []
            ), 
            "\Tatum\Model\MultiTokenGetTransactionByAddress200ResponseInner[]"
        );
            
        return $result;
    }
    
    /**
     * Transfer a Multi Token
     *
     * @param \Tatum\Model\TransferMultiToken $transfer_multi_token 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferMultiToken($transfer_multi_token, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/transaction";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_multi_token
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer multiple Multi Tokens
     *
     * @param \Tatum\Model\TransferMultiTokenBatch $transfer_multi_token_batch 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferMultiTokenBatch($transfer_multi_token_batch, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/transaction/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_multi_token_batch
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer multiple Multi Tokens
     *
     * @param \Tatum\Model\TransferMultiTokenBatchCelo $transfer_multi_token_batch_celo 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferMultiTokenBatchCelo($transfer_multi_token_batch_celo, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/transaction/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_multi_token_batch_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer multiple Multi Tokens
     *
     * @param \Tatum\Model\TransferMultiTokenBatchKMS $transfer_multi_token_batch_kms 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferMultiTokenBatchKMS($transfer_multi_token_batch_kms, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/transaction/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_multi_token_batch_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer multiple Multi Tokens
     *
     * @param \Tatum\Model\TransferMultiTokenBatchKMSCelo $transfer_multi_token_batch_kms_celo 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferMultiTokenBatchKMSCelo($transfer_multi_token_batch_kms_celo, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/transaction/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_multi_token_batch_kms_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer a Multi Token
     *
     * @param \Tatum\Model\TransferMultiTokenCelo $transfer_multi_token_celo 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferMultiTokenCelo($transfer_multi_token_celo, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/transaction";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_multi_token_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer a Multi Token
     *
     * @param \Tatum\Model\TransferMultiTokenKMS $transfer_multi_token_kms 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferMultiTokenKMS($transfer_multi_token_kms, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/transaction";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_multi_token_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer a Multi Token
     *
     * @param \Tatum\Model\TransferMultiTokenKMSCelo $transfer_multi_token_kms_celo 
     * @param string|'ethereum-sepolia' $x_testnet_type Type of testnet. Defaults to Sepolia. Valid only for ETH invocations.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferMultiTokenKMSCelo($transfer_multi_token_kms_celo, $x_testnet_type = 'ethereum-sepolia') {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);
        $rHeaders = array_merge(
            [
                "x-testnet-type" => isset($x_testnet_type) ? S::toHeaderValue($x_testnet_type) : null,
            ], 
            $rHeaders
        );

        // Path template
        $rPath = "/v3/multitoken/transaction";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_multi_token_kms_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
}
