<?php

/**
 * Implementation of BlockchainOperations API
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Api;
!defined("TATUM-SDK") && exit();

use InvalidArgumentException as IAE;
use Tatum\Sdk\Serializer as S;

/**
 * API for BlockchainOperations
 */
class BlockchainOperationsApi extends AbstractApi {
    
    /**
     * API package
     */
    const PKG = "Blockchain operations";

    /**
     * Create a BNB-based asset
     *
     * @param \Tatum\Model\CreateBnbAsset $create_bnb_asset 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return void
     */
    public function bnbAssetOffchain($create_bnb_asset) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bnb/asset";
        $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $create_bnb_asset
            )
        );
    }
    
    /**
     * Deploy an Algorand ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployAlgoErc20OffchainKMSAddress $deploy_algo_erc20_offchain_kms_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployAlgoErc20OffchainMnemonicAddress200Response
     */
    public function deployAlgoErc20OffchainKMSAddress($deploy_algo_erc20_offchain_kms_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/algo/erc20/deploy";
        /** @var \Tatum\Model\DeployAlgoErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_algo_erc20_offchain_kms_address
            ), 
            "\Tatum\Model\DeployAlgoErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy an Algorand ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployAlgoErc20OffchainMnemonicAddress $deploy_algo_erc20_offchain_mnemonic_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployAlgoErc20OffchainMnemonicAddress200Response
     */
    public function deployAlgoErc20OffchainMnemonicAddress($deploy_algo_erc20_offchain_mnemonic_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/algo/erc20/deploy";
        /** @var \Tatum\Model\DeployAlgoErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_algo_erc20_offchain_mnemonic_address
            ), 
            "\Tatum\Model\DeployAlgoErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy an Algorand ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployAlgoErc20OffchainPKAddress $deploy_algo_erc20_offchain_pk_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployAlgoErc20OffchainMnemonicAddress200Response
     */
    public function deployAlgoErc20OffchainPKAddress($deploy_algo_erc20_offchain_pk_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/algo/erc20/deploy";
        /** @var \Tatum\Model\DeployAlgoErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_algo_erc20_offchain_pk_address
            ), 
            "\Tatum\Model\DeployAlgoErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Celo ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployCeloErc20OffchainKMSAddress $deploy_celo_erc20_offchain_kms_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployCeloErc20OffchainKMSAddress($deploy_celo_erc20_offchain_kms_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/celo/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_celo_erc20_offchain_kms_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Celo ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployCeloErc20OffchainKMSXpub $deploy_celo_erc20_offchain_kms_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployCeloErc20OffchainKMSXpub($deploy_celo_erc20_offchain_kms_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/celo/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_celo_erc20_offchain_kms_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Celo ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployCeloErc20OffchainMnemXpub $deploy_celo_erc20_offchain_mnem_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployCeloErc20OffchainMnemXpub($deploy_celo_erc20_offchain_mnem_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/celo/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_celo_erc20_offchain_mnem_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Celo ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployCeloErc20OffchainMnemonicAddress $deploy_celo_erc20_offchain_mnemonic_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployCeloErc20OffchainMnemonicAddress($deploy_celo_erc20_offchain_mnemonic_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/celo/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_celo_erc20_offchain_mnemonic_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Celo ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployCeloErc20OffchainPKAddress $deploy_celo_erc20_offchain_pk_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployCeloErc20OffchainPKAddress($deploy_celo_erc20_offchain_pk_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/celo/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_celo_erc20_offchain_pk_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Celo ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployCeloErc20OffchainPKXpub $deploy_celo_erc20_offchain_pk_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployCeloErc20OffchainPKXpub($deploy_celo_erc20_offchain_pk_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/celo/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_celo_erc20_offchain_pk_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy an Ethereum ERC-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainKMSAddress $deploy_erc20_offchain_kms_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployErc20OffchainKMSAddress($deploy_erc20_offchain_kms_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/ethereum/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_kms_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy an Ethereum ERC-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainKMSXpub $deploy_erc20_offchain_kms_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployErc20OffchainKMSXpub($deploy_erc20_offchain_kms_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/ethereum/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_kms_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy an Ethereum ERC-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainMnemXpub $deploy_erc20_offchain_mnem_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployErc20OffchainMnemXpub($deploy_erc20_offchain_mnem_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/ethereum/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_mnem_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy an Ethereum ERC-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainMnemonicAddress $deploy_erc20_offchain_mnemonic_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployErc20OffchainMnemonicAddress($deploy_erc20_offchain_mnemonic_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/ethereum/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_mnemonic_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy an Ethereum ERC-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainPKAddress $deploy_erc20_offchain_pk_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployErc20OffchainPKAddress($deploy_erc20_offchain_pk_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/ethereum/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_pk_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy an Ethereum ERC-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainPKXpub $deploy_erc20_offchain_pk_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployErc20OffchainPKXpub($deploy_erc20_offchain_pk_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/ethereum/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_pk_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a TRON TRC-10 or TRC-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployTrcOffchainKMSAddress $deploy_trc_offchain_kms_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployTrcOffchainKMSAddress($deploy_trc_offchain_kms_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/tron/trc/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_trc_offchain_kms_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a TRON TRC-10 or TRC-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployTrcOffchainKMSXpub $deploy_trc_offchain_kms_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployTrcOffchainKMSXpub($deploy_trc_offchain_kms_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/tron/trc/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_trc_offchain_kms_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a TRON TRC-10 or TRC-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployTrcOffchainMnemXpub $deploy_trc_offchain_mnem_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployTrcOffchainMnemXpub($deploy_trc_offchain_mnem_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/tron/trc/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_trc_offchain_mnem_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a TRON TRC-10 or TRC-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployTrcOffchainMnemonicAddress $deploy_trc_offchain_mnemonic_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployTrcOffchainMnemonicAddress($deploy_trc_offchain_mnemonic_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/tron/trc/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_trc_offchain_mnemonic_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a TRON TRC-10 or TRC-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployTrcOffchainPKAddress $deploy_trc_offchain_pk_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployTrcOffchainPKAddress($deploy_trc_offchain_pk_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/tron/trc/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_trc_offchain_pk_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a TRON TRC-10 or TRC-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployTrcOffchainPKXpub $deploy_trc_offchain_pk_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function deployTrcOffchainPKXpub($deploy_trc_offchain_pk_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/tron/trc/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_trc_offchain_pk_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Register a new ERC-20 or ERC-20-equivalent token in the virtual account
     *
     * @param string $chain Blockchain to work with
     * @param \Tatum\Model\Erc20 $erc20 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\Erc20Response
     */
    public function erc20($chain, $erc20) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/token/{chain}";
        /** @var \Tatum\Model\Erc20Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", S::parse($rPath, ["chain" => $chain]), $rPath, [], $rHeaders, [], $erc20
            ), 
            "\Tatum\Model\Erc20Response"
        );
            
        return $result;
    }
    
    /**
     * Register a new ERC-20 or ERC-20-equivalent token in the virtual account
     *
     * @param string $chain Blockchain to work with
     * @param \Tatum\Model\Erc20Address $erc20_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\Erc20Response
     */
    public function erc20Address($chain, $erc20_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/token/{chain}";
        /** @var \Tatum\Model\Erc20Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", S::parse($rPath, ["chain" => $chain]), $rPath, [], $rHeaders, [], $erc20_address
            ), 
            "\Tatum\Model\Erc20Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a BNB Smart Chain BEP-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainKMSAddress $deploy_erc20_offchain_kms_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offBscDeployErc20OffchainKMSAddress($deploy_erc20_offchain_kms_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bsc/bep20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_kms_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a BNB Smart Chain BEP-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainKMSXpub $deploy_erc20_offchain_kms_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offBscDeployErc20OffchainKMSXpub($deploy_erc20_offchain_kms_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bsc/bep20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_kms_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a BNB Smart Chain BEP-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainMnemXpub $deploy_erc20_offchain_mnem_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offBscDeployErc20OffchainMnemXpub($deploy_erc20_offchain_mnem_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bsc/bep20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_mnem_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a BNB Smart Chain BEP-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainMnemonicAddress $deploy_erc20_offchain_mnemonic_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offBscDeployErc20OffchainMnemonicAddress($deploy_erc20_offchain_mnemonic_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bsc/bep20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_mnemonic_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a BNB Smart Chain BEP-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainPKAddress $deploy_erc20_offchain_pk_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offBscDeployErc20OffchainPKAddress($deploy_erc20_offchain_pk_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bsc/bep20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_pk_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a BNB Smart Chain BEP-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainPKXpub $deploy_erc20_offchain_pk_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offBscDeployErc20OffchainPKXpub($deploy_erc20_offchain_pk_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bsc/bep20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_pk_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Send EGLD from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEth $transfer_eth 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function offEglTransferEth($transfer_eth) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/egld/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_eth
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send EGLD from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEthKMS $transfer_eth_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function offEglTransferEthKMS($transfer_eth_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/egld/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_eth_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send EGLD from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEthMnemonic $transfer_eth_mnemonic 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function offEglTransferEthMnemonic($transfer_eth_mnemonic) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/egld/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_eth_mnemonic
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a KuCoin Community Chain (KCC) ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainKMSAddress $deploy_erc20_offchain_kms_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offKcsDeployErc20OffchainKMSAddress($deploy_erc20_offchain_kms_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/kcs/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_kms_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a KuCoin Community Chain (KCC) ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainKMSXpub $deploy_erc20_offchain_kms_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offKcsDeployErc20OffchainKMSXpub($deploy_erc20_offchain_kms_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/kcs/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_kms_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a KuCoin Community Chain (KCC) ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainMnemXpub $deploy_erc20_offchain_mnem_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offKcsDeployErc20OffchainMnemXpub($deploy_erc20_offchain_mnem_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/kcs/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_mnem_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a KuCoin Community Chain (KCC) ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainMnemonicAddress $deploy_erc20_offchain_mnemonic_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offKcsDeployErc20OffchainMnemonicAddress($deploy_erc20_offchain_mnemonic_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/kcs/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_mnemonic_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a KuCoin Community Chain (KCC) ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainPKAddress $deploy_erc20_offchain_pk_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offKcsDeployErc20OffchainPKAddress($deploy_erc20_offchain_pk_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/kcs/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_pk_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a KuCoin Community Chain (KCC) ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainPKXpub $deploy_erc20_offchain_pk_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offKcsDeployErc20OffchainPKXpub($deploy_erc20_offchain_pk_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/kcs/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_pk_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Klaytn ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainKMSAddress $deploy_erc20_offchain_kms_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offKlaDeployErc20OffchainKMSAddress($deploy_erc20_offchain_kms_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/klaytn/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_kms_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Klaytn ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainKMSXpub $deploy_erc20_offchain_kms_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offKlaDeployErc20OffchainKMSXpub($deploy_erc20_offchain_kms_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/klaytn/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_kms_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Klaytn ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainMnemXpub $deploy_erc20_offchain_mnem_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offKlaDeployErc20OffchainMnemXpub($deploy_erc20_offchain_mnem_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/klaytn/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_mnem_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Klaytn ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainMnemonicAddress $deploy_erc20_offchain_mnemonic_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offKlaDeployErc20OffchainMnemonicAddress($deploy_erc20_offchain_mnemonic_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/klaytn/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_mnemonic_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Klaytn ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainPKAddress $deploy_erc20_offchain_pk_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offKlaDeployErc20OffchainPKAddress($deploy_erc20_offchain_pk_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/klaytn/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_pk_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Klaytn ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainPKXpub $deploy_erc20_offchain_pk_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offKlaDeployErc20OffchainPKXpub($deploy_erc20_offchain_pk_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/klaytn/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_pk_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Send KLAY from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEth $transfer_eth 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function offKlaTransferEth($transfer_eth) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/klaytn/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_eth
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send KLAY from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEthKMS $transfer_eth_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function offKlaTransferEthKMS($transfer_eth_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/klaytn/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_eth_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send KLAY from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEthMnemonic $transfer_eth_mnemonic 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function offKlaTransferEthMnemonic($transfer_eth_mnemonic) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/klaytn/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_eth_mnemonic
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Harmony HRM-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainKMSAddress $deploy_erc20_offchain_kms_address 
     * @param float|0 $shard_id The ID of the shard to operate
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offOneDeployErc20OffchainKMSAddress($deploy_erc20_offchain_kms_address, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/one/hrm20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, [], $deploy_erc20_offchain_kms_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Harmony HRM-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainKMSXpub $deploy_erc20_offchain_kms_xpub 
     * @param float|0 $shard_id The ID of the shard to operate
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offOneDeployErc20OffchainKMSXpub($deploy_erc20_offchain_kms_xpub, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/one/hrm20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, [], $deploy_erc20_offchain_kms_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Harmony HRM-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainMnemXpub $deploy_erc20_offchain_mnem_xpub 
     * @param float|0 $shard_id The ID of the shard to operate
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offOneDeployErc20OffchainMnemXpub($deploy_erc20_offchain_mnem_xpub, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/one/hrm20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, [], $deploy_erc20_offchain_mnem_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Harmony HRM-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainMnemonicAddress $deploy_erc20_offchain_mnemonic_address 
     * @param float|0 $shard_id The ID of the shard to operate
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offOneDeployErc20OffchainMnemonicAddress($deploy_erc20_offchain_mnemonic_address, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/one/hrm20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, [], $deploy_erc20_offchain_mnemonic_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Harmony HRM-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainPKAddress $deploy_erc20_offchain_pk_address 
     * @param float|0 $shard_id The ID of the shard to operate
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offOneDeployErc20OffchainPKAddress($deploy_erc20_offchain_pk_address, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/one/hrm20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, [], $deploy_erc20_offchain_pk_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a Harmony HRM-20 smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainPKXpub $deploy_erc20_offchain_pk_xpub 
     * @param float|0 $shard_id The ID of the shard to operate
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offOneDeployErc20OffchainPKXpub($deploy_erc20_offchain_pk_xpub, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/one/hrm20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, [], $deploy_erc20_offchain_pk_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Send ONE from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEth $transfer_eth 
     * @param float|0 $shard_id Shard to operate on
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function offOneTransferEth($transfer_eth, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/one/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, [], $transfer_eth
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send ONE from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEthKMS $transfer_eth_kms 
     * @param float|0 $shard_id Shard to operate on
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function offOneTransferEthKMS($transfer_eth_kms, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/one/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, [], $transfer_eth_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send ONE from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEthMnemonic $transfer_eth_mnemonic 
     * @param float|0 $shard_id Shard to operate on
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function offOneTransferEthMnemonic($transfer_eth_mnemonic, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/one/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, [], $transfer_eth_mnemonic
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send MATIC from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEth $transfer_eth 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function offPolTransferEth($transfer_eth) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/polygon/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_eth
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send MATIC from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEthKMS $transfer_eth_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function offPolTransferEthKMS($transfer_eth_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/polygon/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_eth_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send MATIC from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEthMnemonic $transfer_eth_mnemonic 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function offPolTransferEthMnemonic($transfer_eth_mnemonic) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/polygon/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_eth_mnemonic
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a XinFin ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainKMSAddress $deploy_erc20_offchain_kms_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offXdcDeployErc20OffchainKMSAddress($deploy_erc20_offchain_kms_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/xdc/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_kms_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a XinFin ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainKMSXpub $deploy_erc20_offchain_kms_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offXdcDeployErc20OffchainKMSXpub($deploy_erc20_offchain_kms_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/xdc/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_kms_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a XinFin ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainMnemXpub $deploy_erc20_offchain_mnem_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offXdcDeployErc20OffchainMnemXpub($deploy_erc20_offchain_mnem_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/xdc/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_mnem_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a XinFin ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainMnemonicAddress $deploy_erc20_offchain_mnemonic_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offXdcDeployErc20OffchainMnemonicAddress($deploy_erc20_offchain_mnemonic_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/xdc/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_mnemonic_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a XinFin ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainPKAddress $deploy_erc20_offchain_pk_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offXdcDeployErc20OffchainPKAddress($deploy_erc20_offchain_pk_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/xdc/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_pk_address
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Deploy a XinFin ERC-20-equivalent smart contract to the blockchain and a virtual account
     *
     * @param \Tatum\Model\DeployErc20OffchainPKXpub $deploy_erc20_offchain_pk_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response
     */
    public function offXdcDeployErc20OffchainPKXpub($deploy_erc20_offchain_pk_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/xdc/erc20/deploy";
        /** @var \Tatum\Model\DeployErc20OffchainMnemonicAddress200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $deploy_erc20_offchain_pk_xpub
            ), 
            "\Tatum\Model\DeployErc20OffchainMnemonicAddress200Response"
        );
            
        return $result;
    }
    
    /**
     * Send XDC from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEth $transfer_eth 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function offXdcTransferEth($transfer_eth) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/xdc/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_eth
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send XDC from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEthKMS $transfer_eth_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function offXdcTransferEthKMS($transfer_eth_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/xdc/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_eth_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send XDC from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEthMnemonic $transfer_eth_mnemonic 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function offXdcTransferEthMnemonic($transfer_eth_mnemonic) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/xdc/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_eth_mnemonic
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Set the contract address of an ERC-20, ERC-20-equivalent, or TRC-10 token
     *
     * @param string $address On Algorand, this is the asset ID; on TRON, this is the token ID; on the other blockchains, this is the address of the smart contract.
     * @param string $name The name of the token (the token symbol)
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return void
     */
    public function storeTokenAddress($address, $name) {
        if (strlen($address) > 100) {
            throw new IAE('Invalid length for "$address" when calling BlockchainOperationsApi.storeTokenAddress, must be smaller than or equal to 100');
        }

        if (strlen($address) < 1) {
            throw new IAE('Invalid length for "$address" when calling BlockchainOperationsApi.storeTokenAddress, must be bigger than or equal to 1');
        }

        if (strlen($name) > 30) {
            throw new IAE('Invalid length for "$name" when calling BlockchainOperationsApi.storeTokenAddress, must be smaller than or equal to 30');
        }

        if (strlen($name) < 1) {
            throw new IAE('Invalid length for "$name" when calling BlockchainOperationsApi.storeTokenAddress, must be bigger than or equal to 1');
        }

        if (!preg_match("/^[a-zA-Z0-9_]+$/", $name)) {
            throw new IAE('Invalid value for "$name" when calling BlockchainOperationsApi.storeTokenAddress, must conform to the pattern /^[a-zA-Z0-9_]+$/');
        }

        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/offchain/token/{name}/{address}";
        $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", S::parse($rPath, ["address" => $address, "name" => $name]), $rPath, [], $rHeaders, []
            )
        );
    }
    
    /**
     * Send ALGO from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferAlgo $transfer_algo 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferAlgo($transfer_algo) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/algorand/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_algo
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send ALGO from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferAlgoErc20 $transfer_algo_erc20 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferAlgoErc20($transfer_algo_erc20) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/algorand/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_algo_erc20
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send ALGO from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferAlgoKMS $transfer_algo_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferAlgoKMS($transfer_algo_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/algorand/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_algo_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send BCH from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferBchKMS $transfer_bch_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferBchKMS($transfer_bch_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bcash/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_bch_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send BCH from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferBchKeyPair $transfer_bch_key_pair 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferBchKeyPair($transfer_bch_key_pair) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bcash/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_bch_key_pair
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send BCH from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferBchMnemonic $transfer_bch_mnemonic 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferBchMnemonic($transfer_bch_mnemonic) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bcash/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_bch_mnemonic
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send BNB from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferBnb $transfer_bnb 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferBnb($transfer_bnb) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bnb/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_bnb
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send BNB from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferBnbKMS $transfer_bnb_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferBnbKMS($transfer_bnb_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bnb/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_bnb_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send BSC from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferBsc $transfer_bsc 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferBsc($transfer_bsc) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bsc/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_bsc
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send BSC from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferBscKMS $transfer_bsc_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferBscKMS($transfer_bsc_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bsc/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_bsc_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send BSC from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferBscMnemonic $transfer_bsc_mnemonic 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferBscMnemonic($transfer_bsc_mnemonic) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bsc/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_bsc_mnemonic
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send BTC from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferBtcKMS $transfer_btc_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferBtcKMS($transfer_btc_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bitcoin/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_btc_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send BTC from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferBtcKeyPair $transfer_btc_key_pair 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferBtcKeyPair($transfer_btc_key_pair) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bitcoin/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_btc_key_pair
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send BTC from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferBtcMnemonic $transfer_btc_mnemonic 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferBtcMnemonic($transfer_btc_mnemonic) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/bitcoin/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_btc_mnemonic
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send CELO from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferCelo $transfer_celo 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferCelo($transfer_celo) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/celo/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_celo
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send CELO from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferCeloKMS $transfer_celo_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferCeloKMS($transfer_celo_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/celo/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_celo_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send CELO from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferCeloMnemonic $transfer_celo_mnemonic 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferCeloMnemonic($transfer_celo_mnemonic) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/celo/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_celo_mnemonic
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send DOGE from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferDogeKMS $transfer_doge_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferDogeKMS($transfer_doge_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/dogecoin/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_doge_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send DOGE from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferDogeKeyPair $transfer_doge_key_pair 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferDogeKeyPair($transfer_doge_key_pair) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/dogecoin/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_doge_key_pair
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send DOGE from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferDogeMnemonic $transfer_doge_mnemonic 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferDogeMnemonic($transfer_doge_mnemonic) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/dogecoin/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_doge_mnemonic
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send Ethereum ERC-20 tokens from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferErc20 $transfer_erc20 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferErc20($transfer_erc20) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/ethereum/erc20/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_erc20
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send Ethereum ERC-20 tokens from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferErc20KMS $transfer_erc20_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferErc20KMS($transfer_erc20_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/ethereum/erc20/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_erc20_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send Ethereum ERC-20 tokens from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferErc20Mnemonic $transfer_erc20_mnemonic 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferErc20Mnemonic($transfer_erc20_mnemonic) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/ethereum/erc20/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_erc20_mnemonic
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send ETH from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEth $transfer_eth 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferEth($transfer_eth) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/ethereum/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_eth
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send ETH from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEthKMS $transfer_eth_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferEthKMS($transfer_eth_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/ethereum/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_eth_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send ETH from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferEthMnemonic $transfer_eth_mnemonic 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferEthMnemonic($transfer_eth_mnemonic) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/ethereum/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_eth_mnemonic
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send FLOW from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferFlowKMS $transfer_flow_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferFlowKMS($transfer_flow_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/flow/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_flow_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send FLOW from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferFlowMnemonic $transfer_flow_mnemonic 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferFlowMnemonic($transfer_flow_mnemonic) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/flow/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_flow_mnemonic
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send FLOW from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferFlowPK $transfer_flow_pk 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferFlowPK($transfer_flow_pk) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/flow/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_flow_pk
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send KCS from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferKCS $transfer_kcs 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferKCS($transfer_kcs) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/kcs/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_kcs
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send KCS from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferKCSKMS $transfer_kcskms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferKCSKMS($transfer_kcskms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/kcs/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_kcskms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send KCS from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferKCSMnemonic $transfer_kcs_mnemonic 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferKCSMnemonic($transfer_kcs_mnemonic) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/kcs/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_kcs_mnemonic
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send LTC from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferLtcKMS $transfer_ltc_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferLtcKMS($transfer_ltc_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/litecoin/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_ltc_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send LTC from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferLtcKeyPair $transfer_ltc_key_pair 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferLtcKeyPair($transfer_ltc_key_pair) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/litecoin/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_ltc_key_pair
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send LTC from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferLtcMnemonic $transfer_ltc_mnemonic 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferLtcMnemonic($transfer_ltc_mnemonic) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/litecoin/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_ltc_mnemonic
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send SOL from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferSol $transfer_sol 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferSol($transfer_sol) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/solana/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_sol
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send SOL from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferSolKMS $transfer_sol_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferSolKMS($transfer_sol_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/solana/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_sol_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send TRON from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferTron $transfer_tron 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferTron($transfer_tron) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/tron/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_tron
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send TRON from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferTronKMS $transfer_tron_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferTronKMS($transfer_tron_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/tron/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_tron_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send TRON from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferTronMnemonic $transfer_tron_mnemonic 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferTronMnemonic($transfer_tron_mnemonic) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/tron/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_tron_mnemonic
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send XLM from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferXlm $transfer_xlm 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferXlm($transfer_xlm) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/xlm/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_xlm
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send XLM from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferXlmKMS $transfer_xlm_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferXlmKMS($transfer_xlm_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/xlm/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_xlm_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send XRP from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferXrp $transfer_xrp 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferXrp($transfer_xrp) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/xrp/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_xrp
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Send XRP from a virtual account to the blockchain
     *
     * @param \Tatum\Model\TransferXrpKMS $transfer_xrp_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransferBtcMnemonic200Response
     */
    public function transferXrpKMS($transfer_xrp_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/xrp/transfer";
        /** @var \Tatum\Model\TransferBtcMnemonic200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_xrp_kms
            ), 
            "\Tatum\Model\TransferBtcMnemonic200Response"
        );
            
        return $result;
    }
    
    /**
     * Register a new TRON TRC-10 or TRC-20 token in the virtual account
     *
     * @param \Tatum\Model\TrcAddress $trc_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\Trc20Response
     */
    public function trcAddress($trc_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/tron/trc";
        /** @var \Tatum\Model\Trc20Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $trc_address
            ), 
            "\Tatum\Model\Trc20Response"
        );
            
        return $result;
    }
    
    /**
     * Register a new TRON TRC-10 or TRC-20 token in the virtual account
     *
     * @param \Tatum\Model\TrcXpub $trc_xpub 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\Trc20Response
     */
    public function trcXpub($trc_xpub) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/tron/trc";
        /** @var \Tatum\Model\Trc20Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $trc_xpub
            ), 
            "\Tatum\Model\Trc20Response"
        );
            
        return $result;
    }
    
    /**
     * Create an XLM-based asset
     *
     * @param \Tatum\Model\CreateXlmAsset $create_xlm_asset 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return void
     */
    public function xlmAssetOffchain($create_xlm_asset) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/xlm/asset";
        $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $create_xlm_asset
            )
        );
    }
    
    /**
     * Create XRP based Asset
     *
     * @param \Tatum\Model\CreateXrpAsset $create_xrp_asset 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return void
     */
    public function xrpAssetOffchain($create_xrp_asset) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/xrp/asset";
        $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $create_xrp_asset
            )
        );
    }
    
}
