<?php $__env->startSection('title', $title); ?>
<?php $__env->startSection('content'); ?>


<body>
 <!-- Splash Screen Start -->
<div class="preloader inset-0 z-50">
    <div
      class="h-full bg-bgColor flex flex-col justify-center items-center text-center container"
    >
      <div class="zoomInOut">
        <div class="">
          <img src="/muladash/assets/images/preloader.png" alt="" />
        </div>
        
      </div>
    </div>
  </div>
  <!-- Splash Screen End -->

    <main class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh pb-32">
        <div class="px-6 flex justify-between items-center">
            <div class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl text-white">
                <a href="javascript:history.back()" class="ph ph-caret-left"></a>
            </div>
            <div class="flex-1 flex justify-center items-center pr-12">
                <p class="text-2xl font-semibold">Statistics</p>
            </div>
        </div>

        
        <div class="pt-8 px-6">
            <div class="p-4 rounded-2xl border border-n20 dark:border-darkN40 flex justify-between items-center">
                <div class="flex justify-start items-start gap-3">
                    <div class="flex justify-center items-center bg-g300 w-10 h-10 rounded-full text-xl text-white">
                        <i class="ph ph-arrow-down"></i>
                    </div>
                    <div>
                        <p class="text-xl font-semibold text-g300">$<?php echo e(number_format($totalDeposits, 2)); ?></p>
                        <p class="text-sm text-n500 dark:text-darkN500 pt-1">Total Deposits</p>
                    </div>
                </div>
                <div class="border border-n40 dark:border-darkN40 border-dashed h-9 w-px"></div>
                <div class="flex justify-start items-start gap-3">
                    <div class="flex justify-center items-center bg-o300 w-10 h-10 rounded-full text-xl text-white">
                        <i class="ph ph-arrow-up"></i>
                    </div>
                    <div>
                        <p class="text-xl font-semibold text-g300">$<?php echo e(number_format($totalWithdrawals, 2)); ?></p>
                        <p class="text-sm text-n500 dark:text-darkN500 pt-1">Total Withdrawals</p>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="px-6 pt-8">
            <div class="flex justify-between items-center">
                <p class="text-lg font-semibold">Show Chart in</p>
                <div class="relative cursor-pointer">
                    <div class="flex justify-center items-center gap-2 border border-n40 dark:border-darkN40 rounded-lg p-3 selectSortBy">
                        <p class="text-n500 dark:text-darkN500 text-sm selectedItem">Last 7 days</p>
                        <i class="ph ph-caret-down"></i>
                    </div>
                    <div class="bg-white p-4 rounded-xl border border-n40 dark:border-darkN40 dark:bg-darkG300 w-[150px] absolute right-0 top-12 selectSortByModal invisible opacity-0 scale-75 duration-500">
                        <ul class="flex flex-col gap-2">
                            <li class="text-xs text-n500 dark:text-darkN500 pb-2 border-b border-dashed border-n40 dark:border-darkN40 cursor-pointer item">Today</li>
                            <li class="text-xs text-n500 dark:text-darkN500 pb-2 border-b border-dashed border-n40 dark:border-darkN40 cursor-pointer item">Last 7 days</li>
                            <li class="text-xs text-n500 dark:text-darkN500 pb-2 border-b border-dashed border-n40 dark:border-darkN40 cursor-pointer item">Last 30 days</li>
                            <li class="text-xs text-n500 dark:text-darkN500 pb-2 border-b border-dashed border-n40 dark:border-darkN40 cursor-pointer item">Last 3 months</li>
                            <li class="text-xs text-n500 dark:text-darkN500 pb-2 border-b border-dashed border-n40 dark:border-darkN40 cursor-pointer item">This year</li>
                            <li class="text-xs text-n500 dark:text-darkN500 cursor-pointer item">All time</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="customer_impression"></div>
        </div>

        
        <div class="px-6 pt-8">
            <p class="text-lg font-semibold">Number of Transactions</p>
            <div class="pt-5 grid grid-cols-3 gap-3">
                <div class="col-span-1 p-4 border rounded-md flex flex-col gap-2 justify-center items-center text-center">
                    <div class="w-10 h-10 rounded-full border flex justify-center items-center">
                        <p class="font-medium text-g300"><?php echo e($counts['income']); ?></p>
                    </div>
                    <p class="text-sm font-medium text-n500 dark:text-darkN500">Income</p>
                </div>
                <div class="col-span-1 p-4 border rounded-md flex flex-col gap-2 justify-center items-center text-center">
                    <div class="w-10 h-10 rounded-full border flex justify-center items-center">
                        <p class="font-medium text-g300"><?php echo e($counts['sent']); ?></p>
                    </div>
                    <p class="text-sm font-medium text-n500 dark:text-darkN500">Sent</p>
                </div>
                <div class="col-span-1 p-4 border rounded-md flex flex-col gap-2 justify-center items-center text-center">
                    <div class="w-10 h-10 rounded-full border flex justify-center items-center">
                        <p class="font-medium text-g300"><?php echo e($counts['request']); ?></p>
                    </div>
                    <p class="text-sm font-medium text-n500 dark:text-darkN500">Request</p>
                </div>
                <div class="col-span-1 p-4 border rounded-md flex flex-col gap-2 justify-center items-center text-center">
                    <div class="w-10 h-10 rounded-full border flex justify-center items-center">
                        <p class="font-medium text-g300"><?php echo e($counts['topup']); ?></p>
                    </div>
                    <p class="text-sm font-medium text-n500 dark:text-darkN500">Top Up</p>
                </div>
                <div class="col-span-1 p-4 border rounded-md flex flex-col gap-2 justify-center items-center text-center">
                    <div class="w-10 h-10 rounded-full border flex justify-center items-center">
                        <p class="font-medium text-g300"><?php echo e($counts['withdraw']); ?></p>
                    </div>
                    <p class="text-sm font-medium text-n500 dark:text-darkN500">Withdraw</p>
                </div>
                <div class="col-span-1 p-4 border rounded-md flex flex-col gap-2 justify-center items-center text-center">
                    <div class="w-10 h-10 rounded-full border flex justify-center items-center">
                        <p class="font-medium text-g300"><?php echo e($counts['transaction']); ?></p>
                    </div>
                    <p class="text-sm font-medium text-n500 dark:text-darkN500">Total</p>
                </div>
            </div>
        </div>
    </main>
</body>
<script src="/muladash/assets/js/plugins/apexcharts.min.js"></script>
<script>
  <?php if(isset($chartData)): ?>
      const chartMonths = <?php echo json_encode($chartData['months'], 15, 512) ?>;
      const depositData = <?php echo json_encode($chartData['deposits'], 15, 512) ?>;
  <?php else: ?>
      const chartMonths = ["Jan", "Feb", "Mar", "Apr", "May", "Jun"];
      const depositData = [0, 0, 0, 0, 0, 0];
  <?php endif; ?>
  
  if (document.querySelector(".customer_impression")) {
      var options = {
          series: [
              {
                  name: "Deposits",
                  type: "area",
                  data: depositData,
              },
          ],
          chart: {
              height: 250,
              type: "line",
              toolbar: { show: false },
              animations: { enabled: true, easing: "easeinout", speed: 800 },
          },
          stroke: {
              curve: "smooth",
              width: 2,
          },
          fill: { opacity: 0.2 },
          markers: { size: 4 },
          xaxis: {
              categories: chartMonths,
          },
          grid: {
              borderColor: "#F5F6F7",
              yaxis: { lines: { show: true } },
              padding: { bottom: -10 },
          },
          colors: ["#FFC861"],
          tooltip: {
              y: {
                  formatter: function (e) {
                      return "$" + e.toFixed(2);
                  },
              },
          },
      };
  
      var chart = new ApexCharts(document.querySelector(".customer_impression"), options);
      chart.render();
  }
  </script>
  
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.muladash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/virus/resources/views/user/insights.blade.php ENDPATH**/ ?>