<?php $__env->startSection('title', $title); ?>
<?php $__env->startSection('content'); ?>
    <!-- Title -->
    <style>
       .carousel-container {
        width: 100%;
        overflow: hidden;
        margin: 25px 0px 0px 0px;
    }
    
        .card-track {
            display: flex;
            transition: transform 0.5s ease-in-out;
        }
    
        .credit-card {
            min-width: 320px;
            margin: 0 5px;
            border-radius: 15px;
            padding: 20px;
            color: #fff;
            height: 200px;
            position: relative;
        }
    
        .visa { background: linear-gradient(135deg, #004e92, #000428); }
        .mastercard { background: linear-gradient(135deg, #ff512f, #dd2476); }
        .gold { background: linear-gradient(135deg, #ffd700, #ffb700); color: #000; }
    
        .chip { width: 50px; height: 35px; background: linear-gradient(135deg, #d4af37, #b8860b);
            box-shadow: inset 0 0 5px rgba(0,0,0,0.2);
    position: relative; border-radius: 5px; margin-bottom: 20px; }
    .chip::before {
    content: "";
    position: absolute;
    top: 10px;
    left: 5px;
    width: 40px;
    height: 2px;
    background: rgba(0,0,0,0.1);
    box-shadow: 0 6px rgba(0,0,0,0.1), 0 12px rgba(0,0,0,0.1);
}
        .card-type { position: absolute; top: 20px; right: 20px; font-weight: bold; font-size: 18px; text-transform: uppercase; }
        .card-number { font-size: 18px; letter-spacing: 2px; margin: 10px 0; }
        .card-details { font-size: 12px; display: flex; justify-content: space-between; }
        .cvv { position: absolute; bottom: 15px; right: 20px; font-size: 12px; }
        .balance { position: absolute; bottom: 15px; left: 20px; font-size: 12px; }
    
        /* Plus Button Centered */
        .add-card-btn {
            display: block;
            margin: 30px auto 0;
            width: 60px;
            height: 60px;
            background: rgb(67, 126, 157);
            border-radius: 50%;
            color: #fff;
            font-size: 36px;
            border: none;
            cursor: pointer;
            box-shadow: 0 4px 10px rgba(0,0,0,0.2);
        }
    

.logo-switch.dark {
    display: none;
}

/* When body has .dark class */
body.dark .logo-switch {
    display: none;
}

body.dark .logo-switch.dark {
    display: inline;
}

        
    </style>
    <?php echo $__env->make('layouts.mulapart', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
<!-- Splash Screen Start -->
<div class="preloader inset-0 z-50">
  <div
    class="h-full bg-bgColor flex flex-col justify-center items-center text-center container"
  >
    <div class="zoomInOut">
      <div class="">
        <img src="/muladash/assets/images/preloader.png" alt="" />
      </div>
      
    </div>
  </div>
</div>
<!-- Splash Screen End -->
      <main
        class="container bg-bgColor dark:bg-darkG300 text-n900 dark:text-white pt-8 min-h-dvh flex flex-col"
      >
        <div class="px-6 flex justify-between items-start">
          <div class="rounded-full w-12 h-12 overflow-hidden bg-bgColor2">
            <img src="/muladash/assets/images/user.png" alt="" />
          </div>
    
         <!-- Light Mode Logo -->
<img src="<?php echo e(asset('storage/' . $settings->logo)); ?>" class="logo-switch" alt="Logo">

<!-- Dark Mode Logo -->
<img src="<?php echo e(asset('storage/' . $settings->logo_white)); ?>" class="logo-switch dark" alt="Dark Logo">
    
          <a
            href="<?php echo e(route('notifications')); ?>"
            class="text-2xl text-g300 border border-n500 !leading-none flex justify-center items-center rounded-full p-2 relative bg-white dark:bg-n0"
          >
            <div
              class="absolute top-0 right-0 bg-bgColor rounded-full w-3 h-3 flex justify-center items-center dark:bg-n0"
            >
              <div class="w-2 h-2 rounded-full bg-red-500"></div>
            </div>
            <i class="ph-fill ph-bell-simple"></i>
          </a>
        </div>
        <div class="text-center flex justify-between items-center flex-col py-8">
          <p class="text-[52px] font-bold flex justify-start -mt-3">
           <?php echo e(number_format($totalBalanceInUSD, 2)); ?> <span class="text-xl text-g300 pt-2.5"><?php echo e($settings->currency); ?></span>
          </p>
          <p class="text-n500 dark:text-darkN500">Total Balance</p>
        </div>
        <div class="px-6 relative z-20">
          <div class="flex gap-3 justify-start items-center">
            <a
          href="<?php echo e(route('deposits')); ?>"
          class="bg-orange-200 rounded-2xl p-4 flex-1 max-w-[85px] flex flex-col justify-center items-center shrink-0"
        >
          <div
            class="h-7 w-7 rounded-full bg-n0 flex justify-center items-center"
          >
          <i class="ph-fill ph-wallet text-white"></i>
          </div>
          <p class="pt-3 text-center dark:text-n0 font-medium text-sm">
            Topup
          </p>
        </a>
        <a
          href="<?php echo e(route('send')); ?>"
          class="bg-red-200 rounded-2xl p-4 flex-1 max-w-[85px] flex flex-col justify-center items-center shrink-0"
        >
          <div
            class="h-7 w-7 rounded-full bg-n0 flex justify-center items-center"
          >
            <img src="/muladash/assets/images/icon2.png" class="size-4" alt="" />
          </div>
          <p class="pt-3 text-center dark:text-n0 font-medium text-sm">
            Send
          </p>
        </a>
        <a
          href="<?php echo e(route('paybills')); ?>"
          class="bg-yellow-200 rounded-2xl p-4 flex-1 max-w-[85px] flex flex-col justify-center items-center shrink-0"
        >
          <div
            class="h-7 w-7 rounded-full bg-n0 flex justify-center items-center"
          >
            <img src="/muladash/assets/images/icon3.png" class="size-4" alt="" />
          </div>
          <p class="pt-3 text-center dark:text-n0 font-medium text-sm">
            Pay
          </p>
        </a>
            <?php if(Auth::user()->account_verify == 'Verified'): ?>
        
        <a
          href="<?php echo e(route('withdraw')); ?>"
          class="bg-sky-200 rounded-2xl p-4 flex-1 max-w-[85px] flex flex-col justify-center items-center shrink-0"
        >
          <div class="h-7 w-7 rounded-full bg-n0 flex justify-center items-center">
            <i class="ph-fill ph-hand-withdraw text-white"></i>
          </div>
          <p class="pt-3 text-center dark:text-n0 font-medium text-sm">
            Withdraw
          </p>
        </a>
    <?php else: ?>
        
        <a href="<?php echo e(route('kycform')); ?>"
          class="bg-sky-200 rounded-2xl p-4 flex-1 max-w-[85px] flex flex-col justify-center items-center shrink-0"
        >
          <div class="h-7 w-7 rounded-full bg-n0 flex justify-center items-center">
            <img src="/muladash/assets/images/icon2.png" class="size-4" alt="" />
          </div>
          <p class="pt-3 text-center dark:text-n0 font-medium text-sm">
            KYC
          </p>
        </a>
    <?php endif; ?>
          </div>
        </div>
        <div class="bg-white rounded-t-3xl pt-14 -mt-14 flex-1 pb-32 dark:bg-n0">
         
   
          <?php if($cards->isEmpty()): ?>
          <div class="text-center text-n500 mt-6" style="margin-top: 15px;">
              <p>No Cards Available, Kindly Request for one.</p>
          </div>
      <?php else: ?>
          <div class="carousel-container">
              <div class="card-track" id="cardTrack">
                  <?php $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <div class="credit-card 
                          <?php echo e($card->card_type == 'visa_card' ? 'visa' : ($card->card_type == 'master_card' ? 'mastercard' : 'gold')); ?>">
                          
                          <div class="chip"></div>
                          <div class="card-type">
                              <?php echo e(strtoupper(str_replace('_', ' ', $card->card_type))); ?>

                          </div>
                          <div class="card-number"><?php echo e($card->cardnum); ?></div>
                          <div class="card-details">
                              <span><?php echo e($card->fullname); ?></span>
                              <span><?php echo e($card->month); ?>/<?php echo e($card->year); ?></span>
                          </div>
                          <div class="cvv">CVV: <?php echo e($card->ccv); ?></div>
                          <div class="balance">Bal: $<?php echo e(number_format($card->balance, 2)); ?></div>
                      </div>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
          </div>
      <?php endif; ?>
      
        
    
    <!-- Plus Button Centered -->
    <button class="add-card-btn contactSavedConfirmationModalOpenButton" >+</button>
    

    <div class="px-6 pt-8">
        <div class="flex justify-between items-center">
          <p class="text-xl font-semibold">Recent Card Transactions</p>
          <a
            href="<?php echo e(route('cardtransactions')); ?>"
            class="text-g300 font-semibold text-sm"
          >
            View All</a
          >
        </div>
        <div class="flex flex-col gap-4 pt-6">
         
        

      
          <?php
          use Illuminate\Support\Str;
        ?>
        
        <?php $__currentLoopData = $recentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="flex justify-between items-center border-b border-dashed border-n40 dark:border-darkN40 pb-4">
            
            <div class="flex justify-start items-center gap-4">
                
                <div class="rounded-full bg-bgColor2 dark:bg-darkN40 flex justify-center items-center w-[60px] h-[60px]">
                    <i class="ph ph-credit-card text-2xl text-g300"></i>
                </div>
    
                <div>
                    <p class="font-semibold"><?php echo e($tx->title); ?></p>
                    <p class="text-n500 dark:text-darkN500 text-xs pt-2.5">
                        <?php echo e($tx->description); ?><br/>
                        <?php echo e(\Carbon\Carbon::parse($tx->date)->toDayDateTimeString()); ?>

                    </p>
                </div>
            </div>
    
            
            <div class="flex flex-col justify-end items-end">
                <?php if($tx->amount > 0): ?>
                    <p class="font-semibold pb-2 text-green-500">+<?php echo e($settings->currency); ?> <?php echo e(number_format($tx->amount, 2)); ?></p>
                <?php else: ?>
                    <p class="font-semibold pb-2 text-red-500"><?php echo e($settings->currency); ?> <?php echo e(number_format($tx->amount, 2)); ?></p>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    


        
       
          
        </div>
      </div>
    </div>

    <!-- Contact Saved Confirmation Modal Start  -->
    <div
      class="contactSavedConfirmationModal container fixed inset-0 z-30 popup-modal"
    >
      <div
        class="modalBg absolute inset-0 bg-black opacity-30 dark:bg-white"
      ></div>
      <div
        class="modal relative z-10 flex h-full flex-col items-center justify-center px-6 text-center"
      >
        <div class="rounded-2xl bg-white p-7 dark:bg-n0 w-full">
          
            <div class="flex flex-col justify-start">
                <p class="text-sm font-semibold pb-2 dark:text-white">
                  Select Card Type method
                </p>
                <div class="relative">
                  <div
                    class="p-3 flex justify-between items-center gap-2 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl cursor-pointer selectCountry"
                  >
                    <div class="flex justify-start items-center gap-1">
                      <div
                        class="size-7 flex justify-center items-center rounded-full bg-white dark:bg-darkG300"
                      >
                        <img src="<?php echo e(asset('storage/'.$settings->favicon)); ?>" alt="" />
                      </div>
                      <li class="text-n90 text-sm dark:text-white selectedItem" data-type="visa_card">
                        Visa Prepaid Card (limit: $2,000)
                      </li>
                    </div>
                    <i class="ph ph-caret-down text-n90 text-lg !leading-none"></i>
                  </div>
                  <div
                    class="bg-white p-4 rounded-xl border border-n40 dark:border-darkN40 dark:bg-darkG300 w-full absolute right-0 top-14 max-h-[150px] overflow-y-auto selectCountryModal invisible opacity-0 scale-75 duration-500"
                  >
                    <ul class="flex flex-col gap-2">
                        <li data-type="visa_card"
                        class="text-xs text-n500 dark:text-darkN500 pb-2 border-b border-dashed border-n40 dark:border-darkN40 cursor-pointer item"
                      >
                      Visa Prepaid Card (Balance: $2,000)
                      </li>
                      <li data-type="master_card"
                        class="text-xs text-n500 dark:text-darkN500 pb-2 border-b border-dashed border-n40 dark:border-darkN40 cursor-pointer item"
                      >
                      Master Prepaid Card (Balance: $20,000)
                      </li>
                      <li data-type="gold_card"
                        class="text-xs text-n500 dark:text-darkN500 pb-2 border-b border-dashed border-n40 dark:border-darkN40 cursor-pointer item"
                      >
                         Gold Card (Balance: $50,000)
                      </li>
                     
                    </ul>
                  </div>
                </div>
              </div>

         
          <div class="flex justify-between items-center gap-4 pt-5">
            <button
              class="flex-1 py-3 bg-bgColor text-g300 font-medium text-center rounded-xl border border-bgColor2 dark:bg-darkN20 dark:border-darkN40 contactSavedConfirmationModalCloseButton"
            >
              Cancel
            </button>
            <button id="confirmCardRequest"
              
              class="flex-1 py-3 bg-g300 text-white text-center rounded-xl font-medium border border-g300"
              >Request</a
            >
          </div>
        </div>
      </div>
    </div>
    <!-- Contact Saved Confirmation Modal End -->
    
    <script>
        // Auto Swipe Logic
        const track = document.getElementById('cardTrack');
        const cards = document.querySelectorAll('.credit-card');
        let index = 0;
    
        setInterval(() => {
            index = (index + 1) % cards.length;
            track.style.transform = `translateX(-${index * 330}px)`;  // 320px card + 10px margin
        }, 3000);
    
    </script>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function(){
        $('#confirmCardRequest').on('click', function() {
            let selectedCard = $('.selectCountryModal .item.selected').data('type');
            let $btn = $(this);
    
            if (!selectedCard) {
                toastr.error('Please select a card type.');
                return;
            }
    
            // Disable button and change text
            $btn.prop('disabled', true).text('Requesting...');
    
            $.ajax({
                url: "<?php echo e(route('request.card')); ?>",
                method: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    card_type: selectedCard
                },
                success: function(response) {
                    toastr.success(response.message);
                    setTimeout(() => location.reload(), 1500);
                },
                error: function(xhr) {
                    toastr.error(xhr.responseJSON.message || 'Card request failed.');
                    $btn.prop('disabled', false).text('Confirm Request');
                }
            });
        });
    
        // Handle card selection
        $('.selectCountryModal .item').on('click', function() {
            $('.selectCountryModal .item').removeClass('selected');
            $(this).addClass('selected');
        });
    });
    </script>
    
<?php $__env->stopSection(); ?>    
<?php echo $__env->make('layouts.muladash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/virus/resources/views/user/cards.blade.php ENDPATH**/ ?>