<?php

use Illuminate\Foundation\Auth\EmailVerificationRequest;
use Illuminate\Http\Request;
use App\Http\Controllers\User\ViewsController;
use App\Http\Controllers\User\WithdrawalController;
use App\Http\Controllers\User\ProfileController;
use App\Http\Controllers\User\DepositController;
use App\Http\Controllers\User\VerifyController;
use App\Http\Controllers\User\UserController;
use Illuminate\Support\Facades\Route;

// Email verification routes
Route::get('/verify-email', 'App\Http\Controllers\User\UsersController@verifyemail')->middleware('auth')->name('verification.notice');;

Route::get('/email/verify/{id}/{hash}', function (EmailVerificationRequest $request) {
    $request->fulfill();
    return redirect('/dashboard');
})->middleware(['auth', 'signed'])->name('verification.verify');

Route::post('/email/verification-notification', function (Request $request) {
    $request->user()->sendEmailVerificationNotification();
    return back()->with('message', 'Verification link sent!');
})->middleware(['auth', 'throttle:6,1'])->name('verification.send');



/*    Dashboard and user features routes  */
// Views routes
Route::middleware(['auth', 'verified', 'complete.kyc'])->get('/dashboard', [ViewsController::class, 'dashboard'])->name('dashboard');

Route::middleware(['auth', 'verified'])->prefix('dashboard')->group(function () {






//UserActiion Controller

Route::post('passwordupdate', [UserController::class, 'PasswordUpdate'])->name('passwordupdate');
Route::post('updatebank', [UserController::class, 'UpdateBank'])->name('updatebank');
Route::post('saveaccount', [UserController::class, 'saveAccount'])->name('saveaccount');
Route::post('resolve-account', [UserController::class, 'UpdateBank'])->name('resolveAccount');
Route::post('save-account', [UserController::class, 'saveAccount'])->name('saveAccount');
Route::post('contacts/{contact}/toggle-favorite',[UserController::class, 'toggleFavorite'])->name('contacts.toggleFavorite');
Route::post('add-contact',[UserController::class, 'addContact'])->name('contacts.add');
Route::post('sendtocontact/{id}',[UserController::class, 'sendToContact'])->name('sendtocontact');
Route::put('contacts/{id}', [UserController::class, 'editContacts'])->name('contacts.update');
Route::delete('contacts/{id}', [UserController::class, 'destroy'])->name('contacts.destroy');
Route::get('fetch-username-details', [UserController::class, 'fetchUsernameDetails'])->name('fetch.username.details');
Route::post('send-username', [UserController::class, 'processSendToUsername'])->name('send.username.process');
Route::post('/request-card', [UserController::class, 'createCard'])->name('request.card');
Route::post('/kyc-submit', [UserController::class, 'submitKYC'])->name('kycsubmit');
Route::post('/pay-bill', [UserController::class, 'payBill'])->name('pay.bill');
Route::post('/buy-crypto', [UserController::class, 'processBuyCrypto'])->name('buy.crypto');
Route::post('/pay-bill', [UserController::class, 'processBillPayment'])->name('pay.bill');
Route::post('/toggle-security', [UserController::class, 'toggleSecuritySettings'])->name('toggle.security');









//Views Controller

Route::get('kyc-form', [ViewsController::class, 'verificationForm'])->name('kycform');
Route::get('support', [ViewsController::class, 'support'])->name('support');
Route::get('withdrawalinformation', [ViewsController::class, 'WithdrawalInformation'])->name('withdrawalinformation');
Route::get('updatebank', [ViewsController::class, 'UpdateBank'])->name('updatebank');
Route::get('notifications', [ViewsController::class, 'notifications'])->name('notifications');

Route::middleware('complete.kyc')->group(function () {
Route::get('account-settings', [ViewsController::class, 'profile'])->name('profile');
Route::get('accountdetails', [ViewsController::class, 'accountdetails'])->name('accountdetails');
Route::get('notification', [ViewsController::class, 'notification'])->name('notification');

Route::get('receive', [ViewsController::class, 'deposits'])->name('deposits');
Route::get('/details/{symbol}', [ViewsController::class, 'coinDetails'])->name('coin.details');
Route::get('/details/{symbol}/{id}', [ViewsController::class, 'details'])->name('details');
Route::get('withdraw', [ViewsController::class, 'withdrawals'])->name('withdraw');
Route::get('newdeposit', [ViewsController::class, 'newdeposit'])->name('newdeposit');
Route::get('transactions', [ViewsController::class, 'transactions'])->name('transactions');
Route::get('insights', [ViewsController::class, 'Insights'])->name('insights');
Route::get('personal-profile', [ViewsController::class, 'PersonalProfile'])->name('personalprofile');
Route::get('security', [ViewsController::class, 'Security'])->name('security');
Route::get('passwordupdate', [ViewsController::class, 'PasswordUpdate'])->name('passwordupdate');
Route::get('manage-account-security', [ViewsController::class, 'twofa'])->name('twofa');
Route::get('contacts', [ViewsController::class, 'contacts'])->name('contacts');
Route::get('view-contacts', [ViewsController::class, 'viewcontacts'])->name('viewcontacts');
Route::get('contacts/{id}/edit', [ViewsController::class, 'editcontacts'])->name('editcontacts');
Route::get('contacts/{id}/details', [ViewsController::class, 'contactdetails'])->name('contactdetails');
Route::get('transaction/{id}', [ViewsController::class, 'showStatus'])->name('status');
Route::get('add-contact',[ViewsController::class, 'addContact'])->name('contacts.add');
Route::get('send', [ViewsController::class, 'send'])->name('send');
Route::get('sendtocontact/{id}', [ViewsController::class, 'sendToContact'])->name('sendtocontact');
Route::get('sendtousername', [ViewsController::class, 'sendToUsername'])->name('sendtousername');
Route::get('transaction/{id}/receipt', [ViewsController::class, 'downloadReceipt'])->name('transaction.receipt');
Route::get('cards', [ViewsController::class, 'cards'])->name('cards');
Route::get('paybills', [ViewsController::class, 'payBills'])->name('paybills');
Route::get('card-transactions', [ViewsController::class, 'cardTransactions'])->name('cardtransactions');
Route::get('buy-crypto', [ViewsController::class, 'buyCrypto'])->name('buycrypto');
Route::get('about-us', [ViewsController::class, 'aboutUs'])->name('aboutus');
Route::get('policy', [ViewsController::class, 'policy'])->name('policy');




//Deposits
Route::post('newdeposit', [DepositController::class, 'newdeposit'])->name('newdeposit');
Route::get('payment', [DepositController::class, 'payment'])->name('payment');
Route::post('savedeposit', [DepositController::class, 'savedeposit'])->name('savedeposit');
       

// Withdrawals
Route::post('enter-amount', [WithdrawalController::class, 'withdrawamount'])->name('withdrawamount');
Route::get('enter-amount', [WithdrawalController::class, 'withdrawamount'])->name('withdrawamount');
Route::get('send-funds', [WithdrawalController::class, 'withdrawfunds'])->name('withdrawfunds');
Route::get('getotp', [WithdrawalController::class, 'getotp'])->name('getotp');
Route::post('completewithdrawal', [WithdrawalController::class, 'completewithdrawal'])->name('completewithdrawal');

// send




        

    });
});
Route::post('sendcontact', 'App\Http\Controllers\User\UsersController@sendcontact')->name('enquiry');



