<style>
    .custom-pagination {
        display: flex;
        flex-wrap: nowrap;    /* Prevent wrapping */
        list-style: none;
        padding: 0;
        margin: 0;
        gap: 6px;              /* Space between items */
    }

    .custom-pagination li {
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 50% !important;
    }

    .custom-pagination a, 
    .custom-pagination span {
        display: block;
        padding: 8px 12px;
        border: 1px solid #ddd;
        border-radius: 4px;
        text-decoration: none;
        color: #333;
        min-width: 40px;
        text-align: center;
        border-radius: 50% !important;
    }

    .custom-pagination .active span {
        background-color: rgb(67, 126, 157);
        color: white;
        border-color: rgb(67, 126, 157);
    }

    .custom-pagination .disabled span {
        color: #999;
        cursor: not-allowed;
    }

    /* Ensure the pagination stays inside its container */
    .card-body {
        overflow-x: auto;
    }
</style>


@if ($paginator->hasPages()) 
<div class="card">
    <div class="card-body">
        <nav>
            <ul class="pagination custom-pagination">
                    {{-- Previous Page Link --}}
                    @if ($paginator->onFirstPage())
                        <li class="disabled" aria-disabled="true" aria-label="@lang('pagination.previous')">
                            <span aria-hidden="true">&lsaquo;</span>
                        </li>
                    @else
                        <li>
                            <a href="{{ $paginator->previousPageUrl() }}" rel="prev" aria-label="@lang('pagination.previous')">&lsaquo;</a>
                        </li>
                    @endif

                    {{-- Pagination Elements --}}
                    @foreach ($elements as $element)
                        @if (is_string($element))
                            <li class="disabled" aria-disabled="true"><span>{{ $element }}</span></li>
                        @endif

                        @if (is_array($element))
                            @foreach ($element as $page => $url)
                                @if ($page == $paginator->currentPage())
                                    <li class="active" aria-current="page"><span>{{ $page }}</span></li>
                                @else
                                    <li><a href="{{ $url }}">{{ $page }}</a></li>
                                @endif
                            @endforeach
                        @endif
                    @endforeach

                    {{-- Next Page Link --}}
                    @if ($paginator->hasMorePages())
                        <li>
                            <a href="{{ $paginator->nextPageUrl() }}" rel="next" aria-label="@lang('pagination.next')">&rsaquo;</a>
                        </li>
                    @else
                        <li class="disabled" aria-disabled="true" aria-label="@lang('pagination.next')">
                            <span aria-hidden="true">&rsaquo;</span>
                        </li>
                    @endif
                </ul>
            </nav>
        </div>
    </div>
@endif
