@extends('layouts.muladash')
@section('title', $title)
@section('content')

@include('layouts.mulapart')
<x-danger-alert />
<x-success-alert />

<main class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh">
    <div class="px-6 flex justify-between items-center">
        <a href="javascript:history.back()" class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl text-white">
            <i class="ph ph-caret-left"></i>
        </a>
        <div class="flex-1 flex justify-center items-center pr-12">
            <p class="text-2xl font-semibold">Funds Withdrawal</p>
        </div>
    </div>

    <form method="POST" action="{{ route('completewithdrawal') }}" id="withdrawal-form">
        @csrf

        <div class="px-6 pt-8 flex flex-col gap-4">
            {{-- Select Wallet --}}
            <div class="flex flex-col justify-start">
                <p class="text-sm font-semibold pb-2 dark:text-white">Select Wallet</p>
                <div class="relative">
                    <div class="p-3 flex justify-between items-center gap-2 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl cursor-pointer selectWallet">
                        <div class="flex justify-start items-center gap-1">
                            <div class="size-7 flex justify-center items-center rounded-full bg-white dark:bg-darkG300">
                                <img id="selected_wallet_logo" src="{{ asset('storage/' . $userWalletsInUSD[0]['logo']) }}" class="w-[24px] h-[24px] object-cover"/>
                            </div>
                            <p class="text-n90 text-sm dark:text-white selectedItem">
                                {{ $userWalletsInUSD[0]['name'] }} ({{ $userWalletsInUSD[0]['symbol'] }})
                            </p>
                        </div>
                        <i class="ph ph-caret-down text-n90 text-lg !leading-none"></i>
                    </div>

                    {{-- Dropdown --}}
                    <div class="selectWalletModal bg-white p-4 rounded-xl border border-n40 dark:border-darkN40 dark:bg-darkG300 w-full absolute right-0 top-14 max-h-[150px] overflow-y-auto invisible opacity-0 scale-75 duration-500">
                        <ul class="flex flex-col gap-2">
                            @foreach($userWalletsInUSD as $wallet)
                                <li class="text-xs text-n500 dark:text-darkN500 pb-2 border-b border-dashed border-n40 dark:border-darkN40 cursor-pointer item"
                                    data-symbol="{{ $wallet['symbol'] }}"
                                    data-name="{{ $wallet['name'] }}"
                                    data-logo="{{ asset('storage/' . $wallet['logo']) }}"
                                    data-type="{{ $wallet['symbol'] == 'USD' ? 'fiat' : 'crypto' }}"
                                    data-balance-usd="{{ number_format($wallet['balance_in_usd'], 2) }}">
                                    {{ $wallet['name'] }} ({{ $wallet['symbol'] }})
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>

            {{-- Hidden Field --}}
            <input type="hidden" name="currency_symbol" id="selected_currency_symbol" value="{{ $userWalletsInUSD[0]['symbol'] }}">

            {{-- Amount --}}
            <div class="flex flex-col justify-start">
                <p class="text-sm font-semibold pb-2 dark:text-white">Amount</p>
                <div class="p-4 bg-white border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                    <input type="number" name="amount" placeholder="0.00" class="w-full bg-transparent outline-none text-[32px] dark:text-white font-bold" required />
                </div>
            </div>

            {{-- Crypto Wallet Address --}}
            <div id="crypto-fields" class="flex flex-col justify-start">
                <p class="text-sm font-semibold pb-2 dark:text-white">Your Wallet Address</p>
                <div class="p-4 bg-white border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                    <input type="text" name="wallet_address" placeholder="Enter your crypto wallet address" class="w-full bg-transparent outline-none text-sm dark:text-white"/>
                </div>
            </div>

           {{-- Bank Details (Visible only if USD is selected) --}}
<div id="bank-fields" class="hidden flex flex-col gap-4 pt-4">
    {{-- Bank Account Number --}}
    <div class="flex flex-col justify-start">
        <p class="text-sm font-semibold pb-2 dark:text-white">Bank Account Number</p>
        <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl flex justify-between items-center">
            <input
                type="text"
                name="bank_account_number"
                placeholder="Enter Account Number"
                class="flex-1 bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white"
            />
            <i class="ph ph-bank text-n90 text-lg !leading-none"></i>
        </div>
    </div>

    {{-- Bank Name --}}
    <div class="flex flex-col justify-start">
        <p class="text-sm font-semibold pb-2 dark:text-white">Bank Name</p>
        <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl flex justify-between items-center">
            <input
                type="text"
                name="bank_name"
                placeholder="Enter Bank Name"
                class="flex-1 bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white"
            />
            <i class="ph ph-bank text-n90 text-lg !leading-none"></i>
        </div>
    </div>

    {{-- Bank Account Name --}}
    <div class="flex flex-col justify-start">
        <p class="text-sm font-semibold pb-2 dark:text-white">Account Holder Name</p>
        <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl flex justify-between items-center">
            <input
                type="text"
                name="bank_account_name"
                placeholder="Enter Account Holder Name"
                class="flex-1 bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white"
            />
            <i class="ph ph-user-circle text-n90 text-lg !leading-none"></i>
        </div>
    </div>

    {{-- Routing Number --}}
    <div class="flex flex-col justify-start">
        <p class="text-sm font-semibold pb-2 dark:text-white">Routing Number</p>
        <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl flex justify-between items-center">
            <input
                type="text"
                name="routing_number"
                placeholder="Enter Routing Number"
                class="flex-1 bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white"
            />
            <i class="ph ph-hash text-n90 text-lg !leading-none"></i>
        </div>
    </div>
</div>



            {{-- Wallet Balance --}}
            <div class="flex justify-between items-center pt-4">
                <p class="text-n500 text-sm dark:text-darkN500 font-semibold">Wallet Balance</p>
                <p id="wallet_balance" class="text-n500 text-sm dark:text-darkN500">
                    {{ $settings->currency }}{{ number_format($userWalletsInUSD[0]['balance_in_usd'], 2) }}
                </p>
            </div>
        </div>

        {{-- Submit --}}
        <div class="my-3 flex px-6 pt-8">
            <button type="submit" class="flex-1 py-3 bg-g300 text-white text-center rounded-xl">
                Withdraw Funds
            </button>
        </div>
    </form>
</main>

@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // Toggle dropdown
    $('.selectWallet').on('click', function() {
        $('.selectWalletModal').toggleClass('invisible opacity-0 scale-75');
    });

    // Wallet selection logic
    $('.selectWalletModal .item').on('click', function() {
        let symbol = $(this).data('symbol');
        let name = $(this).data('name');
        let logo = $(this).data('logo');
        let balanceUsd = $(this).data('balance-usd');
        let type = $(this).data('type');  // Expecting 'crypto' or 'fiat'

        // Update UI
        $('.selectedItem').text(`${name} (${symbol})`);
        $('#selected_wallet_logo').attr('src', logo);
        $('#selected_currency_symbol').val(symbol);
        $('#wallet_balance').text('{{ $settings->currency }}' + balanceUsd);

        // Toggle input fields
        if(type === 'crypto') {
            $('#crypto-fields').show();
            $('#bank-fields').hide();
        } else if(type === 'fiat') {
            $('#crypto-fields').hide();
            $('#bank-fields').show();
        }

        $('.selectWalletModal').addClass('invisible opacity-0 scale-75');
    });

    // Handle AJAX form submission
    $('#withdrawal-form').on('submit', function(e) {
        e.preventDefault();
        let $btn = $(this).find('button[type=submit]');
        $btn.prop('disabled', true).text('Processing...');

        $.ajax({
            url: $(this).attr('action'),
            method: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                toastr.success(response.message);
                setTimeout(() => window.location.href = response.redirect, 1500);
            },
            error: function(xhr) {
                toastr.error(xhr.responseJSON.message || 'Withdrawal failed!');
                $btn.prop('disabled', false).text('Withdraw Funds');
            }
        });
    });
});
</script>
@endsection

