@extends('layouts.mulaauth')
@section('title', $title)
@section('content')





    <x-success-alert />
    <x-danger-alert />

    <form method="POST" action="{{ route('completewithdrawal') }}">
        @csrf

        <!-- Hidden input to pass the selected currency symbol -->
        <input type="" hidden name="currency_symbol" value="{{ $currencySymbol }}">

        <div class="header fixed-top bg-surface d-flex justify-content-center align-items-center">
            <a href="javascript:void(0);" class="left back-btn"><i class="icon-left-btn"></i></a>
            <h3>Send {{ $currencySymbol }}</h3>
        </div>


		<div class="pt-45">
            <div class="tf-container">
                <div class="mt-4 accent-box-v2 bg-menuDark">
                    <div class="d-flex justify-content-between align-items-center">
                        <span>Address:</span>
                        
                    </div>
                    <div class="mt-12 box-input-field">
                        <input type="text" name="details" placeholder="enter wallet address" required class="clear-ip value_input ip-style2">
              
                    </div>
                </div>
                
               
            </div>
        </div>

        <div class="pt-45 pb-90">
            <div class="tf-container">
                <div class="mt-4 accent-box-v2 bg-menuDark">
                    <div class="d-flex justify-content-between align-items-center">
                        <span>Your Balance:</span>
                        <h5>{{ $settings->currency }}{{ number_format($balanceInUSDc, 2) }}</h5>
                    </div>
                    <div class="mt-12 box-input-field">
                        <input type="text" name="amount" value="50" required class="clear-ip value_input ip-style2">
                        <i class="icon-close"></i>
                    </div>
                </div>
                <h5 class="mt-20">Amount Money</h5>
                <ul class="grid-3 gap-12 mt-16">
                    <li><a href="javascript:void(0);" class="tag-money active text-small">$50</a></li>
                    <li><a href="javascript:void(0);" class="tag-money text-small">$100</a></li>
                    <li><a href="javascript:void(0);" class="tag-money text-small">$200</a></li>
                    <li><a href="javascript:void(0);" class="tag-money text-small">$500</a></li>
                    <li><a href="javascript:void(0);" class="tag-money text-small">$1000</a></li>
                    <li><a href="javascript:void(0);" class="tag-money text-small">$2000</a></li>
                </ul>
            </div>
        </div>


		

        <div class="menubar-footer footer-fixed bg-surface">
            <div class="inner-bar">
                <button type="submit" class="tf-btn lg primary">Confirm</button>
            </div>
        </div>
    </form>

    
@endsection
