@extends('layouts.muladash')
@section('title', $title)
@section('content')
    <!-- Title -->

    @include('layouts.mulapart')
    
    <body class="">
        <!-- Splash Screen Start -->
        <div class="preloader inset-0 z-50 hidden">
          <div class="h-full bg-bgColor flex flex-col justify-center items-center text-center container">
            <div class="zoomInOut">
              <div><img src="{{ asset('assets/images/logo.png') }}" alt="Logo" /></div>
              <p class="pt-6 text-4xl font-bold text-n900">
                {{ $settings->site_name }}<span class="text-g300">X</span>
              </p>
            </div>
          </div>
        </div>
        <!-- Splash Screen End -->
      
        <main class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh pb-32">
          {{-- Header --}}
          <div class="px-6 flex justify-between items-center">
            <div class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl !leading-none text-white">
                <a href="javascript:history.back()"
                class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl !leading-none text-white">
               <i class="ph ph-caret-left"></i>
             </a>
            </div>
            <div class="flex-1 flex justify-center items-center pr-12">
              <p class="text-2xl font-semibold">Contacts</p>
            </div>
          </div>
      
          {{-- Search & Filters --}}
          <div class="pt-8 flex justify-start items-center gap-2 px-6">
            <div class="flex justify-between items-center flex-1 border border-n40 dark:border-darkN40 dark:bg-darkN20 rounded-xl p-3 gap-2">
              <i class="ph ph-magnifying-glass text-n70"></i>
              <input
              type="text"
              id="contact-search"
              placeholder="Search here..."
              class="placeholder:text-n90 text-xs bg-transparent outline-none flex-1"
            />
            
              <i class="ph ph-microphone text-n70"></i>
            </div>
            <button class="p-3 bg-g300 rounded-md text-white text-2xl !leading-none flex justify-center items-center">
              <i class="ph ph-sliders-horizontal"></i>
            </button>
          </div>
      
          {{-- Tabs --}}
          <div class="contact-tab">
            <ul class="px-6 pt-8 flex justify-between items-center tab-button">
              <li class="flex-1 text-center text-lg font-semibold pb-1 border-b-2 border-g300 text-g300 tab-item cursor-pointer">
                All Contacts
              </li>
              <li class="flex-1 text-center text-lg font-semibold pb-1 border-b-2 border-n40 tab-item cursor-pointer">
                Favourites
              </li>
            </ul>
      
            <div class="flex justify-between items-start gap-4 pt-8 px-6">
              {{-- All Contacts --}}
              <div class="animationOne content flex-1" id="all-contacts">
                @php
                  $allContacts = $contacts
                    ->sortBy('name')
                    ->groupBy(fn($c) => strtoupper(substr($c->name, 0, 1)));
                @endphp
      
                @foreach($allContacts as $letter => $group)
                  <div class="mb-8">
                    <p class="text-xl font-semibold pb-5">{{ $letter }}</p>
                    <div class="flex flex-col gap-4">
                      @foreach($group as $contact)
                        <a href="{{ route('contactdetails', ['id' => $contact->id]) }}"
                           class="p-4 rounded-2xl border border-n40 flex flex-col gap-4 dark:border-darkN40">
                          <div class="flex justify-between items-center">
                            <div class="flex justify-start items-center gap-4">
                              <div class="rounded-full bg-bgColor2 w-[60px] h-[60px] overflow-hidden dark:bg-darkN40">
                                {{-- placeholder avatar --}}
                                <img src="{{ asset('muladash/assets/images/people-1.png') }}"
                                     alt="{{ $contact->name }}"
                                     class="w-full h-full object-cover" />
                              </div>
                              <div>
                                <p class="font-semibold">{{ $contact->name }}</p>
                                <p class="font-semibold">{{ $contact->type }}</p>
                                <p class="text-n500 dark:text-darkN500 text-xs pt-2.5">
                                    @if($contact->type === 'bank')
                                      Bank: {{ $contact->bank_name }}<br>
                                      Account No: {{ $contact->bank_account_number }}
                                    @else
                                      Address: {{ substr($contact->wallet_address, 0, 5) }}…{{ substr($contact->wallet_address, -5) }}
                                    @endif
                                  </p>
                                  
                              </div>
                            </div>
                            <div>
                                <i
                                class="toggle-favorite ph ph-star {{ $contact->liked==='yes'?'ph-fill':'' }}"
                                data-url="{{ route('contacts.toggleFavorite', ['contact' => $contact->id]) }}"
                                style="cursor:pointer"
                              ></i>
                              

                            </div>
                          </div>
                        </a>
                      @endforeach
                    </div>
                  </div>
                @endforeach
              </div>
      
              {{-- Favourites --}}
              <div class="animationTwo content hidden flex-1" id="favourites">
                @php
                  $favContacts = $contacts
                    ->where('liked', 'yes')
                    ->sortBy('name')
                    ->groupBy(fn($c) => strtoupper(substr($c->name, 0, 1)));
                @endphp
      
                @foreach($favContacts as $letter => $group)
                  <div class="mb-8">
                    <p class="text-xl font-semibold pb-5">{{ $letter }}</p>
                    <div class="flex flex-col gap-4">
                      @foreach($group as $contact)
                        <a href="{{ route('contactdetails', ['id' => $contact->id]) }}"
                           class="p-4 rounded-2xl border border-n40 flex flex-col gap-4 dark:border-darkN40">
                          <div class="flex justify-between items-center">
                            <div class="flex justify-start items-center gap-4">
                              <div class="rounded-full bg-bgColor2 w-[60px] h-[60px] overflow-hidden dark:bg-darkN40">
                                <img src="{{ asset('assets/images/people-1.png') }}"
                                     alt="{{ $contact->name }}"
                                     class="w-full h-full object-cover" />
                              </div>
                              <div>
                                <p class="font-semibold">{{ $contact->name }}</p>
                                <p class="text-n500 dark:text-darkN500 text-xs pt-2.5">
                                  {{ $contact->type === 'bank'
                                      ? $contact->bank_account_number
                                      : $contact->wallet_address }}
                                </p>
                              </div>
                            </div>
                            <div>
                              <i class="ph ph-fill ph-star text-o300 text-2xl"></i>
                            </div>
                          </div>
                        </a>
                      @endforeach
                    </div>
                  </div>
                @endforeach
              </div>
            </div>
          </div>
      
          {{-- Add New Contact Button --}}
          <div class="fixed bottom-6 right-0 left-0 container">
            <a href="{{ route('contacts.add') }}"
               class="w-[60px] h-[60px] rounded-full bg-o300 flex justify-center items-center absolute bottom-32 right-6">
              <i class="ph ph-plus text-xl !leading-none"></i>
            </a>
          </div>
        </main>
    </body>
    @endsection
    @section('scripts')
    <script>
      // Ensure CSRF is in headers
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
          'Accept': 'application/json'
        }
      });
    
      $(document).on('click', '.toggle-favorite', function(e) {
        e.preventDefault();
        const $icon = $(this);
        const url   = $icon.data('url');
    
        $icon.prop('disabled', true);
    
        $.post(url)
          .done(res => {
            if (res.liked === 'yes') {
              $icon.addClass('ph-fill');
              toastr.success('Added to favourites');
            } else {
              $icon.removeClass('ph-fill');
              toastr.info('Removed from favourites');
            }
          })
          .fail(xhr => {
            console.error(xhr);
            toastr.error(xhr.responseJSON?.message || 'Could not update favourite');
          })
          .always(() => {
            $icon.prop('disabled', false);
          });
      });
    </script>
    <script>
        $(document).ready(function() {
          $('#contact-search').on('keyup', function() {
            var term = $(this).val().trim().toLowerCase();
      
            // for both All and Favourites sections
            $('#all-contacts, #favourites').each(function() {
              var $section = $(this);
      
              // for each letter‐group wrapper
              $section.find('> div.mb-8').each(function() {
                var $group = $(this);
                var anyVisible = false;
      
                // show/hide each contact card
                $group.find('a').each(function() {
                  var text = $(this).text().toLowerCase();
                  var match = text.indexOf(term) !== -1;
                  $(this).toggle(match);
                  if (match) anyVisible = true;
                });
      
                // hide the entire letter block if none of its cards match
                $group.toggle(anyVisible);
              });
            });
          });
        });
      </script>
    @endsection
    
    
