
@extends('layouts.mulaauth')
@section('title', $title)
@section('content')
   


		<x-danger-alert />
		<x-success-alert />
        <x-error-alert />

       <body class="">
<main class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh">
        <div class="px-6 flex justify-between items-center pb-8">
          <a
            href="javascript:history.back()"
            class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl !leading-none text-white"
          >
            <i class="ph ph-caret-left"></i>
          </a>
          <div class="flex-1 flex justify-center items-center pr-12">
            <p class="text-2xl font-semibold">KYC Verification</p>
          </div>
        </div>

        <div class="container px-6 pb-8 pt-12 h-dvh text-n900 dark:bg-n0">
          
       <!-- Login Form -->
       <form class="flex flex-col gap-4 pt-8" id="kycForm" action="{{ route('kycsubmit') }}" method="POST" enctype="multipart/form-data">
        @csrf
    
        {{-- First Name --}}
        <div class="flex flex-col justify-start">
            <p class="text-sm font-semibold pb-2 dark:text-white">First Name</p>
            <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                <input type="text" name="first_name" placeholder="Enter First Name" class="w-full bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white" required>
            </div>
        </div>
    
        {{-- Last Name --}}
        <div class="flex flex-col justify-start">
            <p class="text-sm font-semibold pb-2 dark:text-white">Last Name</p>
            <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                <input type="text" name="last_name" placeholder="Enter Last Name" class="w-full bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white" required>
            </div>
        </div>
    
        {{-- Email --}}
        <div class="flex flex-col justify-start">
            <p class="text-sm font-semibold pb-2 dark:text-white">Email</p>
            <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                <input type="email" name="email" placeholder="Enter Email Address" class="w-full bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white" required>
            </div>
        </div>
    
        {{-- Phone Number --}}
        <div class="flex flex-col justify-start">
            <p class="text-sm font-semibold pb-2 dark:text-white">Phone Number</p>
            <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                <input type="text" name="phone_number" placeholder="Enter Phone Number" class="w-full bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white" required>
            </div>
        </div>
    
        {{-- Date of Birth --}}
        <div class="flex flex-col justify-start">
            <p class="text-sm font-semibold pb-2 dark:text-white">Date of Birth</p>
            <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                <input type="date" name="dob" class="w-full bg-transparent outline-none text-sm dark:text-white" required>
            </div>
        </div>
    
        {{-- Country --}}
        <div class="flex flex-col justify-start">
            <p class="text-sm font-semibold pb-2 dark:text-white">Country</p>
            <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                <input type="text" name="country" placeholder="Enter Country" class="w-full bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white" required>
            </div>
        </div>
    
        {{-- Document Type --}}
        <div class="flex flex-col justify-start">
            <p class="text-sm font-semibold pb-2 dark:text-white">Document Type</p>
            <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                <select name="document_type" class="w-full bg-transparent outline-none text-sm dark:text-white" required>
                    <option value="">Select Document Type</option>
                    <option value="National ID">National ID</option>
                    <option value="Passport">Passport</option>
                    <option value="Driver's License">Driver's License</option>
                </select>
            </div>
        </div>
    
        {{-- Upload Front Image --}}
        <div class="flex flex-col justify-start">
            <p class="text-sm font-semibold pb-2 dark:text-white">Upload Front of Document</p>
            <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                <input type="file" name="frontimg" accept="image/*" class="w-full text-sm dark:text-white" required>
            </div>
        </div>
    
        {{-- Upload Back Image --}}
        <div class="flex flex-col justify-start">
            <p class="text-sm font-semibold pb-2 dark:text-white">Upload Back of Document</p>
            <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                <input type="file" name="backimg" accept="image/*" class="w-full text-sm dark:text-white" required>
            </div>
        </div>
    
        {{-- Submit --}}
        <div class="my-3 flex">
            <button type="submit" class="flex-1 py-3 bg-g300 text-white text-center rounded-xl">Submit KYC</button>
        </div>
    </form>
    
      
          <div class="pt-4 text-center text-sm text-n500 dark:text-darkN500">
            
           <!-- <a href="" class="text-g300 font-medium">Sign Up</a>  -->
          </div>
        </div>
</main>
      @endsection
      
      @section('scripts')
      
      <script>
        $(document).ready(function() {
          console.log("Document ready - binding KYC form submit event");
      
          $('#kycForm').on('submit', function(e) {
            e.preventDefault(); 
      
            var $button = $(this).find('button[type=submit]');
            $button.text('Processing...').prop('disabled', true);
      
            var formData = new FormData(this);
      
            $.ajax({
              url: $(this).attr('action'),
              method: 'POST',
              data: formData,
              processData: false,
              contentType: false,
              headers: { 'Accept': 'application/json' },
              success: function(response) {
                console.log("Success Response:", response);
      
                if (response.redirect) {
                  toastr.success(response.message, "Success", {
                    timeOut: 1500,
                    progressBar: true
                  });
                  setTimeout(function() {
                    window.location.href = response.redirect;
                  }, 1500);
                } else {
                  toastr.error(response.message || 'Verification failed.', "Failed", {
                    timeOut: 3000,
                    progressBar: true
                  });
                  $button.text('Submit KYC').prop('disabled', false);
                }
              },
              error: function(xhr) {
                console.log("Error Response:", xhr.responseJSON);
                var message = xhr.responseJSON?.message || 'Something went wrong.';
                toastr.error(message, "Error", {
                  timeOut: 3000,
                  progressBar: true
                });
                $button.text('Submit KYC').prop('disabled', false);
              }
            });
          });
        });
      </script>
      
      
@endsection
