@extends('layouts.muladash')
@section('title', $title)
@section('content')



		<x-danger-alert />
		<x-success-alert />

    <main class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh">

      <div class="px-6 flex justify-between items-center">
				<a href="{{ route('dashboard') }}"
				  class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl !leading-none text-white"
				>
				  <i class="ph ph-caret-left"></i>
				</a>
				<div class="flex-1 flex justify-center items-center pr-12">
				 
				</div>
			  </div>
    
        {{-- Success Animation --}}
        <div class="flex w-full items-center justify-center pt-12">
            <div class="wave-animation">
                <div class="waves wave-1"></div>
                <div class="waves wave-2"></div>
                <div class="waves wave-3"></div>
                <div class="flex size-[140px] items-center justify-center rounded-full bg-g300 text-[60px] text-p1">
                    <div class="flex size-[160px] items-center justify-center rounded-full">
                        <div class="flex size-[110px] items-center justify-center rounded-full bg-p1 text-white">
                            <img src="{{ asset('muladash/assets/images/money-sent-successfully.png') }}" alt="success" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    
        {{-- Headline --}}
        <div class="flex flex-col justify-center items-center text-center pt-12 pb-6">
            <p class="text-2xl font-semibold">
                {{ in_array($transaction->type, ['Transfer to Contact', 'Transfer to @username']) ? 'Transfer Successful!' : 'Transaction Successful!' }}
            </p>
            <p class="text-sm font-semibold pt-3 desc">
                @switch($transaction->type)
                    @case('Crypto Deposit') Crypto Deposit to {{ $settings->site_name }} Wallet @break
                    @case('Bank Deposit') Bank Deposit to {{ $settings->site_name }} Balance @break
                    @case('Bank Withdrawal') Withdrawal to Bank Account @break
                    @case('Crypto Withdrawal') Withdrawal to Crypto Wallet @break
                    @case('Transfer to Contact') Transfer to {{ $transaction->to }} @break
                    @case('Transfer to @username') Transfer to @{{ $transaction->to }} @break
                    @default {{ $transaction->type }}
                @endswitch
            </p>
            <p class="text-sm text-n500 dark:text-darkN500 pt-2">{{ Auth::user()->name }}</p>
            <p class="pt-6 text-[52px] font-bold">{{ $settings->currency }}{{ number_format($transaction->amount, 2) }}</p>
        </div>
    
        {{-- Details Card --}}
        @php
            $statusColor = match(strtolower($transaction->status)) {
                'completed' => 'text-green-500 bg-green-100',
                'pending'   => 'text-yellow-500 bg-yellow-100',
                'failed'    => 'text-red-500 bg-red-100',
                default     => 'text-gray-500 bg-gray-100'
            };
        @endphp
    
        <div class="bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 flex flex-col gap-5 p-4 mx-6 rounded-2xl">
            <div class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40">
                <p class="text-sm text-n500 dark:text-darkN500">Transaction Status</p>
                <p class="text-sm font-medium px-2 py-1 rounded {{ $statusColor }}">{{ ucfirst($transaction->status) }}</p>
            </div>
    
            @if($transaction->from)
            <div class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40">
                <p class="text-sm text-n500 dark:text-darkN500">From</p>
                <p class="text-sm">{{ $transaction->from }}</p>
            </div>
            @endif
    
            @if($transaction->to)
            <div class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40">
                <p class="text-sm text-n500 dark:text-darkN500">To</p>
                <p class="text-sm">{{ $transaction->to }}</p>
            </div>
            @endif
    
            @if($transaction->payment_mode)
            <div class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40">
                <p class="text-sm text-n500 dark:text-darkN500">Payment Method</p>
                <p class="text-sm">{{ $transaction->payment_mode }}</p>
            </div>
            @endif
    
            @if($transaction->bank_name)
            <div class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40">
                <p class="text-sm text-n500 dark:text-darkN500">Bank Name</p>
                <p class="text-sm">{{ $transaction->bank_name }}</p>
            </div>
            @endif
    
            @if($transaction->bank_account_number)
            <div class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40">
                <p class="text-sm text-n500 dark:text-darkN500">Account Number</p>
                <p class="text-sm">{{ $transaction->bank_account_number }}</p>
            </div>
            @endif
    
            @if($transaction->crypto_address)
            <div class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40">
                <p class="text-sm text-n500 dark:text-darkN500">Crypto Address</p>
                <p class="text-sm">{{ $transaction->crypto_address }}</p>
            </div>
            @endif
    
            <div class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40">
                <p class="text-sm text-n500 dark:text-darkN500">Date</p>
                <p class="text-sm">{{ \Carbon\Carbon::parse($transaction->transaction_time)->toDayDateTimeString() }}</p>
            </div>
    
            <div class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40">
                <p class="text-sm text-n500 dark:text-darkN500">Transaction Hash</p>
                <p class="text-sm">
                    {{ $transaction->hash ?? 'N/A' }}
                    <i class="ph ph-copy copy-btn cursor-pointer" data-copy="{{ $transaction->hash }}"></i>
                </p>
            </div>
    
            <div class="flex justify-between items-center">
                <p class="text-sm text-n500 dark:text-darkN500">Reference ID</p>
                <p class="text-sm">
                    {{ $transaction->ref }}
                    <i class="ph ph-copy copy-btn cursor-pointer" data-copy="{{ $transaction->ref }}"></i>
                </p>
            </div>
        </div>
    
        {{-- Notes --}}
        @if($transaction->notes)
        <div class="pt-4 px-6">
            <div class="bg-bgColor border border-bgColor2 rounded-2xl p-4 dark:bg-darkN20 dark:border-darkN40">
                <p class="text-sm font-medium pb-4 border-b border-dashed border-n40 dark:border-darkN40">Notes :</p>
                <p class="text-n500 dark:text-darkN500 text-sm pt-4">{{ $transaction->notes }}</p>
            </div>
        </div>
        @endif
    
        {{-- Source --}}
        @if($transaction->currency_id)
        <div class="flex justify-between items-center gap-4 px-6 pt-8">
            <div class="flex-1">
                <p class="font-semibold pb-2">Source</p>
                <div class="bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 flex gap-2 px-4 py-3 rounded-2xl">
                    <div class="bg-white box-shadow size-8 rounded-full flex justify-center items-center">
                        <img src="{{ asset('storage/' .$transaction->currency->logo) }}" />
                    </div>
                    <div>
                        <p class="text-sm font-semibold">{{ $transaction->from }}</p>
                       
                    </div>
                </div>
            </div>
        </div>
        @endif
    
        {{-- Actions --}}
        <div class="px-6 py-8">
            <div class="flex justify-between items-center gap-4">
                <a href="{{ route('transaction.receipt', $transaction->id) }}"
                   class="flex-1 py-3 bg-bgColor text-g300 font-medium text-center rounded-xl border border-bgColor2 dark:bg-darkN20 dark:border-darkN40">
                    Download Receipt
                </a>
                <a href="#"
                   class="flex-1 py-3 bg-g300 text-white text-center rounded-xl font-medium border border-g300">
                    View Receipt
                </a>
            </div>
        </div>
    
    </main>
    @endsection
    
    {{-- Scripts --}}
    @section('scripts')
    <script>
        $(document).ready(function(){
            $('.copy-btn').on('click', function() {
                let text = $(this).data('copy');
                if(text){
                    navigator.clipboard.writeText(text).then(function() {
                        toastr.success('Copied to clipboard!');
                    }, function() {
                        toastr.error('Failed to copy!');
                    });
                } else {
                    toastr.warning('Nothing to copy!');
                }
            });
        });
    </script>
    @endsection
    