
@extends('layouts.mulaauth')
@section('title', $title)
@section('content')

  <body class="">
    <main class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh">
      <div class="px-6 flex justify-between items-center">
        <a
           href="javascript:history.back()"
          class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl !leading-none text-white"
        >
          <i class="ph ph-caret-left"></i>
        </a>
        <div class="flex-1 flex justify-center items-center pr-12">
          <p class="text-2xl font-semibold">Security Settings</p>
        </div>
      </div>

      <div
      class="mt-8 p-6 border border-bgColor2 rounded-2xl mx-6 dark:border-darkN40"
    >
      <p
        class="border-b border-dashed border-n40 pb-6 font-semibold text-p1 dark:border-darkN40 text-g300"
      >
      Password
      </p>
      
      <a
      href="{{ route('passwordupdate') }}">
      <div class=" flex flex-col gap-4 pt-5">
     
        <div
          class="item flex cursor-pointer items-center justify-between border-b border-dashed border-n40 pb-5 dark:border-darkN40"
        >
          <p class="font-semibold dark:text-white">Update Password</p> 
         
          <i class="ph ph-caret-right text-xl text-n70 dark:text-white"></i>
        </div>
   
        
        
       
      </div> 
    </a>
    </div>



    <div class="mt-8 p-6 border border-bgColor2 rounded-2xl mx-6 dark:border-darkN40">
      <p class="border-b border-dashed border-n40 pb-6 font-semibold text-p1 dark:border-darkN40 text-g300">
          Manage 2FA
      </p>
      <div class="notificationsSettings flex flex-col gap-4 pt-5">
          
        <!-- Login OTP Toggle -->
<div class="item flex cursor-pointer items-center justify-between border-b border-dashed border-n40 pb-5 dark:border-darkN40 toggle-security"
data-type="otp" data-status="{{ Auth::user()->loginotp }}">
<p class="font-semibold dark:text-white">Login OTP</p>
<div class="checkBox relative h-6 w-11 rounded-full duration-500 
    {{ Auth::user()->loginotp == 'yes' ? 'bg-g300' : 'bg-n40 dark:bg-darkN40' }}">
   <div class="checkBoxCircle absolute top-0.5 size-[20px] rounded-full bg-white duration-500"
        style="{{ Auth::user()->loginotp == 'yes' ? 'transform: translateX(20px);' : 'transform: translateX(0);' }}">
   </div>
</div>
</div>


          
  
      </div> 
  </div>
  

      
    </main>
@endsection
@section('scripts')

<script>
  $(document).ready(function() {
      $('.toggle-security').on('click', function() {
          let $this = $(this);
          let type = $this.data('type');
          let currentStatus = $this.data('status');
          let newStatus = currentStatus === 'yes' ? 'no' : 'yes';

          // Animate Toggle
          let checkBox = $this.find('.checkBox');
          let circle = $this.find('.checkBoxCircle');
          if (newStatus === 'yes') {
              checkBox.removeClass('bg-n40').addClass('bg-g300');
              circle.css('transform', 'translateX(20px)');
          } else {
              checkBox.removeClass('bg-g300').addClass('bg-n40');
              circle.css('transform', 'translateX(0)');
          }

          // Send AJAX request
          $.ajax({
              url: "{{ route('toggle.security') }}",
              type: "POST",
              data: {
                  _token: "{{ csrf_token() }}",
                  type: type,
                  value: newStatus
              },
              success: function(response) {
                  if(response.success) {
                      toastr.success(response.message);
                      $this.data('status', newStatus);
                  } else {
                      toastr.error('Failed to update setting.');
                  }
              },
              error: function() {
                  toastr.error('An error occurred.');
              }
          });
      });

      // Initialize toggle positions based on status
      $('.toggle-security').each(function() {
          let status = $(this).data('status');
          let checkBox = $(this).find('.checkBox');
          let circle = $(this).find('.checkBoxCircle');
          if (status === 'yes') {
              checkBox.addClass('bg-g300').removeClass('bg-n40');
              circle.css('transform', 'translateX(20px)');
          }
      });
  });
</script>

@endsection