
@extends('layouts.mulaauth')
@section('title', $title)
@section('content')
   

@include('layouts.mulapart')
  <body class="">
    <!-- Splash Screen Start -->
<div class="preloader inset-0 z-50">
  <div
    class="h-full bg-bgColor flex flex-col justify-center items-center text-center container"
  >
    <div class="zoomInOut">
      <div class="">
        <img src="/muladash/assets/images/preloader.png" alt="" />
      </div>
      
    </div>
  </div>
</div>
<!-- Splash Screen End -->
    <main
      class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh pb-28"
    >
      <div class="flex justify-center items-center pb-8">
        <p class="text-2xl font-semibold">Profile</p>
      </div>
      <div
        class="flex justify-between items-center bg-g300 p-6 rounded-2xl text-white mx-6"
      >
        <div class="flex justify-start items-center gap-4">
          <img
            src="{{ asset('storage/'.$settings->favicon)}}"
            class="size-16 rounded-full"
            alt=""
          />
          <div class="">
            <h2 class="heading-2 font-semibold text-xl">{{ $userinfo->first_name }} {{ $userinfo->last_name }} </h2>
            <p class="pt-1">{{ '@' . $userinfo->username }}
            </p>
          </div>
        </div>
        
      </div>
      <div class="pt-8 flex flex-col gap-5">
      
        <a
          href="{{ route('personalprofile') }}"
          class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40 px-6"
        >
          <div class="flex justify-start items-center gap-4">
            <div
              class="text-xl size-11 rounded-full border border-bgColor2 flex justify-center items-center bg-bgColor text-g300 dark:bg-n0 dark:border-darkN40"
            >
              <i class="ph ph-user"></i>
            </div>
            <p class="font-semibold text-lg">Personal Info</p>
          </div>
          <div class="">
            <i class="ph ph-caret-right text-xl text-n70 dark:text-white"></i>
          </div>
        </a>

        <a
        href="{{ route('withdrawalinformation') }}"
        class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40 px-6"
      >
        <div class="flex justify-start items-center gap-4">
          <div
            class="text-xl size-11 rounded-full border border-bgColor2 flex justify-center items-center bg-bgColor text-g300 dark:bg-n0 dark:border-darkN40"
          >
            <i class="ph ph-user"></i>
          </div>
          <p class="font-semibold text-lg">Bank Account Info</p>
        </div>
        <div class="">
          <i class="ph ph-caret-right text-xl text-n70 dark:text-white"></i>
        </div>
      </a>

        <a
          href="{{ route('security') }}"
          class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40 px-6"
        >
          <div class="flex justify-start items-center gap-4">
            <div
              class="text-xl size-11 rounded-full border border-bgColor2 flex justify-center items-center bg-bgColor text-g300 dark:bg-n0 dark:border-darkN40"
            >
              <i class="ph ph-shield-check"></i>
            </div>
            <p class="font-semibold text-lg">Security</p>
          </div>
          <div class="">
            <i class="ph ph-caret-right text-xl text-n70 dark:text-white"></i>
          </div>
        </a>

        <a
        href="{{ route('aboutus') }}"
        class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40 px-6"
      >
        <div class="flex justify-start items-center gap-4">
          <div
            class="text-xl size-11 rounded-full border border-bgColor2 flex justify-center items-center bg-bgColor text-g300 dark:bg-n0 dark:border-darkN40"
          >
            <i class="ph ph-shield-check"></i>
          </div>
          <p class="font-semibold text-lg">About {{ $settings->site_name }}</p>
        </div>
        <div class="">
          <i class="ph ph-caret-right text-xl text-n70 dark:text-white"></i>
        </div>
      </a>

      <a
      href="{{ route('policy') }}"
      class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40 px-6"
    >
      <div class="flex justify-start items-center gap-4">
        <div
          class="text-xl size-11 rounded-full border border-bgColor2 flex justify-center items-center bg-bgColor text-g300 dark:bg-n0 dark:border-darkN40"
        >
          <i class="ph ph-shield-check"></i>
        </div>
        <p class="font-semibold text-lg">Privacy Policy</p>
      </div>
      <div class="">
        <i class="ph ph-caret-right text-xl text-n70 dark:text-white"></i>
      </div>
    </a>


        <div
          class="choose-mode flex cursor-pointer items-center justify-between pb-5 border-b border-dashed border-n40 dark:border-darkN40 px-6"
        >
          <div class="flex items-center justify-start gap-2">
            <div
              class="text-xl size-11 rounded-full border border-bgColor2 flex justify-center items-center bg-bgColor text-g300 dark:bg-n0 dark:border-darkN40"
            >
              <i class="ph ph-sun icon"></i>
            </div>
            <p class="font-semibold dark:text-white">Dark Mode</p>
          </div>
          <div
            class="relative h-6 w-11 rounded-full bg-n40 dark:bg-darkN40 duration-500"
          >
            <div
              class="absolute left-0.5 top-0.5 size-[20px] rounded-full bg-white duration-500 dark:left-[22px]"
            ></div>
          </div>
        </div>

      
        

       
        <div
          class="flex justify-between items-center pb-5 logoutModalOpenButton cursor-pointer px-6"
        >
          <div class="flex justify-start items-center gap-4 cursor-pointer">
            <div
              class="text-xl size-11 rounded-full border border-bgColor2 flex justify-center items-center bg-bgColor text-g300 dark:bg-n0 dark:border-darkN40"
            >
              <i class="ph ph-sign-out"></i>
            </div>
            <p class="font-semibold text-g300">Logout</p>
          </div>
        </div>
      </div>

      
    </main>

    <!-- Logout Modal Start -->
    <div class="logoutModal bottom-modal container fixed inset-0 z-50">
      <div
        class="modalBg absolute inset-0 w-full bg-black opacity-30 dark:bg-white"
      ></div>
      <div
        class="modal relative z-10 flex h-full flex-col items-end justify-end text-center dark:text-white"
      >
        <div class="absolute bottom-0 left-0 right-0">
          <img
            src="/muladash/assets/images/rounded-modal-white-bg.png"
            alt=""
            class="block dark:hidden"
          />
          <img
            src="/muladash/assets/images/rounded-modal-black-bg.png"
            alt=""
            class="hidden dark:block"
          />
        </div>
        <div class="relative w-full overflow-y-auto">
          <div class="px-6 pt-8">
            <div class="flex flex-col items-center justify-center gap-3 pb-4">
              <p
                class="w-full text-center text-2xl font-bold border-b border-n40 dark:border-darkN40 border-dashed pb-5 text-g300"
              >
                Logout
              </p>
              <p class="text-center text-n500 dark:text-darkN500">
                Do you want to logout?
              </p>
            </div>
          </div>

          <div class="px-6 py-8">
            <div class="flex justify-between items-center gap-4">
              <button
                class="flex-1 py-3 bg-bgColor text-g300 font-medium text-center rounded-xl border border-bgColor2 dark:bg-darkN20 dark:border-darkN40 logoutModalCloseButton"
              >
                Cancel
              </button>
              <a
              href="{{ route('logout') }}"
              onclick="event.preventDefault();
          document.getElementById('logout-form').submit();"
                class="flex-1 py-3 bg-g300 text-white text-center rounded-xl font-medium border border-g300"
              >
                Yes, Logout
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- Logout Modal End -->
    <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
        {{ csrf_field() }}
    </form>

   
@endsection
