@extends('layouts.muladash')
@section('title', $title)
@section('content')

<style>
    .invalid {
        color: red;
        margin: -2px;
        font-size: 10px;
    }
    .valid {
        color: green;
        margin: -2px;
        font-size: 10px;
    }
</style>

<main class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh">
    <x-danger-alert />
    <x-success-alert />

    <div class="px-6 flex justify-between items-center pb-8">
        <a href="javascript:history.back()"
           class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl !leading-none text-white">
            <i class="ph ph-caret-left"></i>
        </a>
        <div class="flex-1 flex justify-center items-center pr-12">
            <p class="text-2xl font-semibold">Update Password</p>
        </div>
    </div>

    <form id="passwordUpdateForm" action="{{ route('passwordupdate') }}" method="POST" class="flex flex-col gap-4 pt-8 px-6">
        @csrf
        <div class="flex flex-col justify-start">
            <p class="text-sm font-semibold pb-2 dark:text-white">Current Password</p>
            <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                <input type="password" name="current_password" id="current_password"
                       class="w-full bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white" required>
            </div>
        </div>
        <div class="flex flex-col justify-start">
            <p class="text-sm font-semibold pb-2 dark:text-white">New Password</p>
            <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl flex justify-between items-center">
                <input type="password" name="new_password" id="new_password"
                       class="flex-1 bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white" required>
                <i class="ph ph-eye-slash passwordShow cursor-pointer text-n90 text-lg !leading-none"></i>
            </div>
            <div id="password-rules" class="mb-3" style="margin: 10px 0px 0px 0px;">
                <p id="uppercase" class="invalid">At least one uppercase letter</p>
                <p id="number" class="invalid">At least one number</p>
                <p id="special" class="invalid">At least one special character</p>
                <p id="length" class="invalid">Minimum 8 characters</p>
            </div>
        </div>
        <div class="flex flex-col justify-start">
            <p class="text-sm font-semibold pb-2 dark:text-white">Confirm New Password</p>
            <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                <input type="password" name="new_password_confirmation" id="new_password_confirmation"
                       class="w-full bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white" required>
            </div>
        </div>
        <div class="my-3 flex">
            <button type="submit" id="saveButton" class="flex-1 py-3 bg-g300 text-white text-center rounded-xl">
                Save
            </button>
        </div>
    </form>
</main>

@endsection

@section('scripts')

<script>
    $(document).ready(function() {
        if (typeof $ === 'undefined') {
            console.error('jQuery is not loaded. Please ensure the jQuery CDN is accessible.');
            return;
        }
        console.log('jQuery is loaded successfully.');

        // Password visibility toggle
        $('.passwordShow').on('click', function() {
            var $passwordInput = $(this).siblings('#new_password');
            if ($passwordInput.attr('type') === 'password') {
                $passwordInput.attr('type', 'text');
                $(this).removeClass('ph-eye-slash').addClass('ph-eye');
            } else {
                $passwordInput.attr('type', 'password');
                $(this).removeClass('ph-eye').addClass('ph-eye-slash');
            }
            console.log('Password visibility has been toggled.');
        });

        // Password rules validation
        const passwordInput = document.getElementById('new_password');
        const uppercaseRule = document.getElementById('uppercase');
        const numberRule = document.getElementById('number');
        const specialRule = document.getElementById('special');
        const lengthRule = document.getElementById('length');
        const uppercasePattern = /[A-Z]/;
        const numberPattern = /[0-9]/;
        const specialPattern = /[!@#$%^&*(),.?":{}|<>[\]]/;
        const lengthPattern = /.{8,}/;

        function checkPassword() {
            const password = passwordInput.value;
            console.log('Checking password:', password);
            uppercaseRule.className = uppercasePattern.test(password) ? 'valid' : 'invalid';
            numberRule.className = numberPattern.test(password) ? 'valid' : 'invalid';
            specialRule.className = specialPattern.test(password) ? 'valid' : 'invalid';
            lengthRule.className = lengthPattern.test(password) ? 'valid' : 'invalid';
        }

        if (passwordInput) {
            passwordInput.addEventListener('input', checkPassword);
            console.log('Password input event has been bound successfully.');
        } else {
            console.error('Password input element was not found in the DOM.');
        }

        // AJAX password update submission with session refresh
        $('#passwordUpdateForm').on('submit', function(event) {
            event.preventDefault();
            console.log('Password update form submission has been intercepted.');

            var $button = $('#saveButton');
            $button.text('Saving...');
            $button.prop('disabled', true);

            $.ajax({
                url: $(this).attr('action'),
                method: 'POST',
                data: $(this).serialize(),
                dataType: 'json',
                success: function(response) {
                    console.log('Success Response:', response);
                    if (response.success) {
                        toastr.success(response.message, "Success", {
                            timeOut: 3000,
                            progressBar: true
                        });
                        // Refresh the session cookie by reloading the page
                        setTimeout(function() {
                            // Perform a full page reload to update the session cookie
                            location.reload();
                            // After reload, redirect to dashboard (handled by browser refresh)
                        }, 3000);
                    } else {
                        toastr.error(response.message, "Error", {
                            timeOut: 3000,
                            progressBar: true
                        });
                        $button.text('Save');
                        $button.prop('disabled', false);
                    }
                },
                error: function(xhr) {
                    console.log('Error Response:', xhr.responseJSON);
                    var message = xhr.responseJSON ? xhr.responseJSON.message : 'Something went wrong.';
                    toastr.error(message, "Error", {
                        timeOut: 3000,
                        progressBar: true
                    });
                    $button.text('Save');
                    $button.prop('disabled', false);
                }
            });
        });
    });
</script>
@endsection