@extends('layouts.muladash')
@section('title', $title)
@section('content')

@include('layouts.mulapart')

<x-danger-alert />
<x-success-alert />

<main class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh">
    <div class="px-6 flex justify-between items-center pb-8">
        <a href="javascript:history.back()" class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl text-white">
            <i class="ph ph-caret-left"></i>
        </a>
        <div class="flex-1 flex justify-center items-center pr-12">
            <p class="text-2xl font-semibold">Card History</p>
        </div>
    </div>

    <div class="pt-2 flex justify-start items-center gap-2 px-6">
        <div class="flex justify-between items-center flex-1 border border-n40 rounded-xl p-3 gap-2 dark:border-darkN40 dark:bg-darkN20">
            <i class="ph ph-magnifying-glass text-n70"></i>
            <input type="text" placeholder="Search here..." class="placeholder:text-n90 text-xs bg-transparent outline-none flex-1" />
            <i class="ph ph-microphone text-n70"></i>
        </div>
        <button class="p-3 bg-g300 rounded-md text-white text-2xl flex justify-center items-center">
            <i class="ph ph-sliders-horizontal"></i>
        </button>
    </div>

    <div class="px-6 pb-8 flex flex-col gap-5">
        <div class="flex flex-col gap-4 pt-4">
            @forelse ($transactions as $transaction)
                @php
                    $statusColors = [
                        'Pending'   => 'text-orange-500 bg-orange-200',
                        'Completed' => 'text-green-500 bg-green-200',
                        'Failed'    => 'text-red-500 bg-red-200',
                    ];
                    $statusClass = $statusColors[$transaction->status] ?? 'text-gray-500 bg-gray-200';
                @endphp

                <a href=""
                   class="flex justify-between items-center border-b border-dashed border-n40 dark:border-darkN40 pb-4">
                    <div class="flex justify-start items-center gap-4">
                        <div class="rounded-full bg-bgColor2 dark:bg-darkN40 flex justify-center items-center w-[60px] h-[60px]">
                            <i class="ph ph-credit-card text-2xl text-g300"></i>
                        </div>
                        <div>
                            <p class="font-semibold">{{ $transaction->title }}</p>
                            <p class="text-n500 dark:text-darkN500 text-xs pt-2.5">
                                {{ $transaction->description }}<br>
                                {{ \Carbon\Carbon::parse($transaction->created_at)->toDayDateTimeString() }}
                            </p>
                        </div>
                    </div>
                    <div class="flex flex-col justify-end items-end">
                        <p class="font-semibold pb-2">
                            {{ $settings->currency }}{{ number_format($transaction->amount, 2) }}
                        </p>
                      
                    </div>
                </a>
            @empty
                <p class="text-center text-n500 dark:text-darkN500 pt-6">No transactions found.</p>
            @endforelse
        </div>

        

    </div>
    <div class="pt-6">
      {{ $transactions->links() }}
  </div>
</main>

@endsection
