@php use Illuminate\Support\Str; @endphp

@extends('layouts.muladash')
@section('title', $title)
@section('content')



<x-danger-alert />
<x-success-alert />

<main class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh">
    <div class="px-6 flex justify-between items-center">
        <a href="javascript:history.back()" class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl text-white">
            <i class="ph ph-caret-left"></i>
        </a>
        <div class="flex-1 flex justify-center items-center pr-2">
            <p class="text-lg font-semibold">Buy Crypto</p>
        </div>
    </div>

    <form method="POST" action="{{ route('buy.crypto') }}" id="buy-crypto-form">
        @csrf

        <div class="px-6 pt-8 flex flex-col gap-4">
            {{-- Select Payment Source --}}
            <div class="flex flex-col justify-start">
                <p class="text-sm font-semibold pb-2 dark:text-white">Pay From</p>
                <div class="relative">
                    <div class="p-3 flex justify-between items-center gap-2 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl cursor-pointer selectCountry">
                        @php
                        $usdWallet = collect($userWalletsInUSD)->firstWhere('symbol', 'USD') ?? [
                            'name' => 'USD Wallet',
                            'symbol' => 'USD',
                            'logo' => 'default-usd-logo.png',
                            'balance_in_usd' => 0
                        ];
                     @endphp
                     
                     <div class="flex justify-start items-center gap-1">
                         <div class="size-7 flex justify-center items-center rounded-full bg-white dark:bg-darkG300">
                             <img
                               id="selected_wallet_logo"
                               src="{{ asset('storage/' . $usdWallet['logo']) }}"
                               alt="{{ $usdWallet['name'] }}"
                               class="w-[24px] h-[24px] object-cover"
                             />
                         </div>
                         <p class="text-n90 text-sm dark:text-white selectedItem">
                             {{ $usdWallet['name'] }} ({{ $usdWallet['symbol'] }})
                         </p>
                     </div>
                     
                        <i class="ph ph-caret-down text-n90 text-lg !leading-none"></i>
                    </div>

                    {{-- Dropdown for Wallets & Cards --}}
                    <div class="selectCountryModal bg-white p-4 rounded-xl border border-n40 dark:border-darkN40 dark:bg-darkG300 w-full absolute right-0 top-14 max-h-[150px] overflow-y-auto invisible opacity-0 scale-75 duration-500">
                        <ul class="flex flex-col gap-2">
                            @foreach($userWalletsInUSD as $wallet)
                                @if($wallet['symbol'] == 'USD')
                                    <li class="text-xs item cursor-pointer"
                                        data-source="wallet_{{ $wallet['symbol'] }}"
                                        data-name="{{ $wallet['name'] }} ({{ $wallet['symbol'] }})"
                                        data-logo="{{ asset('storage/' . $wallet['logo']) }}"
                                        data-balance-usd="{{ number_format($wallet['balance_in_usd'], 2) }}">
                                        {{ $wallet['name'] }} ({{ $wallet['symbol'] }})
                                    </li>
                                @endif
                            @endforeach

                            @foreach($cards as $card)
                                <li class="text-xs item cursor-pointer"
                                    data-source="card_{{ $card->id }}"
                                    data-name="{{ strtoupper(str_replace('_', ' ', $card->card_type)) }} ****{{ substr($card->cardnum, -4) }}"
                                    data-logo="{{ asset('storage/cards/cards.png') }}"
                                    data-balance-usd="{{ number_format($card->balance, 2) }}">
                                    {{ strtoupper(str_replace('_', ' ', $card->card_type)) }} ****{{ substr($card->cardnum, -4) }}
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>

            <input type="hidden" name="payment_source" id="payment_source" value="wallet_USD">

            {{-- Amount --}}
            <div class="flex flex-col justify-start">
                <p class="text-sm font-semibold pb-2 dark:text-white">Amount</p>
                <div class="p-4 bg-white border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                    <input type="number" name="amount" placeholder="0.00" class="w-full bg-transparent outline-none text-[32px] dark:text-white font-bold" required />
                </div>
            </div>

            {{-- Select Cryptocurrency --}}
            <div class="flex flex-col justify-start">
                <p class="text-sm font-semibold pb-2 dark:text-white">Cryptocurrency</p>
                <div class="relative">
                    <div class="p-3 flex justify-between items-center gap-2 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl cursor-pointer selectCountrys">
                        <div class="flex justify-start items-center gap-1">
                            <div class="size-7 flex justify-center items-center rounded-full bg-white dark:bg-darkG300">
                                <img id="selected_crypto_logo" src="{{ $cryptos[0]->logo }}" class="w-[24px] h-[24px] object-cover" />
                            </div>
                            <p class="text-n90 text-sm dark:text-white selectedCryptoItem">
                                {{ Str::title(str_replace('-', ' ', $cryptos[0]->crypto_name)) }}
                            </p>
                        </div>
                        <i class="ph ph-caret-down text-n90 text-lg !leading-none"></i>
                    </div>

                    <div class="selectCountrysModal bg-white p-4 rounded-xl border border-n40 dark:border-darkN40 dark:bg-darkG300 w-full absolute right-0 top-14 max-h-[200px] overflow-y-auto invisible opacity-0 scale-75 duration-500">
                        <ul class="flex flex-col gap-2">
                            @foreach($cryptos as $crypto)
                                <li class="text-xs item cursor-pointer"
                                    data-crypto="{{ $crypto->symbol }}"
                                    data-name="{{ Str::title(str_replace('-', ' ', $crypto->crypto_name)) }}"
                                    data-logo="{{ $crypto->logo }}">
                                    {{ Str::title(str_replace('-', ' ', $crypto->crypto_name)) }}
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>

            <input type="hidden" name="crypto" id="selected_crypto" value="{{ $cryptos[0]->symbol }}">

            {{-- Wallet Address --}}
            <div class="flex flex-col justify-start">
                <p class="text-sm font-semibold pb-2 dark:text-white">Wallet Address</p>
                <div class="p-4 bg-white border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                    <input type="text" name="wallet_address" class="w-full bg-transparent outline-none text-[24px] dark:text-white font-bold" required />
                </div>
            </div>

            {{-- Fee, Balance, Receive --}}
            <div class="flex justify-between items-center">
                <p class="text-n500 text-sm dark:text-darkN500 font-semibold">Fee (1.5%)</p>
                <p id="calculated_fee" class="text-n500 text-sm dark:text-darkN500">0.00 USD</p>
            </div>

            <div class="flex justify-between items-center">
                <p class="text-n500 text-sm dark:text-darkN500 font-semibold">Wallet Balance</p>
                <p id="wallet-balance-display" class="text-n500 text-sm dark:text-darkN500"> {{ number_format($usdWallet['balance_in_usd'], 2) }} USD</p>
            </div>

            <div class="flex justify-between items-center">
                <p class="text-n500 text-sm dark:text-darkN500 font-semibold">You Will Receive</p>
                <p id="they_will_receive" class="text-n500 text-sm dark:text-darkN500">0.00 USD</p>
            </div>
        </div>

        {{-- Submit --}}
        <div class="my-3 flex px-6 pt-8">
            <button type="submit" class="flex-1 py-3 bg-g300 text-white text-center rounded-xl">
                Complete Payment
            </button>
        </div>
    </form>
</main>

@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $('.selectCountry').on('click', function() {
        $('.selectCountryModal').toggleClass('invisible opacity-0 scale-75');
    });

    $('.selectCountrys').on('click', function() {
        $('.selectCountrysModal').toggleClass('invisible opacity-0 scale-75');
    });

    $('.selectCountryModal .item').on('click', function() {
        $('#payment_source').val($(this).data('source'));
        $('#selected_wallet_logo').attr('src', $(this).data('logo'));
        $('.selectCountry .selectedItem').text($(this).data('name'));
        $('#wallet-balance-display').text($(this).data('balance-usd') + ' USD');
        $('.selectCountryModal').addClass('invisible opacity-0 scale-75');
    });

    $('.selectCountrysModal .item').on('click', function() {
        $('#selected_crypto').val($(this).data('crypto'));
        $('#selected_crypto_logo').attr('src', $(this).data('logo'));
        $('.selectCountrys .selectedCryptoItem').text($(this).data('name'));
        $('.selectCountrysModal').addClass('invisible opacity-0 scale-75');
    });

    $('input[name="amount"]').on('input', function() {
        let amount = parseFloat($(this).val());
        if (!isNaN(amount)) {
            let fee = amount * 0.015;
            let net = amount - fee;
            $('#calculated_fee').text(fee.toFixed(2) + ' USD');
            $('#they_will_receive').text(net.toFixed(2) + ' USD');
        }
    });

    $('#buy-crypto-form').on('submit', function(e) {
        e.preventDefault();
        let btn = $(this).find('button[type=submit]');
        btn.prop('disabled', true).text('Processing...');
        $.post($(this).attr('action'), $(this).serialize(), function(response) {
            toastr.success(response.message);
            setTimeout(() => window.location.href = response.redirect, 1500);
        }).fail(function(xhr) {
            toastr.error(xhr.responseJSON.message || 'Transaction failed!');
            btn.prop('disabled', false).text('Complete Payment');
        });
    });
});
</script>
@endsection
