@extends('layouts.muladash')
@section('title', $title)
@section('content')
    <!-- Title -->
    
    @include('layouts.dasht')

 <div class="header fixed-top bg-surface d-flex justify-content-center align-items-center">
			<a href="javascript:void(0);" class="left back-btn"><i class="icon-left-btn"></i></a>
			<h3>Transaction Details</h3>
		</div>
        
        <x-danger-alert />
		<x-success-alert />

        
        <div class="pt-45 pb-90">
            <div class="tf-container">
               <p class="text-center text-small mt-4"> amount</p>
               <h1 class="mt-8 text-center"> {{ $settings->currency }}{{ number_format($transaction->amount, 2) }}</h1>
               <div class="mt-12 accent-box-v3 ">
                <div class="pb-10 line-bt">
                    @if($transaction instanceof \App\Models\Deposit)
                        <!-- If it's a deposit, show "From" -->
                        <span>From</span> 
                        <div class="mt-4 card-item">
                            <div class="content flex-grow-1">
                                <p class="text-large text-white">{{ $transaction->from }}</p>
                                <p class="text-large text-white">{{ $transaction->paydetails }}</p>
                            </div>
                        </div>
                    @elseif($transaction instanceof \App\Models\Withdrawal)
                        <!-- If it's a withdrawal, show "To" (or any other field you want for withdrawals) -->
                        <span>To</span>
                        <div class="mt-4 card-item">
                            <div class="content flex-grow-1">
                                <p class="text-large text-white">{{ $transaction->to }}</p>
                                <p class="text-large text-white">{{ $transaction->paydetails }}</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
            
               <ul class="mt-12 accent-box-v4 bg-menuDark">
                    <li class="d-flex align-items-center justify-content-between pb-8 line-bt">
                        <span class="text-small">Transaction fee</span>
                        <span class="text-large text-white">Free</span>
                    </li>
                    
               </ul>
            </div>
        </div>
    
       
    
@endsection
