<div class="bg-white p-4 rounded-xl border border-n40 dark:border-darkN40 dark:bg-darkG300 
            w-full absolute right-0 top-14 max-h-[200px] overflow-y-auto selectCountryModal 
            invisible opacity-0 scale-75 duration-500 z-[9999]">

    <ul class="flex flex-col gap-2">
        @php
        $countries = [
            // Top 10 European Countries
            'EUR' => 'Germany',
            'GBP' => 'United Kingdom',
            'EUR2' => 'France',
            'EUR3' => 'Italy',
            'EUR4' => 'Spain',
            'CHF' => 'Switzerland',
            'EUR5' => 'Netherlands',
            'SEK' => 'Sweden',
            'NOK' => 'Norway',
            'EUR6' => 'Belgium',

            // Top 5 North American Countries
            'USD' => 'United States',
            'CAD' => 'Canada',
            'MXN' => 'Mexico',
            'GTQ' => 'Guatemala',
            'CRC' => 'Costa Rica',

            // Top 5 South American Countries
            'BRL' => 'Brazil',
            'ARS' => 'Argentina',
            'COP' => 'Colombia',
            'CLP' => 'Chile',
            'PEN' => 'Peru',

            // Top 5 African Countries
            'NGN' => 'Nigeria',
            'ZAR' => 'South Africa',
            'EGP' => 'Egypt',
            'KES' => 'Kenya',
            'MAD' => 'Morocco',

            // Top 5 Asian Countries
            'JPY' => 'Japan',
            'CNY' => 'China',
            'INR' => 'India',
            'KRW' => 'South Korea',
            'IDR' => 'Indonesia',

            // Top 5 Oceania Countries
            'AUD' => 'Australia',
            'NZD' => 'New Zealand',
            'FJD' => 'Fiji',
            'PGK' => 'Papua New Guinea',
            'WST' => 'Samoa'
        ];
        @endphp

        @foreach($countries as $currencyCode => $countryName)
            <li data-type="{{ substr($currencyCode, 0, 3) }}"
                data-country="{{ $countryName }}"
                class="country-item text-xs text-n500 dark:text-darkN500 pb-2 border-b border-dashed border-n40 cursor-pointer capitalize">
                {{ $countryName }} ({{ substr($currencyCode, 0, 3) }})
            </li>
        @endforeach
    </ul>
</div>

