@extends('layouts.mulaauth')
@section('title', 'Login account')
@section('content')

<body class="">
	
	<div
	class="container px-6 pb-8 pt-12 h-dvh text-n900 dark:bg-n0 flex flex-col"
  >
	<div class="flex justify-center items-center text-center flex-col">
	  <h1 class="text-2xl font-medium dark:text-white">Forgot Password</h1>
	  <p class="tet-sm text-n500 dark:text-darkN500 pt-3 px-4">
		Stay connected, follow teams, and never miss thrilling Stay connected
	  </p>
	</div>

	<form class="flex flex-col gap-4 pt-8 relative flex-1" id="resetForm" method="post" action="{{ route('password.email')}}">
		@csrf
	  <div class="flex flex-col justify-start">
		<p class="text-sm font-semibold pb-2 dark:text-white">Email</p>
		<div
		  class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl"
		>
		  <input
			type="text"
			placeholder="Enter email" name="email"
			class="w-full bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white"
		  />
		</div>
	  </div>

      
      <div class="absolute bottom-0 left-0 right-0 flex">
        <button type="submit" id="dash" class="flex-1 py-3 bg-g300 text-white text-center rounded-xl">Send Request OTP</button>
      </div>
    </form>

    <div class="pt-4 text-center text-sm text-n500 dark:text-darkN500">
      Don’t have an account?
      <a href="{{ route('register') }}" class="text-g300 font-medium">Sign Up</a> here
    </div>
  </div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        if (typeof $ === 'undefined') {
            console.error('jQuery not loaded');
            return;
        }
        console.log('jQuery loaded');

        $('#resetForm').on('submit', function(e) {
            e.preventDefault();
            console.log('Reset form intercepted');

            var $button = $('#dash');
            $button.text('Sending...');
            $button.prop('disabled', true);

            $.ajax({
                url: $(this).attr('action'),
                method: 'POST',
                data: $(this).serialize(),
                dataType: 'json',
                success: function(response) {
                    console.log('Success Response:', response);
                    if (response.success) {
                        toastr.success(response.message, "Success", {
                            timeOut: 3000,
                            progressBar: true
                        });
                        // Key notice: Redirect after success
                        setTimeout(function() {
                            window.location.href = response.redirect || '{{ route('login') }}'; // Use redirect from JSON or fallback
                        }, 3000); // Match Toastr timeout—3s
                    } else {
                        toastr.error(response.message, "Error", {
                            timeOut: 3000,
                            progressBar: true
                        });
                        $button.text('Send Reset Link');
                        $button.prop('disabled', false);
                    }
                },
                error: function(xhr) {
                    console.log('Error Response:', xhr.responseJSON);
                    var message = xhr.responseJSON?.message || 'Something went wrong.';
                    toastr.error(message, "Error", {
                        timeOut: 3000,
                        progressBar: true
                    });
                    $button.text('Send Reset Link');
                    $button.prop('disabled', false);
                }
            });
        });
    });
</script>
@endsection
