@extends('layouts.mula-auth')
@section('title', 'Login account')
@section('content')
 
        <!--**********************************
            Content body start
        ***********************************-->
      

				
					@if (Session::has('status'))
				<div class="alert alert-light alert-dismissible alert-alt solid fade show">
					<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="btn-close">
						<span><i class="fa-solid fa-xmark"></i></span>
					</button>
					{{ session('status') }}
				</div>
				  @endif

				  @if ($errors->any())
				  @foreach ($errors->all() as $error)
				  <div class="alert alert-light alert-dismissible alert-alt solid fade show">
					<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="btn-close">
						<span><i class="fa-solid fa-xmark"></i></span>
					</button>
					{{ $error }}
				</div>
				@endforeach
			  @endif

			


	<div class="row">
		

		<div class="col-xl-12 col-lg-12">
			<div class="card">
				<div class="card-header">
					<h5 class="card-title">This is a secure area. Please confirm your password
                        before continuing.</h5>
				</div>
				<div class="card-body">
					<div class="basic-form">
						<form action="{{ route('password.confirm') }}" method="post" id="loginForm" class="">
							@csrf
							
									
								
									<label class="form-label">Password</label>
									<div class="mb-3 input-group">
									<span class="material-icons input-group-text">lock</span>
									<input type="password" id="passwordInput" class="form-control"  name="password" placeholder="Enter password">
									<a class="material-icons input-group-text" onclick="togglePassword()">remove_red_eye</a>
									</div>
								<div class="form-check">
									<input class="form-check-input" type="checkbox" >
									<label class="form-check-label">
										Remember me
									</label>
								</div>

								<button type="submit" id="dash" onclick="showLoading()" class="btn btn-primary mt-3">Confirm</button>
							
						</form>
						
					</div>
				</div>
			</div>
		</div>

			</div>
		</div>
	</div>

	<script>
        function togglePassword() {
            var passwordField = document.getElementById("passwordInput");
            if (passwordField.type === "password") {
                passwordField.type = "text"; // Show password
            } else {
                passwordField.type = "password"; // Hide password
            }
        }
    </script>

<script>
	function showLoading() {
		var button = document.getElementById('dash');
		button.innerHTML = 'Loading...';
		button.disabled = true;
		document.getElementById('loginForm').submit();
	}
	</script>
@endsection
