<?php

namespace App\Providers;

use League\Flysystem\Filesystem;
use League\Flysystem\Sftp\SftpAdapter;
use Illuminate\Support\Facades\View;
use App\Models\Settings;
use App\Models\SettingsCont;
use App\Models\TermsPrivacy;
use App\Models\CryptoPrice; // Import CryptoPrice model
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Storage as FacadesStorage;
use Illuminate\Support\ServiceProvider;
use App\Models\UserWallet;
use Illuminate\Notifications\ChannelManager;
use App\Channels\TermiiChannel;



class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {


        // Extend the SFTP driver
        FacadesStorage::extend('sftp', function ($app, $config) {
            return new Filesystem(new SftpAdapter($config));
        });

        resolve(ChannelManager::class)->extend('termii', function ($app) {
            return new TermiiChannel();
        });
        // Use Bootstrap pagination
        Paginator::useBootstrap();

        // Sharing settings with all views
        $settings = Settings::find(1);
        $terms = TermsPrivacy::find(1);

        // Share general settings data with all views
        View::share('settings', $settings);
        View::share('terms', $terms);
        View::share('mod', $settings ? $settings->modules : []);

        // Fetch and share the top 20 cryptocurrencies
        $bitcoin = CryptoPrice::where('crypto_name', 'bitcoin')->first();
        $ethereum = CryptoPrice::where('crypto_name', 'ethereum')->first();
        $litecoin = CryptoPrice::where('crypto_name', 'litecoin')->first();
        $dogecoin = CryptoPrice::where('crypto_name', 'dogecoin')->first();
        $solana = CryptoPrice::where('crypto_name', 'solana')->first();
        $ripple = CryptoPrice::where('crypto_name', 'ripple')->first();
        $polkadot = CryptoPrice::where('crypto_name', 'polkadot')->first();
        $binancecoin = CryptoPrice::where('crypto_name', 'binancecoin')->first();
        $cardano = CryptoPrice::where('crypto_name', 'cardano')->first();
        $chainlink = CryptoPrice::where('crypto_name', 'chainlink')->first();
        $avalanche = CryptoPrice::where('crypto_name', 'avalanche')->first();
        $shiba_inu = CryptoPrice::where('crypto_name', 'shiba-inu')->first();
        $terra = CryptoPrice::where('crypto_name', 'terra')->first();
        $uniswap = CryptoPrice::where('crypto_name', 'uniswap')->first();
        $tron = CryptoPrice::where('crypto_name', 'tron')->first();
        $vechain = CryptoPrice::where('crypto_name', 'vechain')->first();
        $stellar = CryptoPrice::where('crypto_name', 'stellar')->first();
        $monero = CryptoPrice::where('crypto_name', 'monero')->first();
        $cosmos = CryptoPrice::where('crypto_name', 'cosmos')->first();
        $algorand = CryptoPrice::where('crypto_name', 'algorand')->first();

        // Share these individual variables with all views
        View::share('bitcoin', $bitcoin);
        View::share('ethereum', $ethereum);
        View::share('litecoin', $litecoin);
        View::share('dogecoin', $dogecoin);
        View::share('solana', $solana);
        View::share('ripple', $ripple);
        View::share('polkadot', $polkadot);
        View::share('binancecoin', $binancecoin);
        View::share('cardano', $cardano);
        View::share('chainlink', $chainlink);
        View::share('avalanche', $avalanche);
        View::share('shiba_inu', $shiba_inu);
        View::share('terra', $terra);
        View::share('uniswap', $uniswap);
        View::share('tron', $tron);
        View::share('vechain', $vechain);
        View::share('stellar', $stellar);
        View::share('monero', $monero);
        View::share('cosmos', $cosmos);
        View::share('algorand', $algorand);
    }
}
