<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Withdrawal extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_wallet_id',
        'user_id',
        'amount',
        'from_address',
        'hash',
        'payment_mode',
        'status',
        'time',
        'created_at',
        'updated_at',
    ];
    
    public function duser(){
    	return $this->belongsTo(User::class , 'user');
    }
    public function userWallet()
    {
        return $this->belongsTo(UserWallet::class, 'user_wallet_id');
    }
       
    public function wallet()
    {
        return $this->userWallet();
    }
}
