<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'type',
        'from',
        'to',
        'currency_id',
        'amount',
        'crypto_address',
        'bank_account_number',
        'bank_name',
        'bank_account_name',
        'ref',
        'hash',
        'symbol',
        'payment_mode',
        'status',
        'transaction_time',
    ];

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'transactions'; // Key: Matches your SQL table name

    /**
     * Indicates if the model's ID is auto-incrementing.
     *
     * @var bool
     */
    public $incrementing = true;

    /**
     * The primary key associated with the table.
     *
     * @var string
     */
    protected $primaryKey = 'id';
    public function userWallet()
    {
        return $this->belongsTo(UserWallet::class, 'user_wallet_id');
    }
    public function duser(){
    	return $this->belongsTo(User::class, 'user_wallet_id');
    }
    
    public function wallet()
    {
        return $this->userWallet();
    }
    public function currency()
{
    return $this->belongsTo(Currency::class);
}
public function user()
{
    return $this->belongsTo(User::class, 'user_id');
}

}
