<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Kyc extends Model
{
    use HasFactory;

    // Mass assignable fields
    protected $fillable = [
        'user_id',
        'first_name',
        'last_name',
        'email',
        'phone_number',
        'dob',
        'country',
        'document_type',
        'frontimg',
        'backimg',
        'status',
    ];

    // Relationship: Each KYC belongs to a user
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
