<?php

namespace App\Mail;

use App\Models\Settings;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class LoginEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $ipAddress;
    public $device;
    public $browser;
    public $os;
    public $loginTime; // Add this property for login time

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $user, $ipAddress, $device, $browser, $os, $loginTime)
    {
        $this->user = $user;
        $this->ipAddress = $ipAddress;
        $this->device = $device;
        $this->browser = $browser;
        $this->os = $os;
        $this->loginTime = $loginTime;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $settings = Settings::find(1);

        return $this->subject("{$settings->site_name} - Login Notification")
        ->markdown('emails.login', [
            'user' => $this->user,
            'settings' => $settings,
            'ipAddress' => $this->ipAddress,
            'device' => $this->device,
            'browser' => $this->browser,
            'os' => $this->os,
            'loginTime' => $this->loginTime,
        ]);

    }
}
