<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class KycApplicationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'first_name' => 'max:255',
            'last_name' => '',
            'email' => 'unique:kycs,email',
            'phone_number' => '',
            'dob' => '',
            'address' => '',
            'city' => '',
            'state' => '',
            'country' => '',
            'document_type' => '',
            'frontimg' => '',
            'backimg' => '',
        ];
    }
}