<?php

namespace App\Http\Livewire\Admin\Withdrawal;

use App\Models\Withdrawal;
use Livewire\Component;
use Livewire\WithPagination;

namespace App\Http\Livewire\Admin\Withdrawal;

use App\Models\Transaction;
use Livewire\Component;
use Livewire\WithPagination;

class ManageWithdrawal extends Component
{
    use WithPagination;

    protected $paginationTheme = 'bootstrap';
    public $search = '';
    public $order = 'desc';
    public $status = 'All';
    public $perPage = 10;
    public $toDate = '';
    public $fromDate = '';
    public $deleteId = '';

    public function render()
    {
        $query = Transaction::where('type', 'LIKE', '%Withdrawal%')
                    ->with('duser:id,name')
                    ->orderBy('id', $this->order);

        if ($this->status != 'All') {
            $query->where('status', $this->status);
        }

        if (!empty($this->search)) {
            $query->where(function($q) {
                $q->where('payment_mode', 'LIKE', '%' . $this->search . '%')
                  ->orWhere('amount', 'LIKE', '%' . $this->search . '%')
                  ->orWhere('status', 'LIKE', '%' . $this->search . '%')
                  ->orWhere('ref', 'LIKE', '%' . $this->search . '%');
            });
        }

        if ($this->fromDate && $this->toDate) {
            $query->whereBetween('created_at', [$this->fromDate, $this->toDate]);
        }

        return view('livewire.admin.withdrawal.manage-withdrawal', [
            'withdrawals' => $query->paginate($this->perPage),
        ]);
    }

    public function resetFilter()
    {
        $this->reset(['search', 'order', 'status', 'perPage', 'toDate', 'fromDate']);
    }

    public function deleteId($id)
    {
        $this->deleteId = $id;
    }

    public function delete()
    {
        $withdrawal = Transaction::where('type', 'LIKE', '%Withdrawal%')->findOrFail($this->deleteId);
        try {
            $withdrawal->delete();
            session()->flash('success', 'Withdrawal deleted successfully!');
        } catch (\Throwable $th) {
            session()->flash('error', 'Something went wrong! Withdrawal record does not exist.');
        }
    }
}
