<?php

namespace App\Http\Livewire\Admin;


use App\Models\CardTransaction;
use App\Models\CryptoPrice;
use App\Models\Currency;
use App\Models\Settings;
use App\Models\Transaction;
use App\Models\User;
use App\Models\Card;
use App\Models\Contact;
use App\Models\UserWallet;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Livewire\WithPagination;
use Livewire\Component;

class ManageUsers extends Component
{
    use WithPagination;

    protected $paginationTheme = 'bootstrap';
    public $pagenum = 10;
    public $searchvalue = '';
    public $orderby = 'id';
    public $orderdirection = 'desc';
    public $selectPage = false;
    public $selectAll = false;
    public $checkrecord = [];
    public $selected = '';
    public $action = 'Delete';
    public $username;
    public $fullname;
    public $email;
    public $password;
    public $message;
    public $subject;
    public $datecreated;
    public $topamount;
    public $toptype;
    public $topcolumn = "Bonus";
    public $userTypes = "All";

    protected $rules = [
        'fullname' => 'required|max:255',
        'username' => 'required|unique:users,username',
        'email' => 'required|email|max:255|unique:users',
        'password' => 'required|min:8',
    ];


    public function getUsersProperty()
    {

        return User::search($this->searchvalue)
            ->orderBy($this->orderby, $this->orderdirection)
            ->paginate($this->pagenum);
    }

    public function render()
    {
        if ($this->selectAll) {
            $this->checkrecord = $this->users->pluck('id')->map(fn ($id) => (string) $id);
        }
        return view('livewire.admin.manage-users', [
            'users' => $this->users,
        ]);
    }

    public function updatedCheckrecord()
    {
        $this->selectAll = false;
        $this->selectPage = false;
    }

    public function updatedSelectPage($value)
    {
        if ($value) {
            $this->checkrecord = $this->users->pluck('id')->map(fn ($id) => (string) $id);
        } else {
            $this->checkrecord = [];
        }
    }

    public function selectAll()
    {
        $this->selectAll = true;
    }


    public function saveUser()
    {

        $this->validate();

        $thisid = DB::table('users')->insertGetId([
            'name' => $this->fullname,
            'email' => $this->email,
            'ref_by' => NULL,
            'username' => $this->username,
            'password' => Hash::make($this->password),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);

        //assign referal link to user
        $settings = Settings::where('id', '=', '1')->first();
        $user = User::where('id', $thisid)->first();

        User::where('id', $thisid)
            ->update([
                'ref_link' => $settings->site_address . '/ref/' . $user->username,
                'email_verified_at' => Carbon::now(),
            ]);

        session()->flash('success', 'User created Sucessfully!');
        return redirect()->route('manageusers');
    }

   

    public function topup()
    {
        $users = User::whereIn('id', $this->checkrecord)->get();
    
        foreach ($users as $user) {
            if (in_array($this->topcolumn, ['visa_card', 'master_card', 'gold_card'])) {
                // Handle Card Top-up
                $card = Card::where('user_id', $user->id)
                                         ->where('card_type', $this->topcolumn)
                                         ->first();
    
                if (!$card) continue;  // Skip if card doesn't exist
    
                if ($this->toptype == "Credit") {
                    $card->balance += $this->topamount;
                } else {
                    $card->balance = max(0, $card->balance - $this->topamount);  // Prevent negative balance
                }
                $card->save();
    
            } else {
                // Handle Crypto Wallet Top-up
                $currency = Currency::where('symbol', $this->topcolumn)->first();
                if (!$currency) continue;
    
                $wallet = UserWallet::where('user_id', $user->id)
                                                 ->where('currency_id', $currency->id)
                                                 ->first();
    
                if (!$wallet) continue;
    
                // Fetch crypto price
                $cryptoPrice = CryptoPrice::where('symbol', $currency->symbol)->value('price');
    
                if (!$cryptoPrice || $cryptoPrice == 0) continue;
    
                // Convert USD to Crypto Amount
                $cryptoAmount = $this->topamount / $cryptoPrice;
    
                if ($this->toptype == "Credit") {
                    $wallet->balance += $cryptoAmount;
                } else {
                    $wallet->balance = max(0, $wallet->balance - $cryptoAmount);  // Prevent negative balance
                }
                $wallet->save();
            }
    
            // Log Transaction for both Card and Wallet top-up
            Transaction::create([
                'user_id'     => $user->id,
                'type'        => $this->toptype == "Credit" ? 'Admin Top-up' : 'Admin Debit',
                'from'        => 'Admin',
                'to'          => $this->topcolumn,
                'currency_id' => isset($currency) ? $currency->id : null,
                'amount'      => $this->topamount,
                'symbol'      => $this->topcolumn,
                'payment_mode'=> $this->topcolumn,
                'status'      => 'completed',
                'ref'         => '#TOP-' . strtoupper(\Illuminate\Support\Str::random(10)),
                'transaction_time' => now(),
            ]);
        }
    
        session()->flash('success', 'Top-up action completed successfully!');
        return redirect()->route('manageusers');
    }
    
    //Delete user
    public function delsystemuser()
{
    $users = User::whereIn('id', $this->checkrecord)->get();

    foreach ($users as $user) {
        if ($this->action == 'Delete') {
            // Delete related records
            UserWallet::where('user_id', $user->id)->delete();
            Transaction::where('user_id', $user->id)->delete();
            Contact::where('user_id', $user->id)->delete();
            CardTransaction::where('user_id', $user->id)->delete();
            Card::where('user_id', $user->id)->delete();
            DB::table('activities')->where('user', $user->id)->delete();

            // Delete user
            $user->delete();
        }

        if ($this->action == 'Clear') {
            // Reset Wallets
            UserWallet::where('user_id', $user->id)->update(['balance' => 0]);

            // Delete related records
            Transaction::where('user_id', $user->id)->delete();
            Contact::where('user_id', $user->id)->delete();
            CardTransaction::where('user_id', $user->id)->delete();
            Card::where('user_id', $user->id)->delete();
            DB::table('activities')->where('user', $user->id)->delete();
        }
    }

    session()->flash('success', 'Action successful!');
    return redirect()->route('manageusers');
}

}
