<?php
namespace App\Http\Livewire\Admin\Deposit;

use App\Models\Transaction;
use Illuminate\Support\Facades\Storage;
use Livewire\Component;
use Livewire\WithPagination;

class ManageDeposit extends Component
{
    use WithPagination;

    protected $paginationTheme = 'bootstrap';
    public $search = '';
    public $order = 'desc';
    public $status = 'All';
    public $perPage = 10;
    public $toDate = '';
    public $fromDate = '';
    public $deleteId = '';

    protected $queryString = [
        'search' => ['except' => ''],
    ];

    public function render()
    {
        $query = Transaction::where('type', 'LIKE', '%Deposit%')
                    ->with('duser:id,name')
                    ->orderBy('id', $this->order);

        if ($this->status != 'All') {
            $query->where('status', $this->status);
        }

        if (!empty($this->search)) {
            $query->where(function($q) {
                $q->where('payment_mode', 'LIKE', '%' . $this->search . '%')
                  ->orWhere('amount', 'LIKE', '%' . $this->search . '%')
                  ->orWhere('status', 'LIKE', '%' . $this->search . '%')
                  ->orWhere('ref', 'LIKE', '%' . $this->search . '%');
            });
        }

        if ($this->fromDate && $this->toDate) {
            $query->whereBetween('created_at', [$this->fromDate, $this->toDate]);
        }

        return view('livewire.admin.deposit.manage-deposit', [
            'deposits' => $query->paginate($this->perPage),
        ]);
    }

    public function resetFilter()
    {
        $this->reset(['search', 'order', 'status', 'perPage', 'toDate', 'fromDate']);
    }

    public function deleteId($id)
    {
        $this->deleteId = $id;
    }

    public function delete()
    {
        $transaction = Transaction::where('type', 'LIKE', '%Deposit%')->findOrFail($this->deleteId);
        try {
            if (!empty($transaction->proof) && Storage::disk('public')->exists($transaction->proof)) {
                Storage::disk('public')->delete($transaction->proof);
            }
            $transaction->delete();
            session()->flash('success', 'Deposit transaction deleted successfully!');
        } catch (\Throwable $th) {
            session()->flash('error', 'Something went wrong! Transaction does not exist.');
        }
    }
}
