<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;

class ProfileController extends Controller
{
    public function updateprofile(Request $request)
    {
        try {
            if ($request->hasFile('profile_pic')) {
                $file = $request->file('profile_pic');
                $filename = time() . '_' . $file->getClientOriginalName();
                $file->move(public_path('uploads/profile_pics'), $filename);
                $profilePicPath = 'uploads/profile_pics/' . $filename;
            } else {
                $profilePicPath = Auth::user()->profile_pic;
            }

            User::where('id', Auth::user()->id)
                ->update([
                    'profile_pic' => $profilePicPath
                ]);

            return response()->json(['status' => 200, 'success' => 'Profile Information Updated Successfully!']);
        } catch (\Exception $e) {
            Log::error('Update Profile Error: ' . $e->getMessage());
            return response()->json(['status' => 500, 'error' => 'Failed to update profile.']);
        }
    }

    public function updatepics(Request $request)
    {
        try {
            $request->validate([
                'profile_pic' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            ]);

            if ($request->hasFile('profile_pic')) {
                if (Auth::user()->profile_pic && Storage::disk('public')->exists(Auth::user()->profile_pic)) {
                    Storage::disk('public')->delete(Auth::user()->profile_pic);
                }

                $file = $request->file('profile_pic');
                $filename = time() . '_' . $file->getClientOriginalName();
                $filePath = $file->storeAs('users', $filename, 'public');

                User::where('id', Auth::user()->id)->update([
                    'profile_pic' => $filePath,
                ]);

                return response()->json(['status' => 200, 'success' => 'Profile picture updated successfully!']);
            }

            return response()->json(['status' => 400, 'error' => 'No file selected.']);
        } catch (\Exception $e) {
            Log::error('Update Profile Picture Error: ' . $e->getMessage());
            return response()->json(['status' => 500, 'error' => 'Failed to update profile picture.']);
        }
    }

    public function updatepass(Request $request)
    {
        try {
            $request->validate([
                'current_password' => 'required',
                'password' => 'required|string|min:6|confirmed',
                'password_confirmation' => 'required',
            ]);

            $user = User::find(Auth::user()->id);

            if (!Hash::check($request->current_password, $user->password)) {
                return response()->json(['status' => 400, 'error' => 'Current password does not match!']);
            }

            $user->password = Hash::make($request->password);
            $user->save();

            return response()->json(['status' => 200, 'success' => 'Password updated successfully!']);
        } catch (\Exception $e) {
            Log::error('Update Password Error: ' . $e->getMessage());
            return response()->json(['status' => 500, 'error' => 'Failed to update password.']);
        }
    }

    public function updateemail(Request $request)
    {
        try {
            $user = User::find(Auth::user()->id);

            $user->sendotpemail = $request->otpsend;
            $user->sendroiemail = $request->roiemail;
            $user->sendinvplanemail = $request->invplanemail;
            $user->save();

            return response()->json(['status' => 200, 'success' => 'Email Preference updated']);
        } catch (\Exception $e) {
            Log::error('Update Email Preference Error: ' . $e->getMessage());
            return response()->json(['status' => 500, 'error' => 'Failed to update email preferences.']);
        }
    }
}
