<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;

class CurrencyController extends Controller
{
    public function fetchAndStoreFreaksRates()
    {
        // 1. Fetch from CurrencyFreaks
        $response = Http::get('https://api.currencyfreaks.com/latest', [
            'apikey' => env('CURRENCY_FREAKS_API_KEY'),
        ]);

        // 2. Check for success
        if (! $response->successful()) {
            Log::error('CurrencyFreaks API error', ['body' => $response->body()]);
            return;
        }

        $payload = $response->json();
        $rates   = $payload['rates'] ?? [];
        $base    = $payload['base'] ?? 'USD';
        $fetched = now();
        $source  = 'currencyfreaks.com';

        // 3. Upsert each rate
        foreach ($rates as $target => $value) {
            DB::table('rates')->updateOrInsert(
                [
                    'base_currency'   => $base,
                    'target_currency' => $target,
                ],
                [
                    'rate'         => (float) $value,
                    'source'       => $source,
                    'retrieved_at' => $fetched,
                    'updated_at'   => $fetched,
                ]
            );
        }

        Log::info('CurrencyFreaks rates updated.', ['count' => count($rates)]);
    }
}
