<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Transaction;
use App\Models\UserWallet;
use App\Models\CryptoPrice;
use App\Mail\NewNotification;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;

class ManageWithdrawalController extends Controller
{
    public function pwithdrawal(Request $request)
    {
        $withdrawal = Transaction::where('id', $request->id)
        ->whereIn('type', ['Crypto Withdrawal', 'Send to Contact', 'Buy Crypto', 'Bills Payment', 'Bank Withdrawal']) ->firstOrFail();
    
        $user = User::findOrFail($withdrawal->user_id);
    
        if ($request->action == "Paid") {
            $withdrawal->update(['status' => 'Completed']);
    
            $message = match($withdrawal->type) {
                'Buy Crypto'     => "Your crypto purchase of {$withdrawal->amount} {$withdrawal->symbol} has been successfully processed.",
                'Bills Payment'  => "Your bill payment of {$withdrawal->amount} {$withdrawal->symbol} has been completed.",
                'Send to Contact'=> "You have successfully sent {$withdrawal->amount} {$withdrawal->symbol} to {$withdrawal->to}.",
                default          => "Your withdrawal of {$withdrawal->amount} {$withdrawal->symbol} to {$withdrawal->to} has been processed.",
            };
    
            Mail::to($user->email)->send(new NewNotification($message, 'Transaction Completed', $user->first_name));
    
        } elseif ($request->action == "Reject") {
            $wallet = UserWallet::where('user_id', $user->id)
                ->where('currency_id', $withdrawal->currency_id)
                ->first();
    
            $cryptoPrice = CryptoPrice::where('symbol', $withdrawal->symbol)->value('price');
            if (!$cryptoPrice || $cryptoPrice <= 0) {
                return redirect()->back()->with('error', 'Invalid crypto price.');
            }
    
            $refundAmount = $withdrawal->amount / $cryptoPrice;
    
            $wallet->update([
                'balance' => DB::raw("balance + {$refundAmount}")
            ]);
    
            $withdrawal->update(['status' => 'Rejected']);
    
            if ($request->emailsend == "true") {
                Mail::to($user->email)->send(new NewNotification(
                    $request->reason,
                    $request->subject,
                    $user->first_name
                ));
            }
        }
    
        return redirect()->route('mwithdrawals')->with('success', 'Transaction processed successfully.');
    }
    

public function processwithdraw($id)
{
    $withdrawal = Transaction::where('id', $id)
    ->whereIn('type', ['Crypto Withdrawal', 'Send to Contact', 'Buy Crypto', 'Bills Payment', 'Bank Withdrawal']) ->firstOrFail();

    $user = User::findOrFail($withdrawal->user_id);

    return view('admin.Withdrawals.pwithrdawal', [
        'withdrawal' => $withdrawal,
        'user'       => $user,
        'title'      => 'Process Withdrawal Request',
    ]);
}

}
