<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;

use App\Models\Settings;
use App\Models\Card;
use App\Models\Agent;
use App\Models\CryptoPrice;

use App\Models\UserWallet;
use App\Models\Currency;
use App\Models\Deposit;
use App\Models\Withdrawal;
use App\Models\Tp_Transaction;
use App\Models\Activity;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use App\Mail\NewNotification;
use App\Models\Kyc;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Mail;
use Carbon\Carbon;
class ManageUsersController extends Controller
{

    // See user wallet balances
    public function loginactivity($id)
    {

        $user = User::where('id', $id)->first();

        return view('admin.Users.loginactivity', [
            'activities' => Activity::where('user', $id)->orderByDesc('id')->get(),
            'title' => "$user->name login activities",
            'user' => $user,
        ]);
    }

    public function showUsers($id)
    {
        $user = User::where('id', $id)->first();
        $ref = User::whereNull('ref_by')->where('id', '!=', $id)->get();
      

        return view('admin.Users.referral', [
            'title' => "Add users to $user->name referral list",
            'user' => $user,
            'ref' => $ref,
            
        ]);
    }

    public function fetchUsers()
    {
        $users = User::orderByDesc('id')->get();
        return response()->json([
            'message' => 'Success',
            'data' => $users,
            'code' => 200
        ]);
    }


    public function addReferral(Request $request)
    {
        $user = User::where('id', $request->user_id)->first();
        $ref = User::where('id', $request->ref_id)->first();

        $ref->ref_by = $user->id;
        $ref->save();
        return redirect()->back()
            ->with('success', "$ref->name is now referred by $user->name successfully");
    }

    public function clearactivity($id)
    {
        $activities = Activity::where('user', $id)->get();

        if (count($activities) > 0) {
            foreach ($activities as $act) {
                Activity::where('id', $act->id)->delete();
            }
            return redirect()->back()
                ->with('success', 'Activity Cleared Successfully!');
        }
        return redirect()->back()
            ->with('message', 'No Activity to clear!');
    }

   

    public function viewuser(Request $request, $id)
{
    // Fetch the user
    $user = User::where('id', $id)->first();
    
    // Check if a currency symbol is provided, otherwise set a default
    $currency_symbol = $request->currency_symbol ?? 'BTC';  // Default to BTC if none is provided
    $user_cards = Card::where('user_id', $user->id)->get();
    // Fetch all user wallets and their associated currencies
    $userWallets = UserWallet::where('user_id', $user->id)
        ->with('currency')
        ->get();

    // Fetch the latest crypto prices
    $cryptoPrices = CryptoPrice::all()->pluck('price', 'symbol');

    // Initialize total balance in USD
    $totalBalanceInUSD = 0;

    // Prepare an array to store individual currency balances
    $currencyBalances = [];

    // Loop through each wallet and calculate balances
    foreach ($userWallets as $wallet) {
        $symbol = $wallet->currency->symbol;
        $priceInUSD = $cryptoPrices[$symbol] ?? 0;

        // Calculate balance in USD
        $balanceInUSD = $wallet->balance * $priceInUSD;
        $totalBalanceInUSD += $balanceInUSD;

        // Store each currency balance in the array
        $currencyBalances[] = [
            'currency' => $wallet->currency->name,
            'symbol' => $symbol,
            'balance' => $wallet->balance,
            'balance_in_usd' => $balanceInUSD,
        ];
    }

    // Fetch all currencies (make sure you keep this for $currencies)
    $currencies = Currency::all();

    return view('admin.Users.userdetails', [
        'user' => $user,
        'currencies' => $currencies, // Pass the currencies back to the view
        'totalBalanceInUSD' => $totalBalanceInUSD, // Total wallet balance in USD
        'currencyBalances' => $currencyBalances, // Individual currency balances
        'title' => "Manage $user->name",
        'user_cards' => $user_cards,
    ]);
}

    
    //block user
    public function ublock($id)
    {
        User::where('id', $id)->update([
            'status' => 'blocked',
        ]);
        return redirect()->back()->with('success', 'Action Sucessful!');
    }

    //unblock user
    public function unblock($id)
    {
        User::where('id', $id)->update([
            'status' => 'active',
        ]);
        return redirect()->back()->with('success', 'Action Sucessful!');
    }

    


    

    //Manually Verify users email
    public function emailverify($id)
    {
        User::where('id', $id)->update([
            'email_verified_at' => \Carbon\Carbon::now(),
        ]);
        return redirect()->back()->with('success', 'User Email have been verified');
    }

    //Reset Password
    public function resetpswd($id)
    {
        User::where('id', $id)
            ->update([
                'password' => Hash::make('user01236'),
            ]);
        return redirect()->back()->with('success', 'Password has been reset to default');
    }

    //Clear user Account
    public function clearacct(Request $request, $id)
    {
        $settings = Settings::where('id', 1)->first();

        $deposits = Deposit::where('user', $id)->get();
        if (!empty($deposits)) {
            foreach ($deposits as $deposit) {
                Deposit::where('id', $deposit->id)->delete();
            }
        }

        $withdrawals = Withdrawal::where('user', $id)->get();
        if (!empty($withdrawals)) {
            foreach ($withdrawals as $withdrawals) {
                Withdrawal::where('id', $withdrawals->id)->delete();
            }
        }

        User::where('id', $id)->update([
            'account_bal' => '0',
            'roi' => '0',
            'bonus' => '0',
            'ref_bonus' => '0',
        ]);
        return redirect()->back()->with('success', "Account cleared to $settings->currency 0.00");
    }

    //Access users account
    public function switchuser($id)
    {
        $user = User::where('id', $id)->first();
        Auth::loginUsingId($user->id, true);
        return redirect()->route('dashboard')->with('success', "You are logged in as $user->name !");
    }

    

    //Delete user
    public function delsystemuser($id)
    {
        //delete the user's withdrawals and deposits
        $deposits = Deposit::where('user_wallet_id', $id)->get();
        if (!empty($deposits)) {
            foreach ($deposits as $deposit) {
                Deposit::where('id', $deposit->id)->delete();
            }
        }
        $withdrawals = Withdrawal::where('user_wallet_id', $id)->get();
        if (!empty($withdrawals)) {
            foreach ($withdrawals as $withdrawals) {
                Withdrawal::where('id', $withdrawals->id)->delete();
            }
        }
        
        
        // delete user_wallet_id from verification list
        if (DB::table('kycs')->where('user_id', $id)->exists()) {
            Kyc::where('user_id', $id)->delete();
        }

        User::where('id', $id)->delete();
        return redirect()->route('manageusers')
            ->with('success', 'User Account deleted successfully!');
    }

    //update users info
    public function edituser(Request $request)
    {

        User::where('id', $request['user_id'])
            ->update([
                'name' => $request['name'],
                'email' => $request['email'],
                'country' => $request['country'],
                'username' => $request['username'],
                'phone' => $request['phone'],
                'ref_link' => $request['ref_link'],

                'random' => $request['random'],
                'currency'=>$request['currency'],
                's_currency'=>$request['s_currency'],
            ]);
        return redirect()->back()->with('success', 'User details updated Successfully!');
    }
    
    //numberoftrades



    public function notifyuser(Request $request)
    {

        User::where('id', $request['user_id'])
            ->update([
                'notify' => $request['notify'],
                'notify_status' => $request['notifystatus'],
                
               
            ]);
        return redirect()->back()->with('success', 'User Plan Upgrade updated Successfully!');
    }



    
    //Send mail to one user
    // Send mail to one user
public function sendmailtooneuser(Request $request)
{
    $request->validate([
        'user_id'  => 'required|exists:users,id',
        'subject'  => 'required|string',
        'message'  => 'required|string',
    ]);

    $user = User::findOrFail($request->user_id);

    Mail::to($user->email)->send(new NewNotification(
        $request->message,
        $request->subject,
        $user->first_name
    ));

    return redirect()->back()->with('success', 'Your message was sent successfully!');
}


// Send mail to all users based on category
public function sendmailtoall(Request $request)
{
    $request->validate([
        'category' => 'required|string',
        'subject'  => 'required|string',
        'message'  => 'required|string',
    ]);

    if ($request->category == "All") {
        User::select(['email', 'first_name'])->chunkById(100, function ($users) use ($request) {
            foreach ($users as $user) {
                Mail::to($user->email)->send(new NewNotification(
                    $request->message,
                    $request->subject,
                    $user->first_name
                ));
            }
        });

    } elseif ($request->category == "No Transactions") {
        // Users without any transaction history
        User::whereDoesntHave('transactions')->select(['email', 'first_name'])->chunkById(100, function ($users) use ($request) {
            foreach ($users as $user) {
                Mail::to($user->email)->send(new NewNotification(
                    $request->message,
                    $request->subject,
                    $user->first_name
                ));
            }
        });

    } elseif ($request->category == "Select Users") {
        $userIds = collect($request->users)->pluck('id');  // Assuming array of user IDs

        User::whereIn('id', $userIds)->select(['email', 'first_name'])->chunkById(100, function ($users) use ($request) {
            foreach ($users as $user) {
                Mail::to($user->email)->send(new NewNotification(
                    $request->message,
                    $request->subject,
                    $user->first_name
                ));
            }
        });
    }

    return redirect()->back()->with('success', 'Your message was sent successfully!');
}


    

   


   

    public function saveuser(Request $request)
    {

        $request->validate([
            'name' => 'required|max:255',
            'username' => 'required|unique:users,username',
            'email' => 'required|email|max:255|unique:users',
            'password' => 'required|min:8|confirmed',
        ]);

        $thisid = DB::table('users')->insertGetId([
            'name' => $request['name'],
            'email' => $request['email'],
            'ref_by' => NULL,
            'username' => $request['username'],
            'password' => Hash::make($request->password),
            'created_at' => \Carbon\Carbon::now(),
            'updated_at' => \Carbon\Carbon::now(),
        ]);

        //assign referal link to user
        $settings = Settings::where('id', '=', '1')->first();
        $user = User::where('id', $thisid)->first();

        User::where('id', $thisid)
            ->update([
                'ref_link' => $settings->site_address . '/ref/' . $user->username,
            ]);
        return redirect()->back()->with('success', 'User created Sucessfully!');
    }
}
