<?php

/**
 * Tatum SDK Caller - API
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Sdk\Caller;
!defined("TATUM-SDK") && exit();

use Tatum\Sdk\Caller;
use Tatum\Api as A;

class Api {
    /**
     * Caller object
     *
     * @var \Tatum\Sdk\Caller
     */
    protected $_caller;

    /**
     * Account API
     *
     * @var \Tatum\Api\AccountApi
     */
    protected $_accountApi = null;

    /**
     * Algorand API
     *
     * @var \Tatum\Api\AlgorandApi
     */
    protected $_algorandApi = null;

    /**
     * Auction API
     *
     * @var \Tatum\Api\AuctionApi
     */
    protected $_auctionApi = null;

    /**
     * BNBBeaconChain API
     *
     * @var \Tatum\Api\BNBBeaconChainApi
     */
    protected $_bNBBeaconChainApi = null;

    /**
     * BNBSmartChain API
     *
     * @var \Tatum\Api\BNBSmartChainApi
     */
    protected $_bNBSmartChainApi = null;

    /**
     * Bitcoin API
     *
     * @var \Tatum\Api\BitcoinApi
     */
    protected $_bitcoinApi = null;

    /**
     * BitcoinCash API
     *
     * @var \Tatum\Api\BitcoinCashApi
     */
    protected $_bitcoinCashApi = null;

    /**
     * BlockchainAddresses API
     *
     * @var \Tatum\Api\BlockchainAddressesApi
     */
    protected $_blockchainAddressesApi = null;

    /**
     * BlockchainFees API
     *
     * @var \Tatum\Api\BlockchainFeesApi
     */
    protected $_blockchainFeesApi = null;

    /**
     * BlockchainOperations API
     *
     * @var \Tatum\Api\BlockchainOperationsApi
     */
    protected $_blockchainOperationsApi = null;

    /**
     * BlockchainStorage API
     *
     * @var \Tatum\Api\BlockchainStorageApi
     */
    protected $_blockchainStorageApi = null;

    /**
     * BlockchainUtils API
     *
     * @var \Tatum\Api\BlockchainUtilsApi
     */
    protected $_blockchainUtilsApi = null;

    /**
     * Celo API
     *
     * @var \Tatum\Api\CeloApi
     */
    protected $_celoApi = null;

    /**
     * CustodialManagedWallets API
     *
     * @var \Tatum\Api\CustodialManagedWalletsApi
     */
    protected $_custodialManagedWalletsApi = null;

    /**
     * Customer API
     *
     * @var \Tatum\Api\CustomerApi
     */
    protected $_customerApi = null;

    /**
     * Deposit API
     *
     * @var \Tatum\Api\DepositApi
     */
    protected $_depositApi = null;

    /**
     * Dogecoin API
     *
     * @var \Tatum\Api\DogecoinApi
     */
    protected $_dogecoinApi = null;

    /**
     * Elrond API
     *
     * @var \Tatum\Api\ElrondApi
     */
    protected $_elrondApi = null;

    /**
     * Ethereum API
     *
     * @var \Tatum\Api\EthereumApi
     */
    protected $_ethereumApi = null;

    /**
     * ExchangeRate API
     *
     * @var \Tatum\Api\ExchangeRateApi
     */
    protected $_exchangeRateApi = null;

    /**
     * Flow API
     *
     * @var \Tatum\Api\FlowApi
     */
    protected $_flowApi = null;

    /**
     * FungibleTokensERC20OrCompatible API
     *
     * @var \Tatum\Api\FungibleTokensERC20OrCompatibleApi
     */
    protected $_fungibleTokensERC20OrCompatibleApi = null;

    /**
     * GasPump API
     *
     * @var \Tatum\Api\GasPumpApi
     */
    protected $_gasPumpApi = null;

    /**
     * Harmony API
     *
     * @var \Tatum\Api\HarmonyApi
     */
    protected $_harmonyApi = null;

    /**
     * IPFS API
     *
     * @var \Tatum\Api\IPFSApi
     */
    protected $_iPFSApi = null;

    /**
     * KeyManagementSystem API
     *
     * @var \Tatum\Api\KeyManagementSystemApi
     */
    protected $_keyManagementSystemApi = null;

    /**
     * Klaytn API
     *
     * @var \Tatum\Api\KlaytnApi
     */
    protected $_klaytnApi = null;

    /**
     * KuCoin API
     *
     * @var \Tatum\Api\KuCoinApi
     */
    protected $_kuCoinApi = null;

    /**
     * Litecoin API
     *
     * @var \Tatum\Api\LitecoinApi
     */
    protected $_litecoinApi = null;

    /**
     * MaliciousAddress API
     *
     * @var \Tatum\Api\MaliciousAddressApi
     */
    protected $_maliciousAddressApi = null;

    /**
     * Marketplace API
     *
     * @var \Tatum\Api\MarketplaceApi
     */
    protected $_marketplaceApi = null;

    /**
     * MultiTokensERC1155OrCompatible API
     *
     * @var \Tatum\Api\MultiTokensERC1155OrCompatibleApi
     */
    protected $_multiTokensERC1155OrCompatibleApi = null;

    /**
     * NFTERC721OrCompatible API
     *
     * @var \Tatum\Api\NFTERC721OrCompatibleApi
     */
    protected $_nFTERC721OrCompatibleApi = null;

    /**
     * NodeRPC API
     *
     * @var \Tatum\Api\NodeRPCApi
     */
    protected $_nodeRPCApi = null;

    /**
     * NotificationSubscriptions API
     *
     * @var \Tatum\Api\NotificationSubscriptionsApi
     */
    protected $_notificationSubscriptionsApi = null;

    /**
     * OrderBook API
     *
     * @var \Tatum\Api\OrderBookApi
     */
    protected $_orderBookApi = null;

    /**
     * Polygon API
     *
     * @var \Tatum\Api\PolygonApi
     */
    protected $_polygonApi = null;

    /**
     * ServiceUtils API
     *
     * @var \Tatum\Api\ServiceUtilsApi
     */
    protected $_serviceUtilsApi = null;

    /**
     * Solana API
     *
     * @var \Tatum\Api\SolanaApi
     */
    protected $_solanaApi = null;

    /**
     * Stellar API
     *
     * @var \Tatum\Api\StellarApi
     */
    protected $_stellarApi = null;

    /**
     * Transaction API
     *
     * @var \Tatum\Api\TransactionApi
     */
    protected $_transactionApi = null;

    /**
     * Tron API
     *
     * @var \Tatum\Api\TronApi
     */
    protected $_tronApi = null;

    /**
     * VeChain API
     *
     * @var \Tatum\Api\VeChainApi
     */
    protected $_veChainApi = null;

    /**
     * VirtualAccountBlockchainFees API
     *
     * @var \Tatum\Api\VirtualAccountBlockchainFeesApi
     */
    protected $_virtualAccountBlockchainFeesApi = null;

    /**
     * VirtualCurrency API
     *
     * @var \Tatum\Api\VirtualCurrencyApi
     */
    protected $_virtualCurrencyApi = null;

    /**
     * Withdrawal API
     *
     * @var \Tatum\Api\WithdrawalApi
     */
    protected $_withdrawalApi = null;

    /**
     * XRP API
     *
     * @var \Tatum\Api\XRPApi
     */
    protected $_xRPApi = null;

    /**
     * XinFin API
     *
     * @var \Tatum\Api\XinFinApi
     */
    protected $_xinFinApi = null;

    /**
     * SDK caller 
     *
     * @param \Tatum\Sdk\Caller $caller Caller object
     */
    public function __construct(Caller $caller) {
        $this->_caller = $caller;
    }
    
    /**
     * Account API
     * 
     * @return \Tatum\Api\AccountApi
     */
    public function account(): A\AccountApi {
        if (null === $this->_accountApi) {
            $this->_accountApi = new A\AccountApi($this->_caller);
        }

        return $this->_accountApi;
    }
    
    /**
     * Algorand API
     * 
     * @return \Tatum\Api\AlgorandApi
     */
    public function algorand(): A\AlgorandApi {
        if (null === $this->_algorandApi) {
            $this->_algorandApi = new A\AlgorandApi($this->_caller);
        }

        return $this->_algorandApi;
    }
    
    /**
     * Auction API
     * 
     * @return \Tatum\Api\AuctionApi
     */
    public function auction(): A\AuctionApi {
        if (null === $this->_auctionApi) {
            $this->_auctionApi = new A\AuctionApi($this->_caller);
        }

        return $this->_auctionApi;
    }
    
    /**
     * BNBBeaconChain API
     * 
     * @return \Tatum\Api\BNBBeaconChainApi
     */
    public function bNBBeaconChain(): A\BNBBeaconChainApi {
        if (null === $this->_bNBBeaconChainApi) {
            $this->_bNBBeaconChainApi = new A\BNBBeaconChainApi($this->_caller);
        }

        return $this->_bNBBeaconChainApi;
    }
    
    /**
     * BNBSmartChain API
     * 
     * @return \Tatum\Api\BNBSmartChainApi
     */
    public function bNBSmartChain(): A\BNBSmartChainApi {
        if (null === $this->_bNBSmartChainApi) {
            $this->_bNBSmartChainApi = new A\BNBSmartChainApi($this->_caller);
        }

        return $this->_bNBSmartChainApi;
    }
    
    /**
     * Bitcoin API
     * 
     * @return \Tatum\Api\BitcoinApi
     */
    public function bitcoin(): A\BitcoinApi {
        if (null === $this->_bitcoinApi) {
            $this->_bitcoinApi = new A\BitcoinApi($this->_caller);
        }

        return $this->_bitcoinApi;
    }
    
    /**
     * BitcoinCash API
     * 
     * @return \Tatum\Api\BitcoinCashApi
     */
    public function bitcoinCash(): A\BitcoinCashApi {
        if (null === $this->_bitcoinCashApi) {
            $this->_bitcoinCashApi = new A\BitcoinCashApi($this->_caller);
        }

        return $this->_bitcoinCashApi;
    }
    
    /**
     * BlockchainAddresses API
     * 
     * @return \Tatum\Api\BlockchainAddressesApi
     */
    public function blockchainAddresses(): A\BlockchainAddressesApi {
        if (null === $this->_blockchainAddressesApi) {
            $this->_blockchainAddressesApi = new A\BlockchainAddressesApi($this->_caller);
        }

        return $this->_blockchainAddressesApi;
    }
    
    /**
     * BlockchainFees API
     * 
     * @return \Tatum\Api\BlockchainFeesApi
     */
    public function blockchainFees(): A\BlockchainFeesApi {
        if (null === $this->_blockchainFeesApi) {
            $this->_blockchainFeesApi = new A\BlockchainFeesApi($this->_caller);
        }

        return $this->_blockchainFeesApi;
    }
    
    /**
     * BlockchainOperations API
     * 
     * @return \Tatum\Api\BlockchainOperationsApi
     */
    public function blockchainOperations(): A\BlockchainOperationsApi {
        if (null === $this->_blockchainOperationsApi) {
            $this->_blockchainOperationsApi = new A\BlockchainOperationsApi($this->_caller);
        }

        return $this->_blockchainOperationsApi;
    }
    
    /**
     * BlockchainStorage API
     * 
     * @return \Tatum\Api\BlockchainStorageApi
     */
    public function blockchainStorage(): A\BlockchainStorageApi {
        if (null === $this->_blockchainStorageApi) {
            $this->_blockchainStorageApi = new A\BlockchainStorageApi($this->_caller);
        }

        return $this->_blockchainStorageApi;
    }
    
    /**
     * BlockchainUtils API
     * 
     * @return \Tatum\Api\BlockchainUtilsApi
     */
    public function blockchainUtils(): A\BlockchainUtilsApi {
        if (null === $this->_blockchainUtilsApi) {
            $this->_blockchainUtilsApi = new A\BlockchainUtilsApi($this->_caller);
        }

        return $this->_blockchainUtilsApi;
    }
    
    /**
     * Celo API
     * 
     * @return \Tatum\Api\CeloApi
     */
    public function celo(): A\CeloApi {
        if (null === $this->_celoApi) {
            $this->_celoApi = new A\CeloApi($this->_caller);
        }

        return $this->_celoApi;
    }
    
    /**
     * CustodialManagedWallets API
     * 
     * @return \Tatum\Api\CustodialManagedWalletsApi
     */
    public function custodialManagedWallets(): A\CustodialManagedWalletsApi {
        if (null === $this->_custodialManagedWalletsApi) {
            $this->_custodialManagedWalletsApi = new A\CustodialManagedWalletsApi($this->_caller);
        }

        return $this->_custodialManagedWalletsApi;
    }
    
    /**
     * Customer API
     * 
     * @return \Tatum\Api\CustomerApi
     */
    public function customer(): A\CustomerApi {
        if (null === $this->_customerApi) {
            $this->_customerApi = new A\CustomerApi($this->_caller);
        }

        return $this->_customerApi;
    }
    
    /**
     * Deposit API
     * 
     * @return \Tatum\Api\DepositApi
     */
    public function deposit(): A\DepositApi {
        if (null === $this->_depositApi) {
            $this->_depositApi = new A\DepositApi($this->_caller);
        }

        return $this->_depositApi;
    }
    
    /**
     * Dogecoin API
     * 
     * @return \Tatum\Api\DogecoinApi
     */
    public function dogecoin(): A\DogecoinApi {
        if (null === $this->_dogecoinApi) {
            $this->_dogecoinApi = new A\DogecoinApi($this->_caller);
        }

        return $this->_dogecoinApi;
    }
    
    /**
     * Elrond API
     * 
     * @return \Tatum\Api\ElrondApi
     */
    public function elrond(): A\ElrondApi {
        if (null === $this->_elrondApi) {
            $this->_elrondApi = new A\ElrondApi($this->_caller);
        }

        return $this->_elrondApi;
    }
    
    /**
     * Ethereum API
     * 
     * @return \Tatum\Api\EthereumApi
     */
    public function ethereum(): A\EthereumApi {
        if (null === $this->_ethereumApi) {
            $this->_ethereumApi = new A\EthereumApi($this->_caller);
        }

        return $this->_ethereumApi;
    }
    
    /**
     * ExchangeRate API
     * 
     * @return \Tatum\Api\ExchangeRateApi
     */
    public function exchangeRate(): A\ExchangeRateApi {
        if (null === $this->_exchangeRateApi) {
            $this->_exchangeRateApi = new A\ExchangeRateApi($this->_caller);
        }

        return $this->_exchangeRateApi;
    }
    
    /**
     * Flow API
     * 
     * @return \Tatum\Api\FlowApi
     */
    public function flow(): A\FlowApi {
        if (null === $this->_flowApi) {
            $this->_flowApi = new A\FlowApi($this->_caller);
        }

        return $this->_flowApi;
    }
    
    /**
     * FungibleTokensERC20OrCompatible API
     * 
     * @return \Tatum\Api\FungibleTokensERC20OrCompatibleApi
     */
    public function fungibleTokensERC20OrCompatible(): A\FungibleTokensERC20OrCompatibleApi {
        if (null === $this->_fungibleTokensERC20OrCompatibleApi) {
            $this->_fungibleTokensERC20OrCompatibleApi = new A\FungibleTokensERC20OrCompatibleApi($this->_caller);
        }

        return $this->_fungibleTokensERC20OrCompatibleApi;
    }
    
    /**
     * GasPump API
     * 
     * @return \Tatum\Api\GasPumpApi
     */
    public function gasPump(): A\GasPumpApi {
        if (null === $this->_gasPumpApi) {
            $this->_gasPumpApi = new A\GasPumpApi($this->_caller);
        }

        return $this->_gasPumpApi;
    }
    
    /**
     * Harmony API
     * 
     * @return \Tatum\Api\HarmonyApi
     */
    public function harmony(): A\HarmonyApi {
        if (null === $this->_harmonyApi) {
            $this->_harmonyApi = new A\HarmonyApi($this->_caller);
        }

        return $this->_harmonyApi;
    }
    
    /**
     * IPFS API
     * 
     * @return \Tatum\Api\IPFSApi
     */
    public function iPFS(): A\IPFSApi {
        if (null === $this->_iPFSApi) {
            $this->_iPFSApi = new A\IPFSApi($this->_caller);
        }

        return $this->_iPFSApi;
    }
    
    /**
     * KeyManagementSystem API
     * 
     * @return \Tatum\Api\KeyManagementSystemApi
     */
    public function keyManagementSystem(): A\KeyManagementSystemApi {
        if (null === $this->_keyManagementSystemApi) {
            $this->_keyManagementSystemApi = new A\KeyManagementSystemApi($this->_caller);
        }

        return $this->_keyManagementSystemApi;
    }
    
    /**
     * Klaytn API
     * 
     * @return \Tatum\Api\KlaytnApi
     */
    public function klaytn(): A\KlaytnApi {
        if (null === $this->_klaytnApi) {
            $this->_klaytnApi = new A\KlaytnApi($this->_caller);
        }

        return $this->_klaytnApi;
    }
    
    /**
     * KuCoin API
     * 
     * @return \Tatum\Api\KuCoinApi
     */
    public function kuCoin(): A\KuCoinApi {
        if (null === $this->_kuCoinApi) {
            $this->_kuCoinApi = new A\KuCoinApi($this->_caller);
        }

        return $this->_kuCoinApi;
    }
    
    /**
     * Litecoin API
     * 
     * @return \Tatum\Api\LitecoinApi
     */
    public function litecoin(): A\LitecoinApi {
        if (null === $this->_litecoinApi) {
            $this->_litecoinApi = new A\LitecoinApi($this->_caller);
        }

        return $this->_litecoinApi;
    }
    
    /**
     * MaliciousAddress API
     * 
     * @return \Tatum\Api\MaliciousAddressApi
     */
    public function maliciousAddress(): A\MaliciousAddressApi {
        if (null === $this->_maliciousAddressApi) {
            $this->_maliciousAddressApi = new A\MaliciousAddressApi($this->_caller);
        }

        return $this->_maliciousAddressApi;
    }
    
    /**
     * Marketplace API
     * 
     * @return \Tatum\Api\MarketplaceApi
     */
    public function marketplace(): A\MarketplaceApi {
        if (null === $this->_marketplaceApi) {
            $this->_marketplaceApi = new A\MarketplaceApi($this->_caller);
        }

        return $this->_marketplaceApi;
    }
    
    /**
     * MultiTokensERC1155OrCompatible API
     * 
     * @return \Tatum\Api\MultiTokensERC1155OrCompatibleApi
     */
    public function multiTokensERC1155OrCompatible(): A\MultiTokensERC1155OrCompatibleApi {
        if (null === $this->_multiTokensERC1155OrCompatibleApi) {
            $this->_multiTokensERC1155OrCompatibleApi = new A\MultiTokensERC1155OrCompatibleApi($this->_caller);
        }

        return $this->_multiTokensERC1155OrCompatibleApi;
    }
    
    /**
     * NFTERC721OrCompatible API
     * 
     * @return \Tatum\Api\NFTERC721OrCompatibleApi
     */
    public function nFTERC721OrCompatible(): A\NFTERC721OrCompatibleApi {
        if (null === $this->_nFTERC721OrCompatibleApi) {
            $this->_nFTERC721OrCompatibleApi = new A\NFTERC721OrCompatibleApi($this->_caller);
        }

        return $this->_nFTERC721OrCompatibleApi;
    }
    
    /**
     * NodeRPC API
     * 
     * @return \Tatum\Api\NodeRPCApi
     */
    public function nodeRPC(): A\NodeRPCApi {
        if (null === $this->_nodeRPCApi) {
            $this->_nodeRPCApi = new A\NodeRPCApi($this->_caller);
        }

        return $this->_nodeRPCApi;
    }
    
    /**
     * NotificationSubscriptions API
     * 
     * @return \Tatum\Api\NotificationSubscriptionsApi
     */
    public function notificationSubscriptions(): A\NotificationSubscriptionsApi {
        if (null === $this->_notificationSubscriptionsApi) {
            $this->_notificationSubscriptionsApi = new A\NotificationSubscriptionsApi($this->_caller);
        }

        return $this->_notificationSubscriptionsApi;
    }
    
    /**
     * OrderBook API
     * 
     * @return \Tatum\Api\OrderBookApi
     */
    public function orderBook(): A\OrderBookApi {
        if (null === $this->_orderBookApi) {
            $this->_orderBookApi = new A\OrderBookApi($this->_caller);
        }

        return $this->_orderBookApi;
    }
    
    /**
     * Polygon API
     * 
     * @return \Tatum\Api\PolygonApi
     */
    public function polygon(): A\PolygonApi {
        if (null === $this->_polygonApi) {
            $this->_polygonApi = new A\PolygonApi($this->_caller);
        }

        return $this->_polygonApi;
    }
    
    /**
     * ServiceUtils API
     * 
     * @return \Tatum\Api\ServiceUtilsApi
     */
    public function serviceUtils(): A\ServiceUtilsApi {
        if (null === $this->_serviceUtilsApi) {
            $this->_serviceUtilsApi = new A\ServiceUtilsApi($this->_caller);
        }

        return $this->_serviceUtilsApi;
    }
    
    /**
     * Solana API
     * 
     * @return \Tatum\Api\SolanaApi
     */
    public function solana(): A\SolanaApi {
        if (null === $this->_solanaApi) {
            $this->_solanaApi = new A\SolanaApi($this->_caller);
        }

        return $this->_solanaApi;
    }
    
    /**
     * Stellar API
     * 
     * @return \Tatum\Api\StellarApi
     */
    public function stellar(): A\StellarApi {
        if (null === $this->_stellarApi) {
            $this->_stellarApi = new A\StellarApi($this->_caller);
        }

        return $this->_stellarApi;
    }
    
    /**
     * Transaction API
     * 
     * @return \Tatum\Api\TransactionApi
     */
    public function transaction(): A\TransactionApi {
        if (null === $this->_transactionApi) {
            $this->_transactionApi = new A\TransactionApi($this->_caller);
        }

        return $this->_transactionApi;
    }
    
    /**
     * Tron API
     * 
     * @return \Tatum\Api\TronApi
     */
    public function tron(): A\TronApi {
        if (null === $this->_tronApi) {
            $this->_tronApi = new A\TronApi($this->_caller);
        }

        return $this->_tronApi;
    }
    
    /**
     * VeChain API
     * 
     * @return \Tatum\Api\VeChainApi
     */
    public function veChain(): A\VeChainApi {
        if (null === $this->_veChainApi) {
            $this->_veChainApi = new A\VeChainApi($this->_caller);
        }

        return $this->_veChainApi;
    }
    
    /**
     * VirtualAccountBlockchainFees API
     * 
     * @return \Tatum\Api\VirtualAccountBlockchainFeesApi
     */
    public function virtualAccountBlockchainFees(): A\VirtualAccountBlockchainFeesApi {
        if (null === $this->_virtualAccountBlockchainFeesApi) {
            $this->_virtualAccountBlockchainFeesApi = new A\VirtualAccountBlockchainFeesApi($this->_caller);
        }

        return $this->_virtualAccountBlockchainFeesApi;
    }
    
    /**
     * VirtualCurrency API
     * 
     * @return \Tatum\Api\VirtualCurrencyApi
     */
    public function virtualCurrency(): A\VirtualCurrencyApi {
        if (null === $this->_virtualCurrencyApi) {
            $this->_virtualCurrencyApi = new A\VirtualCurrencyApi($this->_caller);
        }

        return $this->_virtualCurrencyApi;
    }
    
    /**
     * Withdrawal API
     * 
     * @return \Tatum\Api\WithdrawalApi
     */
    public function withdrawal(): A\WithdrawalApi {
        if (null === $this->_withdrawalApi) {
            $this->_withdrawalApi = new A\WithdrawalApi($this->_caller);
        }

        return $this->_withdrawalApi;
    }
    
    /**
     * XRP API
     * 
     * @return \Tatum\Api\XRPApi
     */
    public function xRP(): A\XRPApi {
        if (null === $this->_xRPApi) {
            $this->_xRPApi = new A\XRPApi($this->_caller);
        }

        return $this->_xRPApi;
    }
    
    /**
     * XinFin API
     * 
     * @return \Tatum\Api\XinFinApi
     */
    public function xinFin(): A\XinFinApi {
        if (null === $this->_xinFinApi) {
            $this->_xinFinApi = new A\XinFinApi($this->_caller);
        }

        return $this->_xinFinApi;
    }
}
