<?php

/**
 * XrpAccountBalance Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * XrpAccountBalance Model
 */
class XrpAccountBalance extends AbstractModel {

    public const _D = null;
    protected static $_name = "XrpAccountBalance";
    protected static $_definition = [
        "assets" => ["assets", "\Tatum\Model\XrpAccountBalanceAssetsInner[]", null, "getAssets", "setAssets", null, ["r" => 0, "c" => 1]], 
        "balance" => ["balance", "string", null, "getBalance", "setBalance", null, ["r" => 0]]
    ];

    /**
     * XrpAccountBalance
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get assets
     *
     * @return \Tatum\Model\XrpAccountBalanceAssetsInner[]|null
     */
    public function getAssets(): ?array {
        return $this->_data["assets"];
    }

    /**
     * Set assets
     * 
     * @param \Tatum\Model\XrpAccountBalanceAssetsInner[]|null $assets Different assets other then XRP available on the account.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAssets(?array $assets) {
        return $this->_set("assets", $assets);
    }

    /**
     * Get balance
     *
     * @return string|null
     */
    public function getBalance(): ?string {
        return $this->_data["balance"];
    }

    /**
     * Set balance
     * 
     * @param string|null $balance Balance of XRP, in drops.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setBalance(?string $balance) {
        return $this->_set("balance", $balance);
    }
}
