<?php

/**
 * SolanaNftMetadataCreator Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * SolanaNftMetadataCreator Model
 */
class SolanaNftMetadataCreator extends AbstractModel {

    public const _D = null;
    protected static $_name = "SolanaNftMetadataCreator";
    protected static $_definition = [
        "address" => ["address", "string", null, "getAddress", "setAddress", null, ["r" => 1, "nl" => 43, "xl" => 44]], 
        "verified" => ["verified", "bool", null, "getVerified", "setVerified", null, ["r" => 1]], 
        "share" => ["share", "float", null, "getShare", "setShare", null, ["r" => 1]]
    ];

    /**
     * SolanaNftMetadataCreator
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get address
     *
     * @return string
     */
    public function getAddress(): string {
        return $this->_data["address"];
    }

    /**
     * Set address
     * 
     * @param string $address The blockchain address of the NFT creator
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAddress(string $address) {
        return $this->_set("address", $address);
    }

    /**
     * Get verified
     *
     * @return bool
     */
    public function getVerified(): bool {
        return $this->_data["verified"];
    }

    /**
     * Set verified
     * 
     * @param bool $verified If set to \"true\", the NFT creator was verified. Only the address whose private key was used during the minting of the NFT can be a verified creator. If you are minting the NFT using NFT Express, set this parameter to \"false\".
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setVerified(bool $verified) {
        return $this->_set("verified", $verified);
    }

    /**
     * Get share
     *
     * @return float
     */
    public function getShare(): float {
        return $this->_data["share"];
    }

    /**
     * Set share
     * 
     * @param float $share The share to be sent to the NFT creator (in %)
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setShare(float $share) {
        return $this->_set("share", $share);
    }
}
