<?php

/**
 * FlowAccount Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * FlowAccount Model
 */
class FlowAccount extends AbstractModel {

    public const _D = null;
    protected static $_name = "FlowAccount";
    protected static $_definition = [
        "address" => ["address", "string", null, "getAddress", "setAddress", null, ["r" => 0]], 
        "balance" => ["balance", "float", null, "getBalance", "setBalance", null, ["r" => 0]], 
        "code" => ["code", "string", null, "getCode", "setCode", null, ["r" => 0]], 
        "contracts" => ["contracts", "object", null, "getContracts", "setContracts", null, ["r" => 0]], 
        "keys" => ["keys", "\Tatum\Model\FlowAccountKeysInner[]", null, "getKeys", "setKeys", null, ["r" => 0, "c" => 1]]
    ];

    /**
     * FlowAccount
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get address
     *
     * @return string|null
     */
    public function getAddress(): ?string {
        return $this->_data["address"];
    }

    /**
     * Set address
     * 
     * @param string|null $address Account address.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAddress(?string $address) {
        return $this->_set("address", $address);
    }

    /**
     * Get balance
     *
     * @return float|null
     */
    public function getBalance(): ?float {
        return $this->_data["balance"];
    }

    /**
     * Set balance
     * 
     * @param float|null $balance Balance of the account in smallest FLOW unit = 1 FLOW = 1e8 unit
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setBalance(?float $balance) {
        return $this->_set("balance", $balance);
    }

    /**
     * Get code
     *
     * @return string|null
     */
    public function getCode(): ?string {
        return $this->_data["code"];
    }

    /**
     * Set code
     * 
     * @param string|null $code Account code
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setCode(?string $code) {
        return $this->_set("code", $code);
    }

    /**
     * Get contracts
     *
     * @return object|null
     */
    public function getContracts(): ?object {
        return $this->_data["contracts"];
    }

    /**
     * Set contracts
     * 
     * @param object|null $contracts contracts
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setContracts(?object $contracts) {
        return $this->_set("contracts", $contracts);
    }

    /**
     * Get keys
     *
     * @return \Tatum\Model\FlowAccountKeysInner[]|null
     */
    public function getKeys(): ?array {
        return $this->_data["keys"];
    }

    /**
     * Set keys
     * 
     * @param \Tatum\Model\FlowAccountKeysInner[]|null $keys Array of public keys assigned.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setKeys(?array $keys) {
        return $this->_set("keys", $keys);
    }
}
