<?php

/**
 * Address Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * Address Model
 */
class Address extends AbstractModel {

    public const _D = null;
    protected static $_name = "Address";
    protected static $_definition = [
        "address" => ["address", "string", null, "getAddress", "setAddress", null, ["r" => 1]], 
        "currency" => ["currency", "string", null, "getCurrency", "setCurrency", null, ["r" => 1]], 
        "derivation_key" => ["derivationKey", "int", 'int32', "getDerivationKey", "setDerivationKey", null, ["r" => 0, "x" => [2147483647]]], 
        "xpub" => ["xpub", "string", null, "getXpub", "setXpub", null, ["r" => 0]], 
        "destination_tag" => ["destinationTag", "float", null, "getDestinationTag", "setDestinationTag", null, ["r" => 0]], 
        "memo" => ["memo", "string", null, "getMemo", "setMemo", null, ["r" => 0]], 
        "message" => ["message", "string", null, "getMessage", "setMessage", null, ["r" => 0]]
    ];

    /**
     * Address
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get address
     *
     * @return string
     */
    public function getAddress(): string {
        return $this->_data["address"];
    }

    /**
     * Set address
     * 
     * @param string $address Blockchain address.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAddress(string $address) {
        return $this->_set("address", $address);
    }

    /**
     * Get currency
     *
     * @return string
     */
    public function getCurrency(): string {
        return $this->_data["currency"];
    }

    /**
     * Set currency
     * 
     * @param string $currency Currency of generated address. BTC, LTC, DOGE, BCH, ETH, XRP, XLM, BNB, TRX, ERC20, TRC20.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setCurrency(string $currency) {
        return $this->_set("currency", $currency);
    }

    /**
     * Get derivation_key
     *
     * @return int|null
     */
    public function getDerivationKey(): ?int {
        return $this->_data["derivation_key"];
    }

    /**
     * Set derivation_key
     * 
     * @param int|null $derivation_key Derivation key index for given address.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setDerivationKey(?int $derivation_key) {
        return $this->_set("derivation_key", $derivation_key);
    }

    /**
     * Get xpub
     *
     * @return string|null
     */
    public function getXpub(): ?string {
        return $this->_data["xpub"];
    }

    /**
     * Set xpub
     * 
     * @param string|null $xpub Extended public key to derive address from. In case of XRP, this is account address, since address is defined as DestinationTag, which is address field. In case of XLM, this is account address, since address is defined as message, which is address field.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setXpub(?string $xpub) {
        return $this->_set("xpub", $xpub);
    }

    /**
     * Get destination_tag
     *
     * @return float|null
     */
    public function getDestinationTag(): ?float {
        return $this->_data["destination_tag"];
    }

    /**
     * Set destination_tag
     * 
     * @param float|null $destination_tag In case of XRP, destinationTag is the distinguisher of the account.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setDestinationTag(?float $destination_tag) {
        return $this->_set("destination_tag", $destination_tag);
    }

    /**
     * Get memo
     *
     * @return string|null
     */
    public function getMemo(): ?string {
        return $this->_data["memo"];
    }

    /**
     * Set memo
     * 
     * @param string|null $memo In case of BNB, message is the distinguisher of the account.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setMemo(?string $memo) {
        return $this->_set("memo", $memo);
    }

    /**
     * Get message
     *
     * @return string|null
     */
    public function getMessage(): ?string {
        return $this->_data["message"];
    }

    /**
     * Set message
     * 
     * @param string|null $message In case of XLM, message is the distinguisher of the account.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setMessage(?string $message) {
        return $this->_set("message", $message);
    }
}
