<?php

/**
 * Implementation of Marketplace API
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Api;
!defined("TATUM-SDK") && exit();

use InvalidArgumentException as IAE;
use Tatum\Sdk\Serializer as S;

/**
 * API for Marketplace
 */
class MarketplaceApi extends AbstractApi {
    
    /**
     * API package
     */
    const PKG = "Marketplace";

    /**
     * Withdraw funds from the marketplace treasury account on Solana
     *
     * @param \Tatum\Model\WithdrawFromMarketplaceSolana $withdraw_from_marketplace_solana 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function bloMarWithdrawFromMarketplaceSolana($withdraw_from_marketplace_solana) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/withdraw/treasury";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $withdraw_from_marketplace_solana
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Withdraw funds from the marketplace treasury account on Solana
     *
     * @param \Tatum\Model\WithdrawFromMarketplaceSolanaKMS $withdraw_from_marketplace_solana_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function bloMarWithdrawFromMarketplaceSolanaKMS($withdraw_from_marketplace_solana_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/withdraw/treasury";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $withdraw_from_marketplace_solana_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Buy an asset on the NFT marketplace
     *
     * @param \Tatum\Model\BuyAssetOnMarketplace $buy_asset_on_marketplace 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function buyAssetOnMarketplace($buy_asset_on_marketplace) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/buy";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $buy_asset_on_marketplace
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Buy an asset on the NFT marketplace
     *
     * @param \Tatum\Model\BuyAssetOnMarketplaceCelo $buy_asset_on_marketplace_celo 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function buyAssetOnMarketplaceCelo($buy_asset_on_marketplace_celo) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/buy";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $buy_asset_on_marketplace_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Buy an asset on the NFT marketplace
     *
     * @param \Tatum\Model\BuyAssetOnMarketplaceCeloKMS $buy_asset_on_marketplace_celo_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function buyAssetOnMarketplaceCeloKMS($buy_asset_on_marketplace_celo_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/buy";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $buy_asset_on_marketplace_celo_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Buy an asset on the NFT marketplace
     *
     * @param \Tatum\Model\BuyAssetOnMarketplaceKMS $buy_asset_on_marketplace_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function buyAssetOnMarketplaceKMS($buy_asset_on_marketplace_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/buy";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $buy_asset_on_marketplace_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Buy an asset on the NFT marketplace
     *
     * @param \Tatum\Model\BuyAssetOnMarketplaceSolana $buy_asset_on_marketplace_solana 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function buyAssetOnMarketplaceSolana($buy_asset_on_marketplace_solana) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/buy";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $buy_asset_on_marketplace_solana
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Buy an asset on the NFT marketplace
     *
     * @param \Tatum\Model\BuyAssetOnMarketplaceSolanaKMS $buy_asset_on_marketplace_solana_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function buyAssetOnMarketplaceSolanaKMS($buy_asset_on_marketplace_solana_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/buy";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $buy_asset_on_marketplace_solana_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Cancel the selling of an asset on the NFT marketplace
     *
     * @param \Tatum\Model\CancelSellAssetOnMarketplace $cancel_sell_asset_on_marketplace 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function cancelSellAssetOnMarketplace($cancel_sell_asset_on_marketplace) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/cancel";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $cancel_sell_asset_on_marketplace
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Cancel the selling of an asset on the NFT marketplace
     *
     * @param \Tatum\Model\CancelSellAssetOnMarketplaceCelo $cancel_sell_asset_on_marketplace_celo 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function cancelSellAssetOnMarketplaceCelo($cancel_sell_asset_on_marketplace_celo) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/cancel";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $cancel_sell_asset_on_marketplace_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Cancel the selling of an asset on the NFT marketplace
     *
     * @param \Tatum\Model\CancelSellAssetOnMarketplaceCeloKMS $cancel_sell_asset_on_marketplace_celo_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function cancelSellAssetOnMarketplaceCeloKMS($cancel_sell_asset_on_marketplace_celo_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/cancel";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $cancel_sell_asset_on_marketplace_celo_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Cancel the selling of an asset on the NFT marketplace
     *
     * @param \Tatum\Model\CancelSellAssetOnMarketplaceKMS $cancel_sell_asset_on_marketplace_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function cancelSellAssetOnMarketplaceKMS($cancel_sell_asset_on_marketplace_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/cancel";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $cancel_sell_asset_on_marketplace_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Cancel the selling of an asset on the NFT marketplace
     *
     * @param \Tatum\Model\CancelSellAssetOnMarketplaceSolana $cancel_sell_asset_on_marketplace_solana 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function cancelSellAssetOnMarketplaceSolana($cancel_sell_asset_on_marketplace_solana) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/cancel";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $cancel_sell_asset_on_marketplace_solana
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Cancel the selling of an asset on the NFT marketplace
     *
     * @param \Tatum\Model\CancelSellAssetOnMarketplaceSolanaKMS $cancel_sell_asset_on_marketplace_solana_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function cancelSellAssetOnMarketplaceSolanaKMS($cancel_sell_asset_on_marketplace_solana_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/cancel";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $cancel_sell_asset_on_marketplace_solana_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Create an NFT marketplace
     *
     * @param \Tatum\Model\GenerateMarketplace $generate_marketplace 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\GenerateMarketplace200Response
     */
    public function generateMarketplace($generate_marketplace) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing";
        /** @var \Tatum\Model\GenerateMarketplace200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $generate_marketplace
            ), 
            "\Tatum\Model\GenerateMarketplace200Response"
        );
            
        return $result;
    }
    
    /**
     * Create an NFT marketplace
     *
     * @param \Tatum\Model\GenerateMarketplaceCelo $generate_marketplace_celo 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\GenerateMarketplace200Response
     */
    public function generateMarketplaceCelo($generate_marketplace_celo) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing";
        /** @var \Tatum\Model\GenerateMarketplace200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $generate_marketplace_celo
            ), 
            "\Tatum\Model\GenerateMarketplace200Response"
        );
            
        return $result;
    }
    
    /**
     * Create an NFT marketplace
     *
     * @param \Tatum\Model\GenerateMarketplaceCeloKMS $generate_marketplace_celo_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\GenerateMarketplace200Response
     */
    public function generateMarketplaceCeloKMS($generate_marketplace_celo_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing";
        /** @var \Tatum\Model\GenerateMarketplace200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $generate_marketplace_celo_kms
            ), 
            "\Tatum\Model\GenerateMarketplace200Response"
        );
            
        return $result;
    }
    
    /**
     * Create an NFT marketplace
     *
     * @param \Tatum\Model\GenerateMarketplaceKMS $generate_marketplace_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\GenerateMarketplace200Response
     */
    public function generateMarketplaceKMS($generate_marketplace_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing";
        /** @var \Tatum\Model\GenerateMarketplace200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $generate_marketplace_kms
            ), 
            "\Tatum\Model\GenerateMarketplace200Response"
        );
            
        return $result;
    }
    
    /**
     * Create an NFT marketplace
     *
     * @param \Tatum\Model\GenerateMarketplaceSolana $generate_marketplace_solana 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\GenerateMarketplace200Response
     */
    public function generateMarketplaceSolana($generate_marketplace_solana) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing";
        /** @var \Tatum\Model\GenerateMarketplace200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $generate_marketplace_solana
            ), 
            "\Tatum\Model\GenerateMarketplace200Response"
        );
            
        return $result;
    }
    
    /**
     * Create an NFT marketplace
     *
     * @param \Tatum\Model\GenerateMarketplaceSolanaKMS $generate_marketplace_solana_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\GenerateMarketplace200Response
     */
    public function generateMarketplaceSolanaKMS($generate_marketplace_solana_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing";
        /** @var \Tatum\Model\GenerateMarketplace200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $generate_marketplace_solana_kms
            ), 
            "\Tatum\Model\GenerateMarketplace200Response"
        );
            
        return $result;
    }
    
    /**
     * Get the NFT marketplace fee
     *
     * @param string $chain Blockchain to work with
     * @param string $contract_address Contract address
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return float
     */
    public function getMarketplaceFee($chain, $contract_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/{chain}/{contractAddress}/fee";
        /** @var float $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["chain" => $chain, "contractAddress" => $contract_address]), $rPath, [], $rHeaders, []
            ), 
            "float"
        );
            
        return $result;
    }
    
    /**
     * Get the recipient of the NFT marketplace fee
     *
     * @param string $chain Blockchain to work with
     * @param string $contract_address Contract address
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\GetMarketplaceFeeRecipient200Response
     */
    public function getMarketplaceFeeRecipient($chain, $contract_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/{chain}/{contractAddress}/recipient";
        /** @var \Tatum\Model\GetMarketplaceFeeRecipient200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["chain" => $chain, "contractAddress" => $contract_address]), $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\GetMarketplaceFeeRecipient200Response"
        );
            
        return $result;
    }
    
    /**
     * Get information about an NFT marketplace on Solana
     *
     * @param string $chain Blockchain to work with
     * @param string $contract_address Contract address
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\GetMarketplaceInfo200Response
     */
    public function getMarketplaceInfo($chain, $contract_address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/{chain}/{contractAddress}";
        /** @var \Tatum\Model\GetMarketplaceInfo200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["chain" => $chain, "contractAddress" => $contract_address]), $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\GetMarketplaceInfo200Response"
        );
            
        return $result;
    }
    
    /**
     * Get information about a listing on the NFT marketplace
     *
     * @param string $chain Blockchain to work with
     * @param string $contract_address Contract address
     * @param string $id Listing ID
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\GetMarketplaceListing200Response
     */
    public function getMarketplaceListing($chain, $contract_address, $id) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/{chain}/{contractAddress}/listing/{id}";
        /** @var \Tatum\Model\GetMarketplaceListing200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["chain" => $chain, "contractAddress" => $contract_address, "id" => $id]), $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\GetMarketplaceListing200Response"
        );
            
        return $result;
    }
    
    /**
     * Get the listings of a certain type from the NFT marketplace
     *
     * @param string $chain Blockchain to work with
     * @param string $contract_address Contract address
     * @param string $type The type of listings to return
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return string[]
     */
    public function getMarketplaceListings($chain, $contract_address, $type) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/{chain}/{contractAddress}/{type}";
        /** @var string[] $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["chain" => $chain, "contractAddress" => $contract_address, "type" => $type]), $rPath, [], $rHeaders, []
            ), 
            "string[]"
        );
            
        return $result;
    }
    
    /**
     * Sell an asset on the NFT marketplace
     *
     * @param \Tatum\Model\SellAssetOnMarketplace $sell_asset_on_marketplace 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\SellAssetOnMarketplace200Response
     */
    public function sellAssetOnMarketplace($sell_asset_on_marketplace) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/sell";
        /** @var \Tatum\Model\SellAssetOnMarketplace200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $sell_asset_on_marketplace
            ), 
            "\Tatum\Model\SellAssetOnMarketplace200Response"
        );
            
        return $result;
    }
    
    /**
     * Sell an asset on the NFT marketplace
     *
     * @param \Tatum\Model\SellAssetOnMarketplaceCelo $sell_asset_on_marketplace_celo 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\SellAssetOnMarketplace200Response
     */
    public function sellAssetOnMarketplaceCelo($sell_asset_on_marketplace_celo) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/sell";
        /** @var \Tatum\Model\SellAssetOnMarketplace200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $sell_asset_on_marketplace_celo
            ), 
            "\Tatum\Model\SellAssetOnMarketplace200Response"
        );
            
        return $result;
    }
    
    /**
     * Sell an asset on the NFT marketplace
     *
     * @param \Tatum\Model\SellAssetOnMarketplaceCeloKMS $sell_asset_on_marketplace_celo_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\SellAssetOnMarketplace200Response
     */
    public function sellAssetOnMarketplaceCeloKMS($sell_asset_on_marketplace_celo_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/sell";
        /** @var \Tatum\Model\SellAssetOnMarketplace200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $sell_asset_on_marketplace_celo_kms
            ), 
            "\Tatum\Model\SellAssetOnMarketplace200Response"
        );
            
        return $result;
    }
    
    /**
     * Sell an asset on the NFT marketplace
     *
     * @param \Tatum\Model\SellAssetOnMarketplaceKMS $sell_asset_on_marketplace_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\SellAssetOnMarketplace200Response
     */
    public function sellAssetOnMarketplaceKMS($sell_asset_on_marketplace_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/sell";
        /** @var \Tatum\Model\SellAssetOnMarketplace200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $sell_asset_on_marketplace_kms
            ), 
            "\Tatum\Model\SellAssetOnMarketplace200Response"
        );
            
        return $result;
    }
    
    /**
     * Sell an asset on the NFT marketplace
     *
     * @param \Tatum\Model\SellAssetOnMarketplaceSolana $sell_asset_on_marketplace_solana 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\SellAssetOnMarketplace200Response
     */
    public function sellAssetOnMarketplaceSolana($sell_asset_on_marketplace_solana) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/sell";
        /** @var \Tatum\Model\SellAssetOnMarketplace200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $sell_asset_on_marketplace_solana
            ), 
            "\Tatum\Model\SellAssetOnMarketplace200Response"
        );
            
        return $result;
    }
    
    /**
     * Sell an asset on the NFT marketplace
     *
     * @param \Tatum\Model\SellAssetOnMarketplaceSolanaKMS $sell_asset_on_marketplace_solana_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\SellAssetOnMarketplace200Response
     */
    public function sellAssetOnMarketplaceSolanaKMS($sell_asset_on_marketplace_solana_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/sell";
        /** @var \Tatum\Model\SellAssetOnMarketplace200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $sell_asset_on_marketplace_solana_kms
            ), 
            "\Tatum\Model\SellAssetOnMarketplace200Response"
        );
            
        return $result;
    }
    
    /**
     * Update the NFT marketplace fee
     *
     * @param \Tatum\Model\UpdateFee $update_fee 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function updateFee($update_fee) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/fee";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", $rPath, $rPath, [], $rHeaders, [], $update_fee
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Update the NFT marketplace fee
     *
     * @param \Tatum\Model\UpdateFeeCelo $update_fee_celo 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function updateFeeCelo($update_fee_celo) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/fee";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", $rPath, $rPath, [], $rHeaders, [], $update_fee_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Update the NFT marketplace fee
     *
     * @param \Tatum\Model\UpdateFeeCeloKMS $update_fee_celo_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function updateFeeCeloKMS($update_fee_celo_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/fee";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", $rPath, $rPath, [], $rHeaders, [], $update_fee_celo_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Update the NFT marketplace fee
     *
     * @param \Tatum\Model\UpdateFeeKMS $update_fee_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function updateFeeKMS($update_fee_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/fee";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", $rPath, $rPath, [], $rHeaders, [], $update_fee_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Update the recipient of the NFT marketplace fee
     *
     * @param \Tatum\Model\UpdateFeeRecipient $update_fee_recipient 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function updateFeeRecipient($update_fee_recipient) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/recipient";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", $rPath, $rPath, [], $rHeaders, [], $update_fee_recipient
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Update the recipient of the NFT marketplace fee
     *
     * @param \Tatum\Model\UpdateFeeRecipientCelo $update_fee_recipient_celo 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function updateFeeRecipientCelo($update_fee_recipient_celo) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/recipient";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", $rPath, $rPath, [], $rHeaders, [], $update_fee_recipient_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Update the recipient of the NFT marketplace fee
     *
     * @param \Tatum\Model\UpdateFeeRecipientCeloKMS $update_fee_recipient_celo_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function updateFeeRecipientCeloKMS($update_fee_recipient_celo_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/recipient";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", $rPath, $rPath, [], $rHeaders, [], $update_fee_recipient_celo_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Update the recipient of the NFT marketplace fee
     *
     * @param \Tatum\Model\UpdateFeeRecipientKMS $update_fee_recipient_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function updateFeeRecipientKMS($update_fee_recipient_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/recipient";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", $rPath, $rPath, [], $rHeaders, [], $update_fee_recipient_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Update the recipient of the NFT marketplace fee
     *
     * @param \Tatum\Model\UpdateFeeRecipientSolana $update_fee_recipient_solana 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function updateFeeRecipientSolana($update_fee_recipient_solana) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/recipient";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", $rPath, $rPath, [], $rHeaders, [], $update_fee_recipient_solana
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Update the recipient of the NFT marketplace fee
     *
     * @param \Tatum\Model\UpdateFeeRecipientSolanaKMS $update_fee_recipient_solana_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function updateFeeRecipientSolanaKMS($update_fee_recipient_solana_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/recipient";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", $rPath, $rPath, [], $rHeaders, [], $update_fee_recipient_solana_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Update the NFT marketplace fee
     *
     * @param \Tatum\Model\UpdateFeeSolana $update_fee_solana 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function updateFeeSolana($update_fee_solana) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/fee";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", $rPath, $rPath, [], $rHeaders, [], $update_fee_solana
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Update the NFT marketplace fee
     *
     * @param \Tatum\Model\UpdateFeeSolanaKMS $update_fee_solana_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function updateFeeSolanaKMS($update_fee_solana_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing/fee";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", $rPath, $rPath, [], $rHeaders, [], $update_fee_solana_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Update an NFT marketplace on Solana
     *
     * @param \Tatum\Model\UpdateMarketplaceSolana $update_marketplace_solana 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function updateMarketplaceSolana($update_marketplace_solana) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", $rPath, $rPath, [], $rHeaders, [], $update_marketplace_solana
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Update an NFT marketplace on Solana
     *
     * @param \Tatum\Model\UpdateMarketplaceSolanaKMS $update_marketplace_solana_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function updateMarketplaceSolanaKMS($update_marketplace_solana_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/listing";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", $rPath, $rPath, [], $rHeaders, [], $update_marketplace_solana_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Withdraw funds from the marketplace fee account on Solana
     *
     * @param \Tatum\Model\WithdrawFromMarketplaceSolana $withdraw_from_marketplace_solana 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function withdrawFromMarketplaceSolana($withdraw_from_marketplace_solana) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/withdraw/fee";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $withdraw_from_marketplace_solana
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Withdraw funds from the marketplace fee account on Solana
     *
     * @param \Tatum\Model\WithdrawFromMarketplaceSolanaKMS $withdraw_from_marketplace_solana_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function withdrawFromMarketplaceSolanaKMS($withdraw_from_marketplace_solana_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/marketplace/withdraw/fee";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $withdraw_from_marketplace_solana_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
}
