---
title: KuCoin
parent: API
layout: page
---

# Api/KuCoinApi

[KuCoin API Reference](https://apidoc.tatum.io/tag/KuCoin/)

```php
// Set your API Keys 👇 here
$sdk = new \Tatum\Sdk();

// MainNet API Call
$sdk->mainnet()->api()->kuCoin();

// TestNet API Call
$sdk->testnet()->api()->kuCoin();
```

## Methods

Method | Description
------------- | -------------
[**callKcsSmartContractMethod()**](#callkcssmartcontractmethod) | Invoke a method in a smart contract on KuCoin Community Chain
[**callKcsSmartContractMethodKMS()**](#callkcssmartcontractmethodkms) | Invoke a method in a smart contract on KuCoin Community Chain
[**callKcsSmartContractReadMethod()**](#callkcssmartcontractreadmethod) | Invoke a method in a smart contract on KuCoin Community Chain
[**kcsBroadcast()**](#kcsbroadcast) | Broadcast signed Kcs transaction
[**kcsGenerateAddress()**](#kcsgenerateaddress) | Generate Kcs account address from Extended public key
[**kcsGenerateAddressPrivateKey()**](#kcsgenerateaddressprivatekey) | Generate Kcs private key
[**kcsGenerateWallet()**](#kcsgeneratewallet) | Generate Kcs wallet
[**kcsGetBalance()**](#kcsgetbalance) | Get Kcs Account balance
[**kcsGetBlock()**](#kcsgetblock) | Get Kcs block by hash
[**kcsGetCurrentBlock()**](#kcsgetcurrentblock) | Get current block number
[**kcsGetTransaction()**](#kcsgettransaction) | Get Kcs Transaction
[**kcsGetTransactionCount()**](#kcsgettransactioncount) | Get count of outgoing Kcs transactions
[**transferKcsBlockchain()**](#transferkcsblockchain) | Send KCS from account to account
[**transferKcsBlockchainKMS()**](#transferkcsblockchainkms) | Send KCS from account to account


## `callKcsSmartContractMethod()`

### Example

{: .new-title }
> #️⃣ Execute command in terminal 
> 
> [✨ php -f **callKcsSmartContractMethod.php**](https://github.com/tatumio/tatum-php/blob/master/examples/Api/KuCoinApi/callKcsSmartContractMethod.php){: .btn .btn-green .mt-4}

### Request

> **POST** `/v3/kcs/smartcontract`

### Type signature

```php
(new \Tatum\Sdk())->{mainnet/testnet}()->api()->kuCoin()->callKcsSmartContractMethod(
    \Tatum\Model\CallKcsSmartContractMethod $call_kcs_smart_contract_method
): \Tatum\Model\CallSmartContractMethod200Response
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **$call_kcs_smart_contract_method** | [**\Tatum\Model\CallKcsSmartContractMethod**](../../Model/CallKcsSmartContractMethod) |  |

### Return type

[**\Tatum\Model\CallSmartContractMethod200Response**](../../Model/CallSmartContractMethod200Response)

### Description

> Invoke a method in a smart contract on KuCoin Community Chain



[Back to top](#top){: .btn .btn-purple }

---


## `callKcsSmartContractMethodKMS()`

### Example

{: .new-title }
> #️⃣ Execute command in terminal 
> 
> [✨ php -f **callKcsSmartContractMethodKMS.php**](https://github.com/tatumio/tatum-php/blob/master/examples/Api/KuCoinApi/callKcsSmartContractMethodKMS.php){: .btn .btn-green .mt-4}

### Request

> **POST** `/v3/kcs/smartcontract`

### Type signature

```php
(new \Tatum\Sdk())->{mainnet/testnet}()->api()->kuCoin()->callKcsSmartContractMethodKMS(
    \Tatum\Model\CallKcsSmartContractMethodKMS $call_kcs_smart_contract_method_kms
): \Tatum\Model\CallSmartContractMethod200Response
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **$call_kcs_smart_contract_method_kms** | [**\Tatum\Model\CallKcsSmartContractMethodKMS**](../../Model/CallKcsSmartContractMethodKMS) |  |

### Return type

[**\Tatum\Model\CallSmartContractMethod200Response**](../../Model/CallSmartContractMethod200Response)

### Description

> Invoke a method in a smart contract on KuCoin Community Chain



[Back to top](#top){: .btn .btn-purple }

---


## `callKcsSmartContractReadMethod()`

### Example

{: .new-title }
> #️⃣ Execute command in terminal 
> 
> [✨ php -f **callKcsSmartContractReadMethod.php**](https://github.com/tatumio/tatum-php/blob/master/examples/Api/KuCoinApi/callKcsSmartContractReadMethod.php){: .btn .btn-green .mt-4}

### Request

> **POST** `/v3/kcs/smartcontract`

### Type signature

```php
(new \Tatum\Sdk())->{mainnet/testnet}()->api()->kuCoin()->callKcsSmartContractReadMethod(
    \Tatum\Model\CallKcsSmartContractReadMethod $call_kcs_smart_contract_read_method
): \Tatum\Model\CallSmartContractMethod200Response
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **$call_kcs_smart_contract_read_method** | [**\Tatum\Model\CallKcsSmartContractReadMethod**](../../Model/CallKcsSmartContractReadMethod) |  |

### Return type

[**\Tatum\Model\CallSmartContractMethod200Response**](../../Model/CallSmartContractMethod200Response)

### Description

> Invoke a method in a smart contract on KuCoin Community Chain

**2 credits per API call**

Invoke a method in an existing smart contract on KuCoin Community Chain.

You can call a read-only or write method.

* For **read-only** methods, the output of the invoked method is returned.
* For **write** methods, the ID of the associated transaction is returned.

**Troubleshooting a failed transaction** Tatum ensures that this API works against the blockchain (accesses the blockchain, finds the specified smart contract, and executes the specified ABI method with the provided parameters). However, because this API can be run against any smart contract on the blockchain, Tatum cannot in any way guarantee that the method itself will be executed successfully.

If you have issues with invoking the method, refer to the user documentation for this method, or contact the author of the smart contract.

For more information about invoking methods in smart contracts, see [this article](https://support.tatum.io/support/solutions/articles/80001052441) on our Support Portal.

**Signing a transaction** When invoking a method in a smart contract, you are charged a fee for the transaction, and you must sign the transaction with the private key of the blockchain address from which the fee will be deducted.

Providing the private key in the API is not a secure way of signing transactions, because the private key can be stolen or exposed. Your private keys should never leave your security perimeter. You should use the private keys only for testing a solution you are building on the **testnet** of a blockchain.

For signing transactions on the **mainnet**, we strongly recommend that you use the Tatum [Key Management System (KMS)](https://github.com/tatumio/tatum-kms) and provide the signature ID instead of the private key in the API. Alternatively, you can use the [Tatum JavaScript client](https://github.com/tatumio/tatum-js).

[Back to top](#top){: .btn .btn-purple }

---


## `kcsBroadcast()`

### Example

{: .new-title }
> #️⃣ Execute command in terminal 
> 
> [✨ php -f **kcsBroadcast.php**](https://github.com/tatumio/tatum-php/blob/master/examples/Api/KuCoinApi/kcsBroadcast.php){: .btn .btn-green .mt-4}

### Request

> **POST** `/v3/kcs/broadcast`

### Type signature

```php
(new \Tatum\Sdk())->{mainnet/testnet}()->api()->kuCoin()->kcsBroadcast(
    \Tatum\Model\BroadcastKMS $broadcast_kms
): \Tatum\Model\TransactionHash
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **$broadcast_kms** | [**\Tatum\Model\BroadcastKMS**](../../Model/BroadcastKMS) |  |

### Return type

[**\Tatum\Model\TransactionHash**](../../Model/TransactionHash)

### Description

> Broadcast signed Kcs transaction

**2 credits per API call**

Broadcast signed transaction to Kcs blockchain. This method is used internally from Tatum KMS or Tatum client libraries. It is possible to create custom signing mechanism and use this method only for broadcasting data to the blockchain.

[Back to top](#top){: .btn .btn-purple }

---


## `kcsGenerateAddress()`

### Example

{: .new-title }
> #️⃣ Execute command in terminal 
> 
> [✨ php -f **kcsGenerateAddress.php**](https://github.com/tatumio/tatum-php/blob/master/examples/Api/KuCoinApi/kcsGenerateAddress.php){: .btn .btn-green .mt-4}

### Request

> **GET** `/v3/kcs/address/{xpub}/{index}`

### Type signature

```php
(new \Tatum\Sdk())->{mainnet/testnet}()->api()->kuCoin()->kcsGenerateAddress(
    string $xpub,
    float $index
): \Tatum\Model\KcsGenerateAddress200Response
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **$xpub** | **string**  | Extended public key of wallet. |
 **$index** | **float**  | Derivation index of desired address to be generated. |

### Return type

[**\Tatum\Model\KcsGenerateAddress200Response**](../../Model/KcsGenerateAddress200Response)

### Description

> Generate Kcs account address from Extended public key

**1 credit per API call**

Generate Kcs account deposit address from Extended public key. Deposit address is generated for the specific index - each extended public key can generate up to 2^31 addresses starting from index 0 until 2^31.

[Back to top](#top){: .btn .btn-purple }

---


## `kcsGenerateAddressPrivateKey()`

### Example

{: .new-title }
> #️⃣ Execute command in terminal 
> 
> [✨ php -f **kcsGenerateAddressPrivateKey.php**](https://github.com/tatumio/tatum-php/blob/master/examples/Api/KuCoinApi/kcsGenerateAddressPrivateKey.php){: .btn .btn-green .mt-4}

### Request

> **POST** `/v3/kcs/wallet/priv`

### Type signature

```php
(new \Tatum\Sdk())->{mainnet/testnet}()->api()->kuCoin()->kcsGenerateAddressPrivateKey(
    \Tatum\Model\PrivKeyRequest $priv_key_request
): \Tatum\Model\PrivKey
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **$priv_key_request** | [**\Tatum\Model\PrivKeyRequest**](../../Model/PrivKeyRequest) |  |

### Return type

[**\Tatum\Model\PrivKey**](../../Model/PrivKey)

### Description

> Generate Kcs private key

**1 credit per API call**

Generate private key of address from mnemonic for given derivation path index. Private key is generated for the specific index - each mnemonic can generate up to 2^31 private keys starting from index 0 until 2^31.

[Back to top](#top){: .btn .btn-purple }

---


## `kcsGenerateWallet()`

### Example

{: .new-title }
> #️⃣ Execute command in terminal 
> 
> [✨ php -f **kcsGenerateWallet.php**](https://github.com/tatumio/tatum-php/blob/master/examples/Api/KuCoinApi/kcsGenerateWallet.php){: .btn .btn-green .mt-4}

### Request

> **GET** `/v3/kcs/wallet`

### Type signature

```php
(new \Tatum\Sdk())->{mainnet/testnet}()->api()->kuCoin()->kcsGenerateWallet(
    [ string $mnemonic ]
): \Tatum\Model\Wallet
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **$mnemonic** | **string**  | Mnemonic to use for generation of extended public and private keys. | [optional]

### Return type

[**\Tatum\Model\Wallet**](../../Model/Wallet)

### Description

> Generate Kcs wallet

**1 credit per API call**

Tatum supports BIP44 HD wallets. It is very convenient and secure, since it can generate 2^31 addresses from 1 mnemonic phrase. Mnemonic phrase consists of 24 special words in defined order and can restore access to all generated addresses and private keys. Each address is identified by 3 main values:
* Private Key - your secret value, which should never be revealed
* Public Key - public address to be published
* Derivation index - index of generated address

Tatum follows BIP44 specification and generates for Kcs wallet with derivation path m'/44'/966'/0'/0\. More about BIP44 HD wallets can be found here - [https://github.com/bitcoin/bips/blob/master/bip-0044.mediawiki](https://github.com/bitcoin/bips/blob/master/bip-0044.mediawiki). Generate BIP44 compatible Kcs wallet.

[Back to top](#top){: .btn .btn-purple }

---


## `kcsGetBalance()`

### Example

{: .new-title }
> #️⃣ Execute command in terminal 
> 
> [✨ php -f **kcsGetBalance.php**](https://github.com/tatumio/tatum-php/blob/master/examples/Api/KuCoinApi/kcsGetBalance.php){: .btn .btn-green .mt-4}

### Request

> **GET** `/v3/kcs/account/balance/{address}`

### Type signature

```php
(new \Tatum\Sdk())->{mainnet/testnet}()->api()->kuCoin()->kcsGetBalance(
    string $address
): \Tatum\Model\KcsGetBalance200Response
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **$address** | **string**  | Account address you want to get balance of |

### Return type

[**\Tatum\Model\KcsGetBalance200Response**](../../Model/KcsGetBalance200Response)

### Description

> Get Kcs Account balance

**1 credit per API call**

Get Kcs account balance in KCS. This method does not prints any balance of the ERC20 or ERC721 tokens on the account.

[Back to top](#top){: .btn .btn-purple }

---


## `kcsGetBlock()`

### Example

{: .new-title }
> #️⃣ Execute command in terminal 
> 
> [✨ php -f **kcsGetBlock.php**](https://github.com/tatumio/tatum-php/blob/master/examples/Api/KuCoinApi/kcsGetBlock.php){: .btn .btn-green .mt-4}

### Request

> **GET** `/v3/kcs/block/{hash}`

### Type signature

```php
(new \Tatum\Sdk())->{mainnet/testnet}()->api()->kuCoin()->kcsGetBlock(
    string $hash
): \Tatum\Model\EthBlock
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **$hash** | **string**  | Block hash or block number |

### Return type

[**\Tatum\Model\EthBlock**](../../Model/EthBlock)

### Description

> Get Kcs block by hash

**1 credit per API call**

Get Kcs block by block hash or block number.

[Back to top](#top){: .btn .btn-purple }

---


## `kcsGetCurrentBlock()`

### Example

{: .new-title }
> #️⃣ Execute command in terminal 
> 
> [✨ php -f **kcsGetCurrentBlock.php**](https://github.com/tatumio/tatum-php/blob/master/examples/Api/KuCoinApi/kcsGetCurrentBlock.php){: .btn .btn-green .mt-4}

### Request

> **GET** `/v3/kcs/block/current`

### Type signature

```php
(new \Tatum\Sdk())->{mainnet/testnet}()->api()->kuCoin()->kcsGetCurrentBlock(): float
```

### Parameters

This endpoint does not need any parameter.

### Return type

**float**

### Description

> Get current block number

**1 credit per API call**

Get Kcs current block number. This is the number of the latest block in the blockchain.

[Back to top](#top){: .btn .btn-purple }

---


## `kcsGetTransaction()`

### Example

{: .new-title }
> #️⃣ Execute command in terminal 
> 
> [✨ php -f **kcsGetTransaction.php**](https://github.com/tatumio/tatum-php/blob/master/examples/Api/KuCoinApi/kcsGetTransaction.php){: .btn .btn-green .mt-4}

### Request

> **GET** `/v3/kcs/transaction/{hash}`

### Type signature

```php
(new \Tatum\Sdk())->{mainnet/testnet}()->api()->kuCoin()->kcsGetTransaction(
    string $hash
): \Tatum\Model\KcsTx
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **$hash** | **string**  | Transaction hash |

### Return type

[**\Tatum\Model\KcsTx**](../../Model/KcsTx)

### Description

> Get Kcs Transaction

**2 credits per API call**

Get Kcs transaction by transaction hash.

[Back to top](#top){: .btn .btn-purple }

---


## `kcsGetTransactionCount()`

### Example

{: .new-title }
> #️⃣ Execute command in terminal 
> 
> [✨ php -f **kcsGetTransactionCount.php**](https://github.com/tatumio/tatum-php/blob/master/examples/Api/KuCoinApi/kcsGetTransactionCount.php){: .btn .btn-green .mt-4}

### Request

> **GET** `/v3/kcs/transaction/count/{address}`

### Type signature

```php
(new \Tatum\Sdk())->{mainnet/testnet}()->api()->kuCoin()->kcsGetTransactionCount(
    string $address
): float
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **$address** | **string**  | address |

### Return type

**float**

### Description

> Get count of outgoing Kcs transactions

**1 credit per API call**

Get a number of outgoing Kcs transactions for the address. When a transaction is sent, there can be multiple outgoing transactions, which are not yet processed by the blockchain. To distinguish between them, there is a counter called a nonce, which represents the order of the transaction in the list of outgoing transactions.

[Back to top](#top){: .btn .btn-purple }

---


## `transferKcsBlockchain()`

### Example

{: .new-title }
> #️⃣ Execute command in terminal 
> 
> [✨ php -f **transferKcsBlockchain.php**](https://github.com/tatumio/tatum-php/blob/master/examples/Api/KuCoinApi/transferKcsBlockchain.php){: .btn .btn-green .mt-4}

### Request

> **POST** `/v3/kcs/transaction`

### Type signature

```php
(new \Tatum\Sdk())->{mainnet/testnet}()->api()->kuCoin()->transferKcsBlockchain(
    \Tatum\Model\TransferKcsBlockchain $transfer_kcs_blockchain
): \Tatum\Model\TransactionSigned
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **$transfer_kcs_blockchain** | [**\Tatum\Model\TransferKcsBlockchain**](../../Model/TransferKcsBlockchain) |  |

### Return type

[**\Tatum\Model\TransactionSigned**](../../Model/TransactionSigned)

### Description

> Send KCS from account to account

**2 credits per API call**

Send KCS from account to account.

**Signing a transaction**

When sending KCS, you are charged a fee for the transaction, and you must sign the transaction with the private key of the blockchain address from which the fee will be deducted.

Providing the private key in the API is not a secure way of signing transactions, because the private key can be stolen or exposed. Your private keys should never leave your security perimeter. You should use the private keys only for testing a solution you are building on the **testnet** of a blockchain.

For signing transactions on the **mainnet**, we strongly recommend that you use the Tatum [Key Management System (KMS)](https://github.com/tatumio/tatum-kms) and provide the signature ID instead of the private key in the API. Alternatively, you can use the [Tatum JavaScript client](https://github.com/tatumio/tatum-js).

 Alternatively, using the Tatum client library for supported languages.

[Back to top](#top){: .btn .btn-purple }

---


## `transferKcsBlockchainKMS()`

### Example

{: .new-title }
> #️⃣ Execute command in terminal 
> 
> [✨ php -f **transferKcsBlockchainKMS.php**](https://github.com/tatumio/tatum-php/blob/master/examples/Api/KuCoinApi/transferKcsBlockchainKMS.php){: .btn .btn-green .mt-4}

### Request

> **POST** `/v3/kcs/transaction`

### Type signature

```php
(new \Tatum\Sdk())->{mainnet/testnet}()->api()->kuCoin()->transferKcsBlockchainKMS(
    \Tatum\Model\TransferKcsBlockchainKMS $transfer_kcs_blockchain_kms
): \Tatum\Model\TransactionSigned
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **$transfer_kcs_blockchain_kms** | [**\Tatum\Model\TransferKcsBlockchainKMS**](../../Model/TransferKcsBlockchainKMS) |  |

### Return type

[**\Tatum\Model\TransactionSigned**](../../Model/TransactionSigned)

### Description

> Send KCS from account to account



[Back to top](#top){: .btn .btn-purple }

---
