<style>
    .custom-pagination {
        display: flex;
        flex-wrap: nowrap;    /* Prevent wrapping */
        list-style: none;
        padding: 0;
        margin: 0;
        gap: 6px;              /* Space between items */
    }

    .custom-pagination li {
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 50% !important;
    }

    .custom-pagination a, 
    .custom-pagination span {
        display: block;
        padding: 8px 12px;
        border: 1px solid #ddd;
        border-radius: 4px;
        text-decoration: none;
        color: #333;
        min-width: 40px;
        text-align: center;
        border-radius: 50% !important;
    }

    .custom-pagination .active span {
        background-color: rgb(67, 126, 157);
        color: white;
        border-color: rgb(67, 126, 157);
    }

    .custom-pagination .disabled span {
        color: #999;
        cursor: not-allowed;
    }

    /* Ensure the pagination stays inside its container */
    .card-body {
        overflow-x: auto;
    }
</style>


<?php if($paginator->hasPages()): ?> 
<div class="card">
    <div class="card-body">
        <nav>
            <ul class="pagination custom-pagination">
                    
                    <?php if($paginator->onFirstPage()): ?>
                        <li class="disabled" aria-disabled="true" aria-label="<?php echo app('translator')->get('pagination.previous'); ?>">
                            <span aria-hidden="true">&lsaquo;</span>
                        </li>
                    <?php else: ?>
                        <li>
                            <a href="<?php echo e($paginator->previousPageUrl()); ?>" rel="prev" aria-label="<?php echo app('translator')->get('pagination.previous'); ?>">&lsaquo;</a>
                        </li>
                    <?php endif; ?>

                    
                    <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(is_string($element)): ?>
                            <li class="disabled" aria-disabled="true"><span><?php echo e($element); ?></span></li>
                        <?php endif; ?>

                        <?php if(is_array($element)): ?>
                            <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($page == $paginator->currentPage()): ?>
                                    <li class="active" aria-current="page"><span><?php echo e($page); ?></span></li>
                                <?php else: ?>
                                    <li><a href="<?php echo e($url); ?>"><?php echo e($page); ?></a></li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    
                    <?php if($paginator->hasMorePages()): ?>
                        <li>
                            <a href="<?php echo e($paginator->nextPageUrl()); ?>" rel="next" aria-label="<?php echo app('translator')->get('pagination.next'); ?>">&rsaquo;</a>
                        </li>
                    <?php else: ?>
                        <li class="disabled" aria-disabled="true" aria-label="<?php echo app('translator')->get('pagination.next'); ?>">
                            <span aria-hidden="true">&rsaquo;</span>
                        </li>
                    <?php endif; ?>
                </ul>
            </nav>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /Applications/MAMP/htdocs/virus/resources/views/vendor/pagination/bootstrap-4.blade.php ENDPATH**/ ?>