<?php $__env->startSection('title', $title); ?>
<?php $__env->startSection('content'); ?>
   
  <body class="">
    <div
      class="container px-6 pb-8 pt-12 h-dvh text-n900 dark:bg-n0 flex flex-col"
    >
      <div class="flex justify-center items-center text-center flex-col">
        
        <h1 class="text-2xl font-medium dark:text-white">Enter OTP</h1>
        <p class="tet-sm text-n500 dark:text-darkN500 pt-3 px-4">
        
        </p>
      </div>

      <form class="flex flex-col gap-4 pt-8 relative flex-1 otp-form" id="otpForm" method="POST" action="<?php echo e(route('otp.verify')); ?>">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="email" value="<?php echo e(request('email')); ?>">
        <input type="hidden" name="otp" id="otp">
    
        <div class="flex justify-center gap-3">
            <?php for($i = 0; $i < 4; $i++): ?>
                <div class="size-[54px] rounded-xl bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 p-3.5 focus-within:border-g300 dark:text-white">
                    <input type="text" class="otp-input w-full bg-transparent outline-none text-center" maxlength="1" />
                </div>
            <?php endfor; ?>
        </div>
    
        <div class="absolute bottom-0 left-0 right-0 flex">
            <button type="submit" id="verifyBtn" class="flex-1 py-3 bg-g300 text-white text-center rounded-xl">
                Verify OTP
            </button>
        </div>
    </form>
    
    </div>   
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
  $(document).ready(function() {
      $('.otp-input').on('input', function() {
          if (this.value.length === 1) {
              $(this).parent().next().find('.otp-input').focus();
          }
      });
  
      $('#otpForm').on('submit', function(e) {
          e.preventDefault();
  
          var otpCode = '';
          $('.otp-input').each(function() {
              otpCode += $(this).val();
          });
  
          if (otpCode.length !== 4) {
              toastr.error("Please enter the 4-digit OTP.", "Error");
              return;
          }
  
          $('#otp').val(otpCode);
  
          var $button = $('#verifyBtn');
          $button.text('Processing...').prop('disabled', true);
  
          $.ajax({
              url: $(this).attr('action'),
              method: 'POST',
              data: $(this).serialize(),
              headers: { 'Accept': 'application/json' },
              success: function(response) {
                  if (response.success) {
                      toastr.success("OTP Verified", "Success", { timeOut: 1500, progressBar: true });
                      setTimeout(function() {
                          window.location.href = response.redirect;
                      }, 1500);
                  } else {
                      toastr.error(response.message, "OTP Failed", { timeOut: 3000, progressBar: true });
                      $button.text('Verify OTP').prop('disabled', false);
                  }
              },
              error: function(xhr) {
                  var message = xhr.responseJSON?.message || 'Something went wrong.';
                  toastr.error(message, "Error", { timeOut: 3000, progressBar: true });
                  $button.text('Verify OTP').prop('disabled', false);
              }
          });
      });
  });
  </script>
  
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.mulaauth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/virus/resources/views/auth/verifyotp.blade.php ENDPATH**/ ?>